/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.services;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.PossibleRelatedValueImplied2;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.services.ComponentNamingStrategy;
import org.simantics.modeling.services.NamingException;
import org.simantics.operation.Layer0X;
import org.simantics.project.IProject;
import org.simantics.structural.stubs.StructuralResource2;

public final class ComponentNamingUtil {
    private static final boolean DEBUG = false;

    public static final String validateInstanceName(ReadGraph graph, IProject project, Resource configurationRoot, Resource composite, Resource componentType, String proposition, boolean acceptProposition) throws DatabaseException, NamingException {
        ComponentNamingStrategy strategy = ComponentNamingUtil.findNamingStrategy(graph, project, composite);
        if (strategy != null) {
            proposition = strategy.validateInstanceName(graph, configurationRoot, composite, componentType, proposition, acceptProposition);
        }
        if (proposition == null) {
            proposition = ComponentNamingUtil.fallbackNameGeneration(graph, composite, componentType);
        }
        return proposition;
    }

    public static final String validateInstanceName(ReadGraph graph, IProject project, Resource configurationRoot, Resource component, String proposition, boolean acceptProposition) throws DatabaseException, NamingException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource composite = graph.getPossibleObject(component, L0.PartOf);
        ComponentNamingStrategy strategy = ComponentNamingUtil.findNamingStrategy(graph, project, composite);
        if (strategy != null) {
            return strategy.validateInstanceName(graph, configurationRoot, component, proposition, acceptProposition);
        }
        return null;
    }

    public static final String findFreshInstanceName(ReadGraph graph, IProject project, Resource configurationRoot, Resource composite, Resource componentType) throws DatabaseException, NamingException {
        String proposition = null;
        ComponentNamingStrategy strategy = ComponentNamingUtil.findNamingStrategy(graph, project, composite);
        if (strategy != null) {
            proposition = strategy.findFreshInstanceName(graph, configurationRoot, composite, componentType);
        }
        if (proposition == null) {
            proposition = ComponentNamingUtil.fallbackNameGeneration(graph, composite, componentType);
        }
        return proposition;
    }

    public static final String findFreshEscapedInstanceName(ReadGraph graph, IProject project, Resource configurationRoot, Resource composite, Resource componentType) throws DatabaseException, NamingException {
        String proposition = ComponentNamingUtil.findFreshInstanceName(graph, project, configurationRoot, composite, componentType);
        proposition = URIStringUtils.escape((String)proposition);
        return proposition;
    }

    public static final String validateInstanceName(ReadGraph graph, IProject project, Resource configurationRoot, Resource composite, Resource componentType, Set<String> externallyReserved) throws DatabaseException, NamingException {
        ComponentNamingStrategy strategy = ComponentNamingUtil.findNamingStrategy(graph, project, composite);
        if (strategy == null) {
            throw new NamingException("No naming strategy available, project=" + project + ", composite=" + composite + ", componentType=" + componentType);
        }
        String proposition = ComponentNamingUtil.generateProposition(graph, composite, componentType);
        List<String> validated = strategy.validateInstanceNames(graph, configurationRoot, Collections.singletonList(proposition), true, externallyReserved);
        proposition = validated.get(0);
        return proposition;
    }

    public static final List<String> validateInstanceNames(ReadGraph graph, IProject project, Resource configurationRoot, List<String> propositions, boolean acceptProposition, Set<String> externallyReserved) throws DatabaseException, NamingException {
        ComponentNamingStrategy strategy = ComponentNamingUtil.findNamingStrategy(graph, project, configurationRoot);
        if (strategy == null) {
            throw new NamingException("No naming strategy available, project=" + project);
        }
        return strategy.validateInstanceNames(graph, configurationRoot, propositions, acceptProposition, externallyReserved);
    }

    private static String fallbackNameGeneration(ReadGraph graph, Resource container, Resource componentType) throws DatabaseException {
        return NameUtils.findFreshName((ReadGraph)graph, (String)ComponentNamingUtil.generateProposition(graph, container, componentType), (Resource)container);
    }

    public static String generateProposition(ReadGraph graph, String containerGeneratedNamePrefix, Resource componentType) throws DatabaseException {
        String componentPrefix;
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        StringBuilder proposition = new StringBuilder();
        if (containerGeneratedNamePrefix != null) {
            proposition.append(containerGeneratedNamePrefix);
        }
        if ((componentPrefix = (String)graph.getPossibleRelatedValue(componentType, L0X.HasGeneratedNamePrefix, (Binding)Bindings.STRING)) == null) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            componentPrefix = (String)graph.getPossibleRelatedValue(componentType, L0.HasName);
            if (componentPrefix == null) {
                componentPrefix = "Entity";
            }
        }
        proposition.append(componentPrefix);
        return proposition.toString();
    }

    public static String generateProposition(ReadGraph graph, Resource container, Resource componentType) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        String containerPrefix = (String)graph.getPossibleRelatedValue(container, L0X.HasGeneratedNamePrefix, (Binding)Bindings.STRING);
        return ComponentNamingUtil.generateProposition(graph, containerPrefix != null ? containerPrefix : "", componentType);
    }

    public static final ComponentNamingStrategy findNamingStrategy(ReadGraph graph, IProject project, Resource composite) throws DatabaseException {
        ComponentNamingStrategy strategy = (ComponentNamingStrategy)graph.syncRequest((Read)new PossibleRelatedValueImplied2(composite, StructuralResource2.getInstance((ReadGraph)graph).Composite_namingFunction), (Listener)TransientCacheListener.instance());
        if (strategy == null && project != null) {
            strategy = (ComponentNamingStrategy)project.getHint(ComponentNamingStrategy.PROJECT_KEY);
        }
        return strategy;
    }
}

