/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl;

import gnu.trove.map.hash.THashMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.scl.OntologyModule;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.java.CheckRelation;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.query.QConjunction;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class GraphEntityType
implements SCLEntityType {
    Resource type;
    THashMap<String, GraphAttribute> attributeMap = new THashMap();
    private static final Name DB_isInstanceOf = Name.create((String)"Simantics/DB", (String)"isInstanceOf");

    public GraphEntityType(ReadGraph graph, Resource type) throws DatabaseException {
        this.type = type;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource stype : graph.getSupertypes(type)) {
            this.addSupertype(graph, L0, stype);
        }
        this.addSupertype(graph, L0, type);
        this.addRelation(graph, L0, L0.PartOf);
    }

    private void addSupertype(ReadGraph graph, Layer0 L0, Resource type) throws DatabaseException {
        for (Resource relation : graph.getObjects(type, L0.DomainOf)) {
            this.addRelation(graph, L0, relation);
        }
    }

    private void addRelation(ReadGraph graph, Layer0 L0, Resource relation) throws DatabaseException {
        String relationName = (String)graph.getRelatedValue(relation, L0.HasName, (Binding)Bindings.STRING);
        this.attributeMap.put((Object)relationName, (Object)new GraphAttribute(OntologyModule.createRelation(graph, relation)));
    }

    public Query generateQuery(TranslationContext context, Variable base, SCLEntityType.AttributeBinding[] attributeBindings) {
        Query[] queries = new Query[attributeBindings.length + 1];
        int i = 0;
        while (i < attributeBindings.length) {
            SCLEntityType.AttributeBinding binding = attributeBindings[i];
            GraphAttribute attribute = (GraphAttribute)binding.attribute;
            SCLRelation relation = attribute.relation;
            queries[i] = new QAtom(relation, new Expression[]{new EVariable(base), new EVariable(binding.variable)});
            ++i;
        }
        queries[attributeBindings.length] = new QAtom((SCLRelation)CheckRelation.INSTANCE, new Expression[]{new EApply((Expression)new EConstant(context.getEnvironment().getValue(DB_isInstanceOf)), new Expression[]{new EVariable(base), Expressions.externalConstant((Object)this.type, (Type)Types.RESOURCE)})});
        return new QConjunction(queries);
    }

    public SCLEntityType.Attribute getAttribute(String name) {
        return (SCLEntityType.Attribute)this.attributeMap.get((Object)name);
    }

    public static class GraphAttribute
    implements SCLEntityType.Attribute {
        SCLRelation relation;
        Expression[] evidence;

        public GraphAttribute(SCLRelation relation) {
            this.relation = relation;
        }
    }
}

