/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.function.DbConsumer;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.adapter.impl.DefaultCopyHandler;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.structural.stubs.StructuralResource2;

public class CompositeCopyHandler
extends DefaultCopyHandler {
    public CompositeCopyHandler(Resource composite) {
        super(composite);
    }

    public CompositeCopyHandler(Collection<Resource> composites) {
        super(composites);
    }

    protected TransferableGraphConfiguration2 createConfiguration(ReadGraph graph, boolean cut) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 SR = StructuralResource2.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Set resourceSet = this.resources instanceof Set ? (Set)this.resources : new HashSet(this.resources);
        HashSet<Resource> exclusions = new HashSet<Resource>();
        HashSet externals = new HashSet();
        ArrayList<TransferableGraphConfiguration2.RootSpec> roots = new ArrayList<TransferableGraphConfiguration2.RootSpec>();
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot((Resource)this.resources.iterator().next()));
        if (indexRoot == null) {
            throw new DatabaseException("Composite is not part of any index root");
        }
        String indexRootUri = graph.getURI(indexRoot);
        DbConsumer identifierExcluder = r -> {
            if (r != null) {
                exclusions.addAll(graph.getObjects(r, layer0.identifier));
            }
        };
        for (Resource resource : this.resources) {
            for (Resource diagram : graph.getObjects(resource, MOD.CompositeToDiagram)) {
                identifierExcluder.accept((Object)diagram);
                for (Resource element : graph.getObjects(diagram, L0.ConsistsOf)) {
                    identifierExcluder.accept((Object)element);
                    Set types = graph.getTypes(element);
                    if (types.contains(DIA.Flag)) {
                        for (Resource join : graph.getObjects(element, DIA.FlagIsJoinedBy)) {
                            for (Resource comp : graph.getObjects(join, SR.JoinsComposite)) {
                                if (resourceSet.contains(comp)) continue;
                                exclusions.add(join);
                            }
                            for (Resource flag2 : graph.getObjects(join, DIA.JoinsFlag)) {
                                Resource comp;
                                Resource diagram2 = graph.getPossibleObject(flag2, L0.PartOf);
                                if (diagram2 == null || resourceSet.contains(comp = graph.getPossibleObject(diagram2, MOD.DiagramToComposite))) continue;
                                exclusions.add(join);
                            }
                        }
                    }
                    if (types.contains(DIA.Monitor)) {
                        for (Resource monitoredComponent : graph.getObjects(element, DIA.HasMonitorComponent)) {
                            Resource monitoredComponentComposite = graph.getPossibleObject(monitoredComponent, L0.PartOf);
                            if (monitoredComponentComposite == null || resourceSet.contains(monitoredComponentComposite)) continue;
                            exclusions.add(monitoredComponent);
                        }
                    }
                    if (!types.contains(MOD.ReferenceElement)) continue;
                    for (Resource rel : graph.getObjects(element, L0.ConsistsOf)) {
                        identifierExcluder.accept((Object)rel);
                        for (Resource invRel : graph.getObjects(rel, L0.ConsistsOf)) {
                            identifierExcluder.accept((Object)invRel);
                        }
                    }
                }
            }
            for (Resource ref : (Collection)graph.syncRequest((Read)new ObjectsWithType(resource, L0.ConsistsOf, SR.Component))) {
                for (Resource monitor : graph.getObjects(ref, DIA.HasMonitorComponent_Inverse)) {
                    Resource monitorComposite;
                    Resource monitorDiagram = graph.getPossibleObject(monitor, L0.PartOf);
                    if (monitorDiagram == null || (monitorComposite = graph.getPossibleObject(monitorDiagram, MOD.DiagramToComposite)) == null || resourceSet.contains(monitorComposite)) continue;
                    exclusions.add(monitor);
                }
            }
            ModelingUtils.CompositeInfo info = ModelingUtils.CompositeInfo.fromResource(graph, resource);
            roots.add(new TransferableGraphConfiguration2.RootSpec(resource, info.getTGName(), true, CompositeCopyHandler.typeId(graph, L0, indexRootUri, resource)));
            identifierExcluder.accept((Object)resource);
            for (Resource child : (Collection)graph.sync((ReadInterface)new ObjectsWithType(resource, L0.ConsistsOf, SR.Component))) {
                ModelingUtils.DiagramComponentInfo cinfo = ModelingUtils.DiagramComponentInfo.fromResource(graph, info, child);
                identifierExcluder.accept((Object)child);
                roots.add(new TransferableGraphConfiguration2.RootSpec(child, cinfo.getTGName(info), true, CompositeCopyHandler.typeId(graph, L0, indexRootUri, child)));
            }
        }
        roots.add(new TransferableGraphConfiguration2.RootSpec(indexRoot, "%model", false));
        TransferableGraphConfiguration2 config = TransferableGraphConfiguration2.createWithNames2((RequestProcessor)graph, roots, exclusions, (boolean)true, (boolean)false);
        for (Resource external : externals) {
            config.preStatus.put(external, SubgraphExtent.ExtentStatus.EXTERNAL);
        }
        return config;
    }

    private static String typeId(ReadGraph graph, Layer0 L0, String indexRootUri, Resource r) throws DatabaseException {
        Resource type = graph.getPossibleType(r, L0.Entity);
        if (type == null) {
            return "http://www.simantics.org/Layer0-1.1/Entity";
        }
        String typeUri = graph.getPossibleURI(type);
        if (typeUri == null || !typeUri.startsWith(indexRootUri)) {
            return typeUri;
        }
        return "%model" + typeUri.substring(indexRootUri.length());
    }
}

