/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.simantics.databoard.util.binary.BinaryFile;
import org.simantics.databoard.util.binary.RandomAccessBinary;

public class ResourceData
implements RandomAccessBinary {
    private boolean changed = false;
    public final BinaryFile binaryFile;
    public final boolean oldExternalValue;

    public ResourceData(BinaryFile binaryFile, boolean oldExternalValue) {
        this.binaryFile = binaryFile;
        this.oldExternalValue = oldExternalValue;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void writeFully(ByteBuffer src) throws IOException {
        this.binaryFile.writeFully(src);
        this.changed = true;
    }

    public void writeFully(ByteBuffer src, int length) throws IOException {
        this.binaryFile.writeFully(src, length);
        this.changed = true;
    }

    public void write(int b) throws IOException {
        this.binaryFile.write(b);
        this.changed = true;
    }

    public void write(byte[] b) throws IOException {
        this.binaryFile.write(b);
        this.changed = true;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.binaryFile.write(b, off, len);
        this.changed = true;
    }

    public void writeBoolean(boolean v) throws IOException {
        this.binaryFile.writeBoolean(v);
        this.changed = true;
    }

    public void writeByte(int v) throws IOException {
        this.binaryFile.writeByte(v);
        this.changed = true;
    }

    public void writeShort(int v) throws IOException {
        this.binaryFile.writeShort(v);
        this.changed = true;
    }

    public void writeChar(int v) throws IOException {
        this.binaryFile.writeChar(v);
        this.changed = true;
    }

    public void writeInt(int v) throws IOException {
        this.binaryFile.writeInt(v);
        this.changed = true;
    }

    public void writeLong(long v) throws IOException {
        this.binaryFile.writeLong(v);
        this.changed = true;
    }

    public void writeFloat(float v) throws IOException {
        this.binaryFile.writeFloat(v);
        this.changed = true;
    }

    public void writeDouble(double v) throws IOException {
        this.binaryFile.writeDouble(v);
        this.changed = true;
    }

    public void writeBytes(String s) throws IOException {
        this.binaryFile.writeBytes(s);
        this.changed = true;
    }

    public void writeChars(String s) throws IOException {
        this.binaryFile.writeChars(s);
        this.changed = true;
    }

    public void writeUTF(String s) throws IOException {
        this.binaryFile.writeUTF(s);
        this.changed = true;
    }

    public long skipBytes(long bytes) throws IOException {
        return this.binaryFile.skipBytes(bytes);
    }

    public void readFully(ByteBuffer buf) throws IOException {
        this.binaryFile.readFully(buf);
    }

    public void readFully(ByteBuffer buf, int length) throws IOException {
        this.binaryFile.readFully(buf, length);
    }

    public void readFully(byte[] b) throws IOException {
        this.binaryFile.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.binaryFile.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this.binaryFile.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.binaryFile.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.binaryFile.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.binaryFile.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.binaryFile.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.binaryFile.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.binaryFile.readChar();
    }

    public int readInt() throws IOException {
        return this.binaryFile.readInt();
    }

    public long readLong() throws IOException {
        return this.binaryFile.readLong();
    }

    public float readFloat() throws IOException {
        return this.binaryFile.readFloat();
    }

    public double readDouble() throws IOException {
        return this.binaryFile.readDouble();
    }

    public String readLine() throws IOException {
        return this.binaryFile.readLine();
    }

    public String readUTF() throws IOException {
        return this.binaryFile.readUTF();
    }

    public void flush() throws IOException {
        this.binaryFile.flush();
    }

    public void reset() throws IOException {
        this.binaryFile.reset();
        this.changed = true;
    }

    public void removeBytes(long bytes, RandomAccessBinary.ByteSide side) throws IOException {
        this.binaryFile.removeBytes(bytes, side);
        this.changed = true;
    }

    public void insertBytes(long bytes, RandomAccessBinary.ByteSide side) throws IOException {
        this.binaryFile.insertBytes(bytes, side);
        this.changed = true;
    }

    public void setLength(long newLength) throws IOException {
        this.binaryFile.setLength(newLength);
        this.changed = true;
    }

    public long length() throws IOException {
        return this.binaryFile.length();
    }

    public void close() throws IOException {
        this.binaryFile.close();
    }

    public boolean isOpen() {
        return this.binaryFile.isOpen();
    }

    public void position(long newPosition) throws IOException {
        this.binaryFile.position(newPosition);
    }

    public long position() throws IOException {
        return this.binaryFile.position();
    }
}

