/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.formula;

import org.simantics.spreadsheet.graph.CellFormulaFunction;
import org.simantics.spreadsheet.graph.CellValueVisitor;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.graph.formula.FormulaError2;
import org.simantics.spreadsheet.graph.parser.ast.AstArgList;

public class RoundupFormulaFunction
implements CellFormulaFunction<Object> {
    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() != 2) {
            throw new IllegalStateException();
        }
        Object number = args.values.get(0).accept(visitor);
        Object digits = args.values.get(1).accept(visitor);
        FormulaError2 err1 = FormulaError2.forObject(number);
        if (err1 != null) {
            return err1.getString();
        }
        FormulaError2 err2 = FormulaError2.forObject(digits);
        if (err2 != null) {
            return err2.getString();
        }
        double n = SpreadsheetGraphUtils.asNumber(number);
        double n2 = SpreadsheetGraphUtils.asNumber(digits);
        Double scale = Math.pow(10.0, n2);
        double l = Math.ceil(scale * n);
        Double d = l / scale;
        return d;
    }
}

