/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation.utils;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.operation.Layer0X;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.Module;
import org.simantics.sysdyn.representation.Shadow;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.unitParser.ParseException;
import org.simantics.sysdyn.unitParser.TokenMgrError;
import org.simantics.sysdyn.unitParser.UnitCheckingException;
import org.simantics.sysdyn.unitParser.UnitCheckingNode;
import org.simantics.sysdyn.unitParser.UnitParser;
import org.simantics.sysdyn.unitParser.nodes.ComponentReferenceFull;
import org.simantics.sysdyn.unitParser.nodes.UnitResult;
import org.simantics.sysdyn.utils.Function;

public class UnitUtils {
    public static String expressionUnitsValid(ReadGraph graph, SysdynModel model, Configuration configuration, String expression) {
        try {
            StringReader reader = new StringReader(expression);
            UnitParser parser = new UnitParser(reader);
            System.out.println("expression " + expression);
            UnitCheckingNode node = (UnitCheckingNode)parser.expr();
            reader.close();
            Set<String> components = UnitUtils.findComponents(node);
            HashMap<String, String> units = UnitUtils.findUnits(graph, model, configuration, components);
            try {
                node.getUnits(units, Function.getAllBuiltInFunctions(graph), UnitUtils.allowEquivalents(graph, model));
            }
            catch (UnitCheckingException e) {
                return e.getMessage();
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
        catch (ParseException parseException) {
            return "Cannot validate units: Syntax error in expression.";
        }
        return null;
    }

    public static boolean allowEquivalents(ReadGraph graph, SysdynModel model) throws DatabaseException {
        Resource modelResource = (Resource)graph.syncRequest((Read)new PossibleModel(model.getConfigurationResource()));
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Resource unitIssueSource = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(modelResource, Layer0X.getInstance((ReadGraph)graph).Activates, sr.Validations_Units_UnitIssueSource));
        if (unitIssueSource == null) {
            return false;
        }
        Boolean result = (Boolean)graph.getPossibleRelatedValue(unitIssueSource, sr.Validations_Units_UnitIssueSource_allowEquivalents, (Binding)Bindings.BOOLEAN);
        if (result == null) {
            result = false;
        }
        return result;
    }

    public static String matchUnits(ReadGraph graph, SysdynModel model, Configuration configuration, String unit, String expression) {
        if (unit == null) {
            return "Unit not defined";
        }
        if (expression == null) {
            return "Expression not defined";
        }
        try {
            StringReader rightReader = new StringReader(expression);
            UnitParser rightParser = new UnitParser(rightReader);
            UnitCheckingNode right = (UnitCheckingNode)rightParser.expr();
            rightReader.close();
            Set<String> components = UnitUtils.findComponents(right);
            HashMap<String, String> units = UnitUtils.findUnits(graph, model, configuration, components);
            try {
                StringReader leftReader = new StringReader(unit);
                UnitParser leftParser = new UnitParser(leftReader);
                UnitCheckingNode left = (UnitCheckingNode)leftParser.expr();
                leftReader.close();
                try {
                    ArrayList<Function> functions = Function.getAllBuiltInFunctions(graph);
                    boolean allowEquivalents = UnitUtils.allowEquivalents(graph, model);
                    UnitResult rightUnits = right.getUnits(units, functions, allowEquivalents);
                    UnitResult leftUnits = left.getUnits(null, functions, allowEquivalents);
                    if (!rightUnits.equals(leftUnits)) {
                        return String.valueOf(leftUnits.getCleanFullUnit()) + " != " + rightUnits.getCleanFullUnit();
                    }
                }
                catch (UnitCheckingException e) {
                    return e.getMessage();
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }
            catch (ParseException parseException) {
                return "Syntax error in defined unit.";
            }
        }
        catch (ParseException parseException) {
            return "Cannot validate units: Syntax error in expression.";
        }
        catch (TokenMgrError tokenMgrError) {
            return "Cannot validate units: Syntax error in expression.";
        }
        return null;
    }

    public static HashMap<String, String> findUnits(ReadGraph graph, SysdynModel model, Configuration configuration, Set<String> components) {
        HashMap<String, String> units = new HashMap<String, String>();
        for (String component : components) {
            Resource varResource;
            Variable var = UnitUtils.getElement(configuration, component);
            if (var == null || graph == null || model == null) continue;
            if (var instanceof Shadow) {
                var = ((Shadow)var).getOriginal();
            }
            if ((varResource = model.getMapping().inverseGet((Object)var)) == null) continue;
            try {
                String unit = (String)graph.getPossibleRelatedValue(varResource, SysdynResource.getInstance((ReadGraph)graph).Variable_unit);
                if (unit == null) continue;
                units.put(component, unit);
            }
            catch (ManyObjectsForFunctionalRelationException e) {
                e.printStackTrace();
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        units.put("time", UnitUtils.getTimeUnit(graph, model));
        units.put("timeStep", UnitUtils.getTimeUnit(graph, model));
        units.put("startTime", UnitUtils.getTimeUnit(graph, model));
        units.put("stopTime", UnitUtils.getTimeUnit(graph, model));
        return units;
    }

    public static String getTimeUnit(ReadGraph graph, SysdynModel model) {
        try {
            Resource modelResource = (Resource)graph.syncRequest((Read)new PossibleModel(model.getConfigurationResource()));
            if (modelResource != null) {
                String timeUnit = (String)graph.getPossibleRelatedValue(modelResource, SysdynResource.getInstance((ReadGraph)graph).SysdynModel_timeUnit);
                if (timeUnit == null) {
                    timeUnit = "month";
                }
                return timeUnit;
            }
        }
        catch (ManyObjectsForFunctionalRelationException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Variable getElement(Configuration configuration, String name) {
        String[] elements = name.split("\\.");
        String element = elements[0];
        for (IElement e : configuration.getElements()) {
            Module mod;
            if (e instanceof Variable) {
                Variable var = (Variable)e;
                try {
                    if (!element.equals(var.getName())) continue;
                    return var;
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                    System.out.println("See UnitUtils");
                    return null;
                }
            }
            if (!(e instanceof Module) || elements.length <= 1 || !(mod = (Module)e).getName().equals(element)) continue;
            return UnitUtils.getElement(mod.getType().getConfiguration(), name.substring(name.indexOf(".") + 1));
        }
        return null;
    }

    public static Set<String> findComponents(UnitCheckingNode node) {
        HashSet<String> components = new HashSet<String>();
        UnitUtils.addComponents(node, components);
        return components;
    }

    private static void addComponents(UnitCheckingNode node, HashSet<String> components) {
        if (node instanceof ComponentReferenceFull) {
            components.add(node.printNode());
        } else {
            int i = 0;
            while (i < node.jjtGetNumChildren()) {
                UnitUtils.addComponents((UnitCheckingNode)node.jjtGetChild(i), components);
                ++i;
            }
        }
    }

    public static String matchUnits(String left, String right, ArrayList<Function> functions, boolean allowEquivalents) throws DatabaseException {
        if (left == null || right == null || left.isEmpty() || right.isEmpty()) {
            return "No unit defined";
        }
        StringReader leftReader = new StringReader(left);
        UnitParser leftParser = new UnitParser(leftReader);
        UnitCheckingNode leftNode = (UnitCheckingNode)leftParser.expr();
        leftReader.close();
        try {
            StringReader rightReader = new StringReader(right);
            UnitParser rightParser = new UnitParser(rightReader);
            UnitCheckingNode rightNode = (UnitCheckingNode)rightParser.expr();
            rightReader.close();
            try {
                UnitResult leftUnits = leftNode.getUnits(null, functions, allowEquivalents);
                UnitResult rightUnits = rightNode.getUnits(null, functions, allowEquivalents);
                if (!rightUnits.equals(leftUnits)) {
                    return String.valueOf(leftUnits.getCleanFullUnit()) + " != " + rightUnits.getCleanFullUnit();
                }
            }
            catch (UnitCheckingException e) {
                return e.getMessage();
            }
        }
        catch (ParseException parseException) {
            try {
                return "Cannot validate units: Syntax error in expression.";
            }
            catch (ParseException parseException2) {
                return "Syntax error in defined unit.";
            }
        }
        return null;
    }
}

