/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter.distribution;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.adapter.distribution.IDistribution;

public class UniformDistribution
implements IDistribution {
    private double min;
    private double max;

    public UniformDistribution(ReadGraph graph, Resource distribution) {
        try {
            Double maxValue;
            SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
            Double minValue = (Double)graph.getPossibleRelatedValue(distribution, SR.UniformDistribution_minValue, (Binding)Bindings.DOUBLE);
            if (minValue != null) {
                this.min = minValue;
            }
            if ((maxValue = (Double)graph.getPossibleRelatedValue(distribution, SR.UniformDistribution_maxValue, (Binding)Bindings.DOUBLE)) != null) {
                this.max = maxValue;
            }
        }
        catch (DatabaseException databaseException) {}
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    @Override
    public double inverseCDF(double probability) {
        return this.min + probability * (this.max - this.min);
    }
}

