/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClientChangesImpl;
import fi.vtt.simantics.procore.internal.ClusterStream;
import fi.vtt.simantics.procore.internal.ClusterTable;
import fi.vtt.simantics.procore.internal.GraphSession;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.SynchronizeContext;
import fi.vtt.simantics.procore.internal.TransactionToken;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.simantics.db.ChangeSet;
import org.simantics.db.Operation;
import org.simantics.db.VirtualGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InternalException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.request.WriteTraits;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.TransactionPolicySupport;

class State {
    static final int Closed = 1;
    static final int Closing = 2;
    static final int WriteTransaction = 4;
    static final int ReadTransaction = 8;
    static final int All = 15;
    private volatile int state = 0;
    private SessionImplSocket session = null;
    private GraphSession graphSession = null;
    private QueryProcessor queryProvider = null;
    private Lock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();
    private volatile int readCount = 0;
    private volatile int writeCount = 0;
    private Thread writeOwner = null;
    private int asyncCount = 1;
    private TransactionToken transactionToken = null;

    State() {
    }

    void setCombine(boolean a) {
        if (this.transactionToken != null) {
            this.transactionToken.setCombine(a);
        }
    }

    void setGraphSession(SessionImplSocket session, GraphSession graphSession, QueryProcessor queryProvider, ClusterTable clusterTable) {
        this.session = session;
        this.graphSession = graphSession;
        this.queryProvider = queryProvider;
        this.resetTransactionPolicy();
    }

    void resetTransactionPolicy() {
        TransactionPolicySupport tps = this.session.getService(TransactionPolicySupport.class);
        this.transactionToken = new TransactionToken(tps, this.session, this.graphSession, this.transactionToken);
    }

    int getAsyncCount() {
        return this.asyncCount;
    }

    int getReadCount() {
        return this.readCount;
    }

    int getWriteCount() {
        return this.writeCount;
    }

    boolean isWriteTransaction() {
        return (this.state & 4) != 0;
    }

    boolean isAlive() {
        return !this.isClosed() && !this.isClosing();
    }

    boolean isClosed() {
        return (this.state & 1) != 0;
    }

    boolean isClosing() {
        return (this.state & 2) != 0;
    }

    boolean isWriting() {
        return (this.state & 4) != 0;
    }

    void close() {
        boolean acquired = false;
        try {
            acquired = this.lock.tryLock(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {}
        try {
            try {
                if (this.transactionToken != null) {
                    this.transactionToken.close();
                }
                this.graphSession.stop();
            }
            catch (DatabaseException databaseException) {
                this.state = 1;
                this.session.lifecycleSupport.fireListeners(LifecycleSupport.LifecycleState.CLOSED);
                if (acquired) {
                    this.condition.signalAll();
                    this.lock.unlock();
                }
            }
        }
        finally {
            this.state = 1;
            this.session.lifecycleSupport.fireListeners(LifecycleSupport.LifecycleState.CLOSED);
            if (acquired) {
                this.condition.signalAll();
                this.lock.unlock();
            }
        }
    }

    void incAsync() {
        this.lock.lock();
        try {
            boolean closed = this.isClosed();
            boolean closing = this.isClosing();
            if (closed || closing) {
                throw new RuntimeDatabaseException(this.session + ": closed=" + closed + ", closing=" + closing);
            }
            ++this.asyncCount;
        }
        finally {
            this.lock.unlock();
        }
    }

    void decAsync() {
        this.lock.lock();
        try {
            if (this.asyncCount < 1) {
                throw new RuntimeDatabaseException(this.session + ": asyncCount=" + this.asyncCount);
            }
            if (--this.asyncCount == 0) {
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    WaitStatus waitClosing(long timeout) {
        this.lock.lock();
        try {
            if (this.isClosed()) {
                var5_2 = WaitStatus.IsClosed;
                return var5_2;
            }
            if (this.isClosing()) {
                var5_3 = WaitStatus.IsClosing;
                return var5_3;
            }
            this.state |= 2;
            try {
                block19: {
                    block18: {
                        if (timeout >= 0L) break block18;
                        i = 0;
                        ** GOTO lbl20
                        {
                            this.condition.signalAll();
                            this.condition.awaitNanos(10000000L);
                            do {
                                if (this.asyncCount > 0 || this.readCount > 0 || this.writeOwner != null && Thread.currentThread() != this.writeOwner) continue block9;
                                ++i;
lbl20:
                                // 2 sources

                            } while (i < 100);
                        }
                        while (this.asyncCount > 0 || this.readCount > 0 || this.writeOwner != null && Thread.currentThread() != this.writeOwner) {
                            this.condition.signalAll();
                            this.condition.await();
                        }
                        break block19;
                    }
                    if (timeout > 0L) {
                        interrupted = false;
                        while (!interrupted && (this.asyncCount > 0 || this.readCount > 0 || this.writeOwner != null && Thread.currentThread() != this.writeOwner)) {
                            v0 = interrupted = this.condition.await(timeout, TimeUnit.MILLISECONDS) == false;
                        }
                    }
                }
                this.transactionToken.closing();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.state &= 13;
            if (this.readCount == 0 && this.writeCount == 0 && this.asyncCount == 0) {
                var5_4 = WaitStatus.CanBeClosed;
                return var5_4;
            }
            if (this.writeOwner != null && Thread.currentThread() == this.writeOwner) {
                var5_5 = WaitStatus.Deadlock;
                return var5_5;
            }
            var5_6 = WaitStatus.Timeout;
            return var5_6;
        }
        finally {
            this.lock.unlock();
        }
    }

    void startReadTransaction(int thread) throws DatabaseException {
        this.lock.lock();
        try {
            try {
                assert (this.readCount == 0);
                this.transactionToken.startReadTransaction(thread);
                this.state |= 8;
                this.session.fireStartReadTransaction();
                ++this.readCount;
            }
            catch (Throwable e) {
                throw new DatabaseException("Failed to start read transaction.", e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void stopReadTransaction() throws DatabaseException {
        this.lock.lock();
        try {
            assert (!this.queryProvider.hasScheduledUpdates());
            assert (this.readCount == 1);
            this.session.writeSupport.gc();
            this.transactionToken.stopReadTransaction();
            this.readCount = 0;
            this.state &= 7;
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    void startWriteTransaction(int thread) throws DatabaseException {
        this.lock.lock();
        try {
            try {
                boolean closed = this.isClosed();
                boolean closing = this.isClosing();
                int ac = this.asyncCount;
                int wc = this.writeCount;
                if (closed || closing && ac < 1 || wc < 0) {
                    throw new DatabaseException(this.session + ": closed=" + closed + ", closing=" + closing + ", asyncCount=" + this.asyncCount + ", writeCount=" + this.writeCount);
                }
                if (this.writeCount == 0) {
                    this.transactionToken.startWriteTransaction(thread);
                    this.state |= 4;
                    this.writeOwner = Thread.currentThread();
                    this.session.fireStartWriteTransaction();
                }
                ++this.writeCount;
                assert (this.writeCount == 1);
            }
            catch (Throwable e) {
                throw new DatabaseException(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void writeTransactionEnded() {
        this.session.defaultClusterSet = null;
        this.session.fireFinishWriteTransaction();
    }

    void stopWriteTransaction(ClusterStream clusterStream) {
        if (!this.isAlive()) {
            return;
        }
        this.lock.lock();
        try {
            try {
                if (this.writeCount < 1) {
                    throw new IllegalStateException(this.session + ": writeCount=" + this.writeCount);
                }
                if (1 == this.writeCount) {
                    boolean empty = this.session.clusterStream.reallyFlush();
                    if (!empty) {
                        String msg = "We have modified graph (on server) without accept/cancel acknowledgment.\nThis is probably a serious error. Automatic cancel done as default recovery.";
                        Logger.defaultLogInfo((String)msg);
                        ClientChangesImpl cs = new ClientChangesImpl(this.session);
                        SynchronizeContext context = new SynchronizeContext(this.session, cs, 1);
                        this.transactionToken.cancelBegin(this.session.writeSupport, context, clusterStream);
                    }
                    this.transactionToken.stopWriteTransaction();
                    this.state &= 0xB;
                    this.writeOwner = null;
                    this.condition.signal();
                    this.writeTransactionEnded();
                }
                --this.writeCount;
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.close();
                throw new IllegalStateException(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void cancelWriteTransaction(WriteGraphImpl graph) {
        this.lock.lock();
        try {
            try {
                boolean empty;
                if (this.writeCount < 1) {
                    throw new IllegalStateException(this.session + ": writeCount=" + this.writeCount);
                }
                VirtualGraph vg = graph.getProvider();
                if (vg == null && !(empty = this.session.clusterStream.reallyFlush())) {
                    ClientChangesImpl cs = new ClientChangesImpl(this.session);
                    SynchronizeContext context = new SynchronizeContext(this.session, cs, 1);
                    this.transactionToken.cancelBegin(this.session.writeSupport, context, this.session.clusterStream);
                    try {
                        if (!context.isOk(false)) {
                            throw new InternalException("Cancel failed. This should never happen. Contact application support.");
                        }
                        this.queryProvider.performDirtyUpdates((ReadGraphImpl)graph);
                        this.queryProvider.performScheduledUpdates(graph);
                    }
                    catch (DatabaseException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                    this.transactionToken.cancelEnd(this.session.writeSupport, null, this.session.clusterStream);
                }
                this.session.writeSupport.clearMetadata();
                if (--this.writeCount == 0) {
                    this.transactionToken.stopWriteTransaction();
                    this.state &= 0xB;
                    this.writeOwner = null;
                    this.condition.signal();
                    this.writeTransactionEnded();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.close();
                throw new IllegalStateException(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void commitWriteTransaction(WriteGraphImpl graph, ClusterStream clusterStream, ChangeSet cs, WriteTraits request, Operation op) {
        assert (request != null);
        graph.commitAccessorChanges(request);
        boolean writeOnly = request instanceof WriteOnly;
        this.lock.lock();
        try {
            try {
                VirtualGraph vg = graph.getProvider();
                if (this.writeCount == 1) {
                    if (vg != null && clusterStream.isDirty()) {
                        new Exception("Internal error: virtual transaction committed changes into core (" + request + ")").printStackTrace();
                    }
                    if (vg == null) {
                        clusterStream.reallyFlush();
                    } else {
                        clusterStream.clear();
                    }
                    this.session.clientChanges = new ClientChangesImpl(this.session);
                    this.queryProvider.performScheduledUpdates(graph);
                    while (this.session.dirtyPrimitives) {
                        this.session.dirtyPrimitives = false;
                        this.queryProvider.performDirtyUpdates((ReadGraphImpl)graph);
                        this.queryProvider.performScheduledUpdates(graph);
                    }
                    if (!writeOnly) {
                        this.session.fireReactionsToCommit((ReadGraphImpl)graph, cs);
                    }
                } else {
                    throw new IllegalStateException(this.session + ": writeCount=" + this.writeCount);
                }
                this.writeTransactionEnded();
                this.session.writeSupport.gc();
                if (vg == null) {
                    this.transactionToken.commitWriteTransaction(graph.writeSupport, request, clusterStream, op);
                } else {
                    int n = this.session.writeSupport.clearMetadata();
                    if (n > 0) {
                        // empty if block
                    }
                }
                this.transactionToken.stopWriteTransaction();
                this.state &= 0xB;
                this.writeCount = 0;
                this.writeOwner = null;
                this.condition.signal();
            }
            catch (Throwable e) {
                Logger.defaultLogError((Throwable)e);
                this.close();
                throw new IllegalStateException(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void commitAndContinue(WriteGraphImpl graph, ClusterStream clusterStream, WriteTraits request) {
        VirtualGraph vg = graph.getProvider();
        if (vg != null) {
            return;
        }
        this.lock.lock();
        try {
            try {
                clusterStream.reallyFlush();
                this.transactionToken.commitWriteTransaction(graph.writeSupport, request, clusterStream, null);
                if (graph.writeSupport instanceof SessionImplSocket.WriteOnlySupport) {
                    graph.writeSupport.flushCluster();
                }
            }
            catch (Throwable e) {
                Logger.defaultLogError((Throwable)e);
                this.close();
                throw new IllegalStateException(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void commitAndContinue2(WriteGraphImpl graph, ClusterStream clusterStream, WriteTraits request) {
        VirtualGraph vg = graph.getProvider();
        if (vg != null) {
            return;
        }
        this.lock.lock();
        try {
            try {
                this.transactionToken.commitWriteTransaction(graph.writeSupport, request, clusterStream, null);
                this.transactionToken.setCombine(true);
                if (graph.writeSupport instanceof SessionImplSocket.WriteOnlySupport) {
                    graph.writeSupport.flushCluster();
                }
            }
            catch (Throwable e) {
                Logger.defaultLogError((Throwable)e);
                this.close();
                throw new IllegalStateException(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    Operation getLastOperation() {
        return this.transactionToken.getLastOperation();
    }

    long getHeadRevisionId() {
        return this.transactionToken.getHeadRevisionId();
    }

    static enum WaitStatus {
        IsClosed,
        IsClosing,
        CanBeClosed,
        Timeout,
        Deadlock;

    }
}

