/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.function;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Map;
import org.simantics.modeling.template2d.ui.function.DrawingTemplateInfo;
import org.simantics.modeling.template2d.ui.function.FlagInfo;
import org.simantics.modeling.template2d.ui.function.FlagTableInfo;

public class TranslateFlag {
    public static final float lineWidth = 0.3f;
    private FlagInfo flagInfo = null;
    private Map<String, FlagTableInfo> tables = null;
    private double[] transform = null;
    private double gridSize = 0.0;

    public TranslateFlag(FlagInfo flagInfo, Map<String, FlagTableInfo> tables, double[] transform, double gridSize) {
        this.flagInfo = flagInfo;
        this.tables = tables;
        this.transform = transform;
        this.gridSize = gridSize;
    }

    public double[] perform() {
        FlagTableInfo table = this.tables.get(this.flagInfo.flagTableName);
        if (table == null) {
            return this.transform;
        }
        double[] tableTrans = table.getTransform();
        double scale = tableTrans[3];
        double scaledRowHeigth = scale * (double)table.getRowHeight().floatValue();
        double rowMiddleY = tableTrans[5] + (double)((float)this.flagInfo.flagTableRowIndex.intValue() + 0.5f) * scaledRowHeigth;
        if (this.gridSize != 0.0) {
            double diff;
            double modulo = rowMiddleY % this.gridSize;
            int count = (int)(rowMiddleY / this.gridSize);
            double gridOnRow = modulo > this.gridSize / 2.0 ? this.gridSize * (double)(1 + count) : this.gridSize * (double)count;
            double d = diff = gridOnRow > rowMiddleY ? gridOnRow - rowMiddleY : rowMiddleY - gridOnRow;
            if (diff < scaledRowHeigth / 2.0) {
                rowMiddleY = gridOnRow;
            }
        }
        rowMiddleY = (rowMiddleY - tableTrans[5]) / scale;
        double xx = table.getAlignment() == DrawingTemplateInfo.ALIGN_RIGHT ? (double)table.getWidth().floatValue() : 0.0;
        AffineTransform trans = new AffineTransform(new double[]{tableTrans[0], tableTrans[1], tableTrans[2], tableTrans[3], 0.0, 0.0});
        Point2D.Double point = new Point2D.Double(xx, rowMiddleY);
        trans.transform(point, point);
        double[] copy = Arrays.copyOf(this.transform, this.transform.length);
        copy[4] = tableTrans[4] + ((Point2D)point).getX();
        copy[5] = tableTrans[5] + ((Point2D)point).getY();
        return copy;
    }
}

