/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.scl.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.ui.scl.expressions.SCLExpressionTableEntry;
import org.simantics.structural.stubs.StructuralResource2;

public class UsedSCLExpressionsRequest
extends UniqueRead<Collection<SCLExpressionTableEntry>> {
    public Collection<SCLExpressionTableEntry> perform(ReadGraph graph) throws DatabaseException {
        ArrayList<SCLExpressionTableEntry> result = new ArrayList<SCLExpressionTableEntry>();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        TreeSet<Resource> indexRoots = new TreeSet<Resource>();
        for (Resource ontology : Layer0Utils.listOntologies((ReadGraph)graph)) {
            if (!graph.isInstanceOf(ontology, L0.SharedOntology)) continue;
            indexRoots.add(ontology);
        }
        for (Resource child : graph.getObjects(Simantics.getProjectResource(), L0.ConsistsOf)) {
            if (!graph.isInstanceOf(child, L0.IndexRoot)) continue;
            indexRoots.add(child);
        }
        for (Resource ontology : indexRoots) {
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            List components = ModelingUtils.searchByTypeShallow((ReadGraph)graph, (Resource)ontology, (Resource)STR.Component);
            for (Resource component : components) {
                for (Statement propertyStatement : graph.getStatements(component, L0.HasProperty)) {
                    if (!graph.isInstanceOf(propertyStatement.getObject(), L0.SCLValue)) continue;
                    Resource sclValue = propertyStatement.getObject();
                    String expression = (String)graph.getPossibleRelatedValue2(sclValue, L0.SCLValue_expression);
                    Resource source = graph.getPossibleObject(sclValue, L0.PropertyOf);
                    if (source == null) continue;
                    String uri = graph.getPossibleURI(source);
                    String pred = (String)graph.getRelatedValue2(propertyStatement.getPredicate(), L0.HasName);
                    if (uri == null) continue;
                    result.add(new SCLExpressionTableEntry(expression, String.valueOf(uri) + "#" + pred, source));
                }
            }
        }
        return result;
    }
}

