/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.scl.expressions;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.scl.expressions.SCLExpressionItemFilter;
import org.simantics.modeling.ui.scl.expressions.SCLExpressionTableEntry;
import org.simantics.modeling.ui.scl.expressions.UsedSCLExpressionsRequest;
import org.simantics.ui.workbench.action.ChooseActionRequest;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class SCLExpressionView
extends ViewPart {
    private TableViewer tableViewer;
    private TableViewerColumn expressionColumn;
    private TableViewerColumn locationColumn;
    private ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
    private IStructuredContentProvider expressionContentProvider = ArrayContentProvider.getInstance();
    private SCLExpressionItemFilter expressionFilter;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        Action action = new Action("Refresh"){

            public void run() {
                SCLExpressionView.this.scheduleUpdateEntries();
            }
        };
        action.setImageDescriptor(this.imageRegistry.getDescriptor("arrow_refresh"));
        site.getActionBars().getToolBarManager().add((IAction)action);
    }

    private void createFilter(Composite parent) {
        this.expressionFilter = new SCLExpressionItemFilter();
        final Text searchText = new Text(parent, 2176);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)searchText);
        searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SCLExpressionView.this.expressionFilter.setSearchText(searchText.getText());
                SCLExpressionView.this.tableViewer.refresh();
            }
        });
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createFilter(parent);
        Composite tableParent = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableParent);
        this.tableViewer = new TableViewer(tableParent, 268501764);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)this.expressionContentProvider);
        this.tableViewer.addFilter((ViewerFilter)this.expressionFilter);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumnLayout layout = new TableColumnLayout();
        tableParent.setLayout((Layout)layout);
        this.expressionColumn = new TableViewerColumn(this.tableViewer, 0);
        this.expressionColumn.getColumn().setText("Expression");
        this.expressionColumn.getColumn().setResizable(true);
        this.expressionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SCLExpressionTableEntry entry = (SCLExpressionTableEntry)element;
                return entry.getContent();
            }
        });
        layout.setColumnData((Widget)this.expressionColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        this.locationColumn = new TableViewerColumn(this.tableViewer, 0);
        this.locationColumn.getColumn().setText("Location");
        this.locationColumn.getColumn().setResizable(false);
        this.locationColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SCLExpressionTableEntry entry = (SCLExpressionTableEntry)element;
                if (entry.getLocation() != null) {
                    return entry.getLocation();
                }
                return "null";
            }
        });
        layout.setColumnData((Widget)this.locationColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SCLExpressionTableEntry entry = (SCLExpressionTableEntry)selection.getFirstElement();
                SCLExpressionView.openResource(SCLExpressionView.this.tableViewer.getControl().getDisplay().getActiveShell(), entry.getResource());
            }
        });
        this.scheduleUpdateEntries();
    }

    private void scheduleUpdateEntries() {
        DatabaseJob updateJob = new DatabaseJob("Update used SCL expressions"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Collection result = (Collection)Simantics.getSession().syncRequest((Read)new UsedSCLExpressionsRequest());
                    SCLExpressionView.this.tableViewer.getTable().getDisplay().asyncExec(() -> SCLExpressionView.this.tableViewer.setInput((Object)result));
                    return Status.OK_STATUS;
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                    return new Status(4, "org.simantics.modeling.ui", "Could not update SCL expressions", (Throwable)e);
                }
            }
        };
        updateJob.schedule();
    }

    private static void openResource(Shell shell, Resource resource) {
        try {
            StructuredSelection input = new StructuredSelection((Object)resource);
            String perspectiveId = WorkbenchUtils.getCurrentPerspectiveId();
            Simantics.getSession().asyncRequest((Read)new ChooseActionRequest(shell, (Object)input, perspectiveId, false, true));
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
    }
}

