/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.scl;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLScripts {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLScripts.class);
    private static final String SCL_CONSOLE_ID = "org.simantics.scl.ui.console";

    public static String canRunScript(RequestProcessor processor, Resource script) throws DatabaseException {
        return null;
    }

    public static void runScriptWithProgress(final String scriptName, final String scriptText, final CommandSession session, final SCLReportingHandler handler) {
        Job job = new Job("Run SCL Script"){

            protected IStatus run(IProgressMonitor monitor) {
                SCLScripts.runScriptWithProgress(monitor, scriptName, scriptText, session, handler);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static void runScriptWithProgress(IProgressMonitor monitor, String scriptName, String scriptText, CommandSession session, SCLReportingHandler handler) {
        monitor.beginTask(scriptName, -1);
        try {
            session.execute((Reader)new StringReader(scriptText), handler);
        }
        finally {
            monitor.done();
        }
    }

    public static Pair<CommandSession, SCLReportingHandler> getOrCreateConsoleCommandSession() {
        return SCLScripts.getSCLConsoleCommandSession(true);
    }

    public static Pair<CommandSession, SCLReportingHandler> getSCLConsoleCommandSession(boolean createIfNecessary) {
        try {
            IViewPart part;
            IViewPart iViewPart = part = createIfNecessary ? WorkbenchUtils.showView((String)SCL_CONSOLE_ID, (int)2) : WorkbenchUtils.findView((String)SCL_CONSOLE_ID);
            if (part != null) {
                return Pair.make((Object)((CommandSession)part.getAdapter(CommandSession.class)), (Object)((SCLReportingHandler)part.getAdapter(SCLReportingHandler.class)));
            }
        }
        catch (PartInitException e) {
            LOGGER.error("Failed to open SCL Console view. Using new CommandSession, reporting to stdout via Logger.", (Throwable)e);
        }
        SCLReportingHandler handler = SCLReportingHandler.DEFAULT_WITHOUT_ECHO;
        return Pair.make((Object)new CommandSession(SCLOsgi.MODULE_REPOSITORY, handler), (Object)SCLReportingHandler.DEFAULT);
    }
}

