/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.RecordType;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.Format;
import org.simantics.export.core.intf.Publisher;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.manager.CreatePublishLocationAction;
import org.simantics.export.core.manager.ExportAction;
import org.simantics.export.core.manager.ExportGroupCreateAction;
import org.simantics.export.core.manager.ExportPlan;
import org.simantics.export.core.manager.ExportSingleContent;
import org.simantics.export.core.manager.PublishAction;
import org.simantics.export.core.util.ExporterUtils;

public class ExportWizardResult {
    public static LabelReference P_OUTPUT_OPTIONS = new LabelReference("Output Options");
    public static final Pattern PATTR = Pattern.compile("url=(.*),formatId=(.*)");
    public RecordType type;
    public RecordAccessor accessor;
    public Variant options;
    public List<Content> contents;
    public String publisherId;

    public void createPlan(ExportContext ctx, ExportPlan plan) throws ExportException {
        ArrayList<Content> manifest = new ArrayList<Content>();
        ArrayList<ExportAction> actions = new ArrayList<ExportAction>();
        Publisher publisher = ctx.eep.getPublisher(this.publisherId);
        Variant locationOptions = ExporterUtils.getPublisherLocationOptions(ctx, this.publisherId, this.options);
        boolean locationExists = publisher.publisherClass().locationExists(ctx, locationOptions);
        if (!locationExists) {
            CreatePublishLocationAction assertLocationAction = new CreatePublishLocationAction(publisher.id());
            actions.add(assertLocationAction);
        }
        this.createExportActions(ctx, actions, manifest);
        PublishAction pa = new PublishAction(publisher.id(), locationOptions, manifest);
        actions.add(pa);
        plan.actions.addAll(actions);
        plan.manifest.addAll(manifest);
    }

    public void createExportActions(ExportContext ctx, List<ExportAction> actions, List<Content> manifest) throws ExportException {
        Comparator<Content> exportPriorityComparator = ExporterUtils.createExportPriorityComparator(ctx.eep);
        for (String modelId : this.listModels(this.contents)) {
            List<Object> attachmentsCts;
            ExportGroupCreateAction action;
            Content groupContent;
            Format format;
            Object action2;
            Format format2;
            List<Content> modelCts = this.filterByModel(this.contents, modelId);
            HashMap<Content, Object> contentActionMap = new HashMap<Content, Object>();
            Collections.sort(modelCts, exportPriorityComparator);
            String modelName = modelId.substring(modelId.lastIndexOf(47) + 1);
            for (Content content : modelCts) {
                if (this.mergeFormat(content.formatExt) || (format2 = ctx.eep.getFormat(content.formatId)).isGroupFormat() || format2.isContainerFormat()) continue;
                action2 = new ExportSingleContent(content);
                ((ExportSingleContent)action2).contentTypeId = content.contentTypeId;
                ((ExportSingleContent)action2).contentUri = content.url;
                ((ExportSingleContent)action2).formatId = content.formatId;
                actions.add((ExportAction)action2);
                contentActionMap.put(content, action2);
                manifest.add(content);
            }
            for (Content content : modelCts) {
                if (this.mergeFormat(content.formatExt) || !(format2 = ctx.eep.getFormat(content.formatId)).isGroupFormat() || format2.isContainerFormat() || format2.isLinkContainer()) continue;
                action2 = new ExportGroupCreateAction(content, format2.id());
                ((ExportGroupCreateAction)action2).addContent(content, null);
                actions.add((ExportAction)action2);
                contentActionMap.put(content, action2);
                manifest.add(content);
            }
            action2 = ctx.eep.formats();
            int format3 = ((Format[])action2).length;
            int n = 0;
            while (n < format3) {
                format = action2[n];
                if (this.mergeFormat(format.fileext()) && format.isGroupFormat() && !format.isContainerFormat() && !format.isLinkContainer()) {
                    groupContent = new Content(modelId, null, format.id(), modelName, format.fileext(), modelId);
                    action = new ExportGroupCreateAction(groupContent, format.id());
                    for (Content c : this.filterByFormat(modelCts, format.id())) {
                        action.addContent(c, null);
                        ExportAction contentsAction = (ExportAction)contentActionMap.get(c);
                        contentActionMap.remove(c);
                        actions.remove(contentsAction);
                        modelCts.remove(c);
                    }
                    actions.add(action);
                    contentActionMap.put(groupContent, action);
                    manifest.add(groupContent);
                }
                ++n;
            }
            for (Content content : modelCts) {
                if (this.mergeFormat(content.formatExt) || !(format = ctx.eep.getFormat(content.formatId)).isContainerFormat() || format.isLinkContainer()) continue;
                boolean includeAttachments = this.includeAttachments(format.fileext());
                boolean exportAttachments = this.exportAttachments(format.fileext());
                action = new ExportGroupCreateAction(content, format.id());
                List<Content> attachmentsCts2 = new ArrayList<Content>();
                if (includeAttachments) {
                    attachmentsCts2 = this.filterByUrl(modelCts, content.url);
                }
                attachmentsCts2 = this.filterAllAttachable(ctx, attachmentsCts2);
                attachmentsCts2.remove(content);
                action.addContent(content, attachmentsCts2);
                actions.add(action);
                contentActionMap.put(content, action);
                manifest.add(content);
                if (exportAttachments) continue;
                attachmentsCts2 = this.filterNotIsAlwaysPublished(ctx, attachmentsCts2);
                manifest.removeAll(attachmentsCts2);
            }
            Format[] formatArray = ctx.eep.formats();
            format = formatArray.length;
            int n2 = 0;
            while (n2 < format) {
                format = formatArray[n2];
                if (this.mergeFormat(format.fileext()) && format.isContainerFormat() && !format.isLinkContainer()) {
                    groupContent = new Content(modelId, null, format.id(), modelName, format.fileext(), modelId);
                    action = new ExportGroupCreateAction(groupContent, format.id());
                    boolean includeAttachments = this.includeAttachments(format.fileext());
                    boolean exportAttachments = this.exportAttachments(format.fileext());
                    ArrayList<Content> remainingCts = new ArrayList<Content>(contentActionMap.keySet());
                    List<Content> pages = this.filterByFormat(modelCts, format.id());
                    remainingCts.remove(pages);
                    for (Content page : pages) {
                        List<Object> pageAttachments = new ArrayList();
                        if (includeAttachments || exportAttachments) {
                            pageAttachments = this.filterByUrl(modelCts, page.url);
                            pageAttachments = this.filterAllAttachable(ctx, pageAttachments);
                            pageAttachments.remove(page);
                            remainingCts.removeAll(pageAttachments);
                        }
                        action.addContent(page, includeAttachments ? pageAttachments : null);
                    }
                    if (includeAttachments) {
                        action.addContent(null, remainingCts);
                    }
                    if (!exportAttachments) {
                        attachmentsCts = this.filterNotIsAlwaysPublished(ctx, action.getAttachments());
                        manifest.removeAll(attachmentsCts);
                    }
                    actions.add(action);
                    manifest.add(groupContent);
                }
                ++n2;
            }
            HashSet<Content> unlinkedContent = new HashSet<Content>(manifest);
            ExportGroupCreateAction mainLinkAction = null;
            for (Content content : modelCts) {
                Format format4;
                if (this.mergeFormat(content.formatExt) || !(format4 = ctx.eep.getFormat(content.formatId)).isLinkContainer()) continue;
                action = new ExportGroupCreateAction(content, format4.id());
                List<Content> attachmentsCts3 = new ArrayList<Content>();
                if (format4.isLinkContainer()) {
                    attachmentsCts3 = this.filterByUrl(manifest, content.url);
                    attachmentsCts3.remove(content);
                }
                action.addContent(content, attachmentsCts3);
                unlinkedContent.removeAll(attachmentsCts3);
                actions.add(action);
                contentActionMap.put(content, action);
                manifest.add(content);
                if (mainLinkAction != null) continue;
                mainLinkAction = action;
            }
            Format[] formatArray2 = ctx.eep.formats();
            int n3 = formatArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Format format5 = formatArray2[n4];
                if (this.mergeFormat(format5.fileext()) && format5.isLinkContainer()) {
                    Content groupContent2 = new Content(modelId, null, format5.id(), modelName, format5.fileext(), modelId);
                    ExportGroupCreateAction action3 = new ExportGroupCreateAction(groupContent2, format5.id());
                    for (Content c : this.filterByFormat(modelCts, format5.id())) {
                        attachmentsCts = new ArrayList();
                        if (format5.isLinkContainer()) {
                            attachmentsCts = this.filterByUrl(manifest, c.url);
                            attachmentsCts.remove(groupContent2);
                        }
                        action3.addContent(c, attachmentsCts);
                        unlinkedContent.removeAll(attachmentsCts);
                        ExportAction contentsAction = (ExportAction)contentActionMap.get(c);
                        contentActionMap.remove(c);
                        actions.remove(contentsAction);
                        modelCts.remove(c);
                    }
                    mainLinkAction = action3;
                    actions.add(action3);
                    contentActionMap.put(groupContent2, action3);
                    manifest.add(groupContent2);
                }
                ++n4;
            }
            if (mainLinkAction == null || unlinkedContent.isEmpty() || mainLinkAction.contents.isEmpty()) continue;
            mainLinkAction.attachments.addAll((Object)mainLinkAction.contents.get(0), unlinkedContent);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Export Wizard Result:\n");
        try {
            sb.append("  Options: " + this.options.getBinding().toString(this.options.getValue(), true) + "\n");
        }
        catch (BindingException e) {
            sb.append("  Options: " + e.getMessage() + "\n");
        }
        sb.append("  Content: \n");
        for (Content c : this.contents) {
            sb.append("    " + c.url + ", formatId=" + c.formatId + ", contentType=" + c.contentTypeId);
        }
        return sb.toString();
    }

    public static Set<Content> parse(String str) {
        HashSet<Content> result = new HashSet<Content>();
        String[] stringArray = str.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Matcher m = PATTR.matcher(s);
            if (m.matches()) {
                String url = m.group(1);
                String formatId = m.group(2);
                Content c = new Content(url, null, formatId, null, null, null);
                result.add(c);
            }
            ++n2;
        }
        return result;
    }

    public static String print(Collection<Content> cnts) {
        if (cnts == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Content c : cnts) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(c.toString());
        }
        return sb.toString();
    }

    boolean mergeFormat(String formatExt) {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)this.options);
            RecordAccessor rao = (RecordAccessor)ra.getComponent((ChildReference)P_OUTPUT_OPTIONS);
            Boolean b = (Boolean)rao.getValue((ChildReference)new LabelReference("Merge " + formatExt + " content into one file"), (Binding)Bindings.BOOLEAN);
            return b != null && b != false;
        }
        catch (AccessorConstructionException accessorConstructionException) {
            return false;
        }
        catch (AccessorException accessorException) {
            return false;
        }
    }

    boolean includeAttachments(String formatExt) {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)this.options);
            RecordAccessor rao = (RecordAccessor)ra.getComponent((ChildReference)P_OUTPUT_OPTIONS);
            Boolean b = (Boolean)rao.getValue((ChildReference)new LabelReference("Include attachments to " + formatExt), (Binding)Bindings.BOOLEAN);
            return b != null && b != false;
        }
        catch (AccessorConstructionException accessorConstructionException) {
            return false;
        }
        catch (AccessorException accessorException) {
            return false;
        }
    }

    boolean exportAttachments(String formatExt) {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)this.options);
            RecordAccessor rao = (RecordAccessor)ra.getComponent((ChildReference)P_OUTPUT_OPTIONS);
            Boolean b = (Boolean)rao.getValue((ChildReference)new LabelReference("Export attachments of " + formatExt + " to separate files"), (Binding)Bindings.BOOLEAN);
            return b != null && b != false;
        }
        catch (AccessorConstructionException accessorConstructionException) {
            return false;
        }
        catch (AccessorException accessorException) {
            return false;
        }
    }

    List<Content> filterByFormat(Collection<Content> contents, String formatId) {
        ArrayList<Content> result = new ArrayList<Content>();
        for (Content c : contents) {
            if (!c.formatId.equals(formatId)) continue;
            result.add(c);
        }
        return result;
    }

    List<Content> filterByModel(Collection<Content> contents, String modelId) {
        ArrayList<Content> result = new ArrayList<Content>();
        for (Content c : contents) {
            if (!c.modelId.equals(modelId)) continue;
            result.add(c);
        }
        return result;
    }

    List<Content> filterByUrl(Collection<Content> contents, String contentUrl) {
        ArrayList<Content> result = new ArrayList<Content>();
        for (Content c : contents) {
            if (!c.url.equals(contentUrl)) continue;
            result.add(c);
        }
        return result;
    }

    List<Content> filterAllAttachable(ExportContext ctx, Collection<Content> contents) {
        ArrayList<Content> result = new ArrayList<Content>();
        for (Content c : contents) {
            Format cf = ctx.eep.getFormat(c.formatId);
            if (!cf.isAttachable()) continue;
            result.add(c);
        }
        return result;
    }

    List<Content> filterNotIsAlwaysPublished(ExportContext ctx, Collection<Content> contents) {
        ArrayList<Content> result = new ArrayList<Content>();
        for (Content c : contents) {
            Format cf = ctx.eep.getFormat(c.formatId);
            if (cf.isAlwaysPublished()) continue;
            result.add(c);
        }
        return result;
    }

    List<String> listModels(Collection<Content> contents) {
        ArrayList<String> result = new ArrayList<String>();
        for (Content c : contents) {
            if (result.contains(c.modelId)) continue;
            result.add(c.modelId);
        }
        return result;
    }
}

