/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.trend;

import java.awt.Component;
import java.awt.Frame;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.part.ViewPart;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.XYDataset;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.IJFreeChart;
import org.simantics.sysdyn.manager.SysdynDataSet;
import org.simantics.sysdyn.ui.viewUtils.SysdynDatasetSelectionListener;
import org.simantics.utils.RunnableWithObject;

public class TrendView
extends ViewPart {
    private Frame frame;
    private ChartPanel panel;
    private SysdynDatasets sysdynDatasets = new SysdynDatasets();
    private SysdynDatasetSelectionListener sysdynDatasetSelectionListener;
    private JFreeChart defaultchart;
    private Composite composite;

    public Frame getFrame() {
        return this.frame;
    }

    public ChartPanel getPanel() {
        return this.panel;
    }

    public void setPanel(ChartPanel panel) {
        this.panel = panel;
    }

    public SysdynDatasets getSysdynDatasets() {
        return this.sysdynDatasets;
    }

    public void createPartControl(Composite parent) {
        this.composite = new Composite(parent, 0x1040000);
        this.frame = SWT_AWT.new_Frame((Composite)this.composite);
        this.displayDefaultChart();
        this.sysdynDatasetSelectionListener = new TrendViewSelectionListner(this);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this.sysdynDatasetSelectionListener);
    }

    private void displayChart(JFreeChart jFreeChart, TrendView trendView) {
        SwingUtilities.invokeLater((Runnable)new RunnableWithObject(jFreeChart, (Object)trendView){

            public void run() {
                if (this.count() != 2 || this.getObject(0) == null || this.getObject(1) == null) {
                    return;
                }
                if (!(this.getObject(0) instanceof JFreeChart) || !(this.getObject(1) instanceof TrendView)) {
                    return;
                }
                JFreeChart jFreeChart = (JFreeChart)this.getObject(0);
                TrendView trendView = (TrendView)((Object)this.getObject(1));
                Frame frame = trendView.getFrame();
                ChartPanel panel = trendView.getPanel();
                if (jFreeChart != null) {
                    if (panel == null || frame.getComponentCount() == 0) {
                        panel = new ChartPanel(jFreeChart, false, true, true, true, true);
                        trendView.setPanel(panel);
                        frame.add((Component)panel);
                    } else if (frame.getComponent(0) instanceof ChartPanel) {
                        ChartPanel tempPanel = (ChartPanel)frame.getComponent(0);
                        tempPanel.setChart(jFreeChart);
                        trendView.setPanel(tempPanel);
                    }
                }
                frame.repaint();
                frame.validate();
                panel.requestFocusInWindow();
            }
        });
    }

    private void displayDefaultChart() {
        if (this.defaultchart == null) {
            NumberAxis domainAxis = new NumberAxis("time");
            domainAxis.setAutoRangeIncludesZero(false);
            XYPlot plot = new XYPlot((XYDataset)this.sysdynDatasets, (ValueAxis)domainAxis, (ValueAxis)new NumberAxis(""), (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
            this.defaultchart = new JFreeChart((Plot)plot);
        }
        this.displayChart(this.defaultchart, this);
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this.sysdynDatasetSelectionListener);
    }

    public void setFocus() {
        if (this.panel != null) {
            this.panel.requestFocus();
        }
    }

    private class CustomChartListener
    implements Listener<JFreeChart> {
        private boolean disposed = false;
        private TrendView trendView;

        public CustomChartListener(TrendView trendView2) {
            this.trendView = trendView2;
        }

        public void execute(JFreeChart result) {
            if (!this.disposed) {
                TrendView.this.displayChart(result, this.trendView);
            }
        }

        public void exception(Throwable t) {
            t.printStackTrace();
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        public void dispose() {
            this.disposed = true;
        }
    }

    class SysdynDatasets
    extends AbstractXYDataset {
        SysdynDataSet[] sets = new SysdynDataSet[0];

        SysdynDatasets() {
        }

        public void setDatasets(SysdynDataSet[] sets) {
            this.sets = sets;
            this.fireDatasetChanged();
        }

        public Number getY(int series, int item) {
            return this.sets[series].values[item];
        }

        public Number getX(int series, int item) {
            return this.sets[series].times[item];
        }

        public int getItemCount(int series) {
            return this.sets[series].times.length;
        }

        public Comparable<String> getSeriesKey(int series) {
            SysdynDataSet sds = this.sets[series];
            String name = sds.name;
            if (sds.resultIndex != null) {
                name = String.valueOf(name) + "(" + sds.resultIndex + ")";
            }
            if (sds.result == null) {
                return name;
            }
            return String.valueOf(name) + " : " + sds.result;
        }

        public int getSeriesCount() {
            return this.sets.length;
        }
    }

    private class TrendViewSelectionListner
    extends SysdynDatasetSelectionListener {
        private TrendView trendView;
        private CustomChartListener listener;

        public TrendViewSelectionListner(TrendView trendView2) {
            this.trendView = trendView2;
        }

        @Override
        protected void selectionChanged(final Collection<SysdynDataSet> activeDatasets) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TrendViewSelectionListner.this.listener != null) {
                        TrendViewSelectionListner.this.listener.dispose();
                    }
                    TrendViewSelectionListner.this.trendView.getSysdynDatasets().setDatasets(activeDatasets.toArray(new SysdynDataSet[activeDatasets.size()]));
                    TrendView.this.displayDefaultChart();
                }
            });
        }

        @Override
        protected void selectionChanged(ReadGraph graph, final Resource chartResource) {
            if (this.listener != null) {
                this.listener.dispose();
            }
            this.listener = new CustomChartListener(this.trendView);
            graph.asyncRequest((Read)new Read<JFreeChart>(){

                public JFreeChart perform(ReadGraph graph) throws DatabaseException {
                    IJFreeChart chart;
                    if (graph.hasStatement(chartResource) && (chart = (IJFreeChart)graph.adapt(chartResource, IJFreeChart.class)) != null) {
                        return chart.getChart();
                    }
                    return null;
                }
            }, (Listener)this.listener);
        }
    }
}

