/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import java.awt.Color;
import java.awt.Font;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.jfreechart.chart.properties.AdjustableTab;
import org.simantics.modeling.ModelingResources;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.properties.widgets.CustomFontDialog;
import org.simantics.sysdyn.ui.properties.widgets.ValveOrientationGroup;
import org.simantics.sysdyn.ui.properties.widgets.ValveTextLocationGroup;
import org.simantics.sysdyn.ui.properties.widgets.factories.DoublePropertyFactory;
import org.simantics.sysdyn.ui.properties.widgets.factories.DoublePropertyModifier;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.Triple;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.validators.DoubleValidator;

public class VariableInformationTab
extends AdjustableTab
implements Widget {
    private Composite orientationComposite;
    private WidgetSupport support;
    private Resource component;
    private org.simantics.browsing.ui.swt.widgets.Label sample;
    private LocalResourceManager resourceManager;
    private Read<Pair<Font, Color>> fontAndColorRead;
    private Group informationGroup;
    private TrackedText information;
    private Group rangeGroup;
    private Label label;
    private TrackedText rangeStart;
    private TrackedText rangeEnd;
    private TrackedText rangeStep;
    private Composite fontComposite;
    private Button b;

    public VariableInformationTab(Object id) {
        super(id);
    }

    public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        this.support = support;
        support.register((Widget)this);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)body);
        super.createControls(body, site, context, support);
    }

    public void setInput(ISessionContext context, Object input) {
        this.component = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
        Boolean isValve = false;
        try {
            isValve = (Boolean)context.getSession().syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    return graph.isInstanceOf(VariableInformationTab.this.component, sr.Valve);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        if (isValve.booleanValue()) {
            ValveOrientationGroup vog = new ValveOrientationGroup(this.orientationComposite, context, this.support, 0);
            vog.setInput(context, input);
            ValveTextLocationGroup vtlg = new ValveTextLocationGroup(this.orientationComposite, context, this.support, 0);
            vtlg.setInput(context, input);
            this.orientationComposite.getParent().layout();
        }
        if (this.fontAndColorRead == null) {
            this.fontAndColorRead = new Read<Pair<Font, Color>>(){

                public Pair<Font, Color> perform(ReadGraph graph) throws DatabaseException {
                    Resource element;
                    Font font = null;
                    Color color = null;
                    if (VariableInformationTab.this.component != null && (element = graph.getPossibleObject(VariableInformationTab.this.component, ModelingResources.getInstance((ReadGraph)graph).ComponentToElement)) != null) {
                        Resource colorResource;
                        G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
                        Resource fontResource = graph.getPossibleObject(element, g2d.HasFont);
                        if (fontResource != null) {
                            font = G2DUtils.getFont((ReadGraph)graph, (Resource)fontResource);
                        }
                        if ((colorResource = graph.getPossibleObject(element, g2d.HasColor)) != null) {
                            color = G2DUtils.getColor((ReadGraph)graph, (Resource)colorResource);
                        }
                    }
                    return new Pair(font, color);
                }
            };
            SimanticsUI.getSession().asyncRequest(this.fontAndColorRead, (Listener)new Listener<Pair<Font, Color>>(){

                public void execute(final Pair<Font, Color> result) {
                    Display device;
                    try {
                        device = VariableInformationTab.this.sample.getWidget().getDisplay();
                    }
                    catch (SWTException sWTException) {
                        return;
                    }
                    device.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (VariableInformationTab.this.sample.getWidget().isDisposed()) {
                                    return;
                                }
                            }
                            catch (SWTException sWTException) {
                                return;
                            }
                            if (result.first != null) {
                                FontData fd = VariableInformationTab.toSwtFontData((Font)result.first);
                                VariableInformationTab.this.sample.setFont(VariableInformationTab.this.resourceManager.createFont(FontDescriptor.createFrom((FontData)fd)));
                            }
                            if (result.second != null) {
                                RGB rgb = new RGB(((Color)result.second).getRed(), ((Color)result.second).getGreen(), ((Color)result.second).getBlue());
                                VariableInformationTab.this.sample.setForeground(VariableInformationTab.this.resourceManager.createColor(rgb));
                            }
                            try {
                                VariableInformationTab.this.sample.getWidget().getParent().getParent().layout();
                            }
                            catch (SWTException sWTException) {}
                        }
                    });
                }

                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                public boolean isDisposed() {
                    return VariableInformationTab.this.sample == null || VariableInformationTab.this.sample.getWidget().isDisposed();
                }
            });
        }
    }

    private static FontData toSwtFontData(Font font) {
        FontData fontData = new FontData();
        fontData.setName(font.getFamily());
        fontData.setStyle(font.getStyle());
        fontData.setHeight(font.getSize());
        return fontData;
    }

    protected void createAndAddControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport _support) {
        this.composite = new Composite(body, 0);
        this.informationGroup = new Group(this.composite, 16);
        this.informationGroup.setText("Information");
        this.information = new TrackedText((Composite)this.informationGroup, this.support, 2050);
        this.information.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasDescription"));
        this.information.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasDescription"));
        this.orientationComposite = new Composite(this.composite, 0);
        this.rangeGroup = new Group(this.composite, 16);
        this.rangeGroup.setText("Range");
        this.label = new Label((Composite)this.rangeGroup, 0);
        this.label.setText("Start");
        this.rangeStart = new TrackedText((Composite)this.rangeGroup, this.support, 133120);
        this.rangeStart.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Sysdyn-1.1/HasRangeStart"));
        this.rangeStart.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/HasRangeStart"));
        this.rangeStart.setInputValidator((IInputValidator)new DoubleValidator());
        this.label = new Label((Composite)this.rangeGroup, 0);
        this.label.setText("End");
        this.rangeEnd = new TrackedText((Composite)this.rangeGroup, this.support, 133120);
        this.rangeEnd.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Sysdyn-1.1/HasRangeEnd"));
        this.rangeEnd.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/HasRangeEnd"));
        this.rangeEnd.setInputValidator((IInputValidator)new DoubleValidator());
        this.label = new Label((Composite)this.rangeGroup, 0);
        this.label.setText("Step");
        this.rangeStep = new TrackedText((Composite)this.rangeGroup, this.support, 133120);
        this.rangeStep.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Sysdyn-1.1/HasRangeStep"));
        this.rangeStep.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/HasRangeStep"));
        this.rangeStep.setInputValidator((IInputValidator)new DoubleValidator());
        this.fontComposite = new Composite(this.composite, 0);
        this.b = new Button(this.fontComposite, this.support, 8);
        this.b.setText("Choose Font");
        this.sample = new org.simantics.browsing.ui.swt.widgets.Label(this.fontComposite, this.support, 0);
        this.sample.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasName", "Sample"));
        this.b.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){
            Font f;
            Color color;
            Object input;

            public void beforeApply() {
                RGB rgb;
                FontData fd;
                Triple result = null;
                try {
                    result = (Triple)SimanticsUI.getSession().syncRequest((Read)new Read<Triple<Font, Color, String>>(){

                        public Triple<Font, Color, String> perform(ReadGraph graph) throws DatabaseException {
                            Resource component = (Resource)ISelectionUtils.filterSingleSelection((Object)input, Resource.class);
                            String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)component);
                            Resource element = graph.getPossibleObject(component, ModelingResources.getInstance((ReadGraph)graph).ComponentToElement);
                            if (element != null) {
                                G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
                                Resource fontResource = graph.getPossibleObject(element, g2d.HasFont);
                                Resource colorResource = graph.getPossibleObject(element, g2d.HasColor);
                                Font font = null;
                                if (fontResource != null) {
                                    font = G2DUtils.getFont((ReadGraph)graph, (Resource)fontResource);
                                }
                                Color color = null;
                                if (colorResource != null) {
                                    color = G2DUtils.getColor((ReadGraph)graph, (Resource)colorResource);
                                }
                                return new Triple((Object)font, (Object)color, (Object)name);
                            }
                            return null;
                        }
                    });
                }
                catch (DatabaseException databaseException) {}
                CustomFontDialog dialog = new CustomFontDialog(VariableInformationTab.this.composite.getShell(), result != null ? (String)result.third : null);
                if (result != null) {
                    if (result.first != null) {
                        dialog.setAWTFont((Font)result.first);
                        this.f = (Font)result.first;
                    }
                    if (result.second != null) {
                        dialog.setColor((Color)result.second);
                        this.color = (Color)result.second;
                    }
                }
                dialog.open();
                if (dialog.getAWTFont() != null) {
                    this.f = dialog.getAWTFont();
                }
                if (dialog.getAWTColor() != null) {
                    this.color = dialog.getAWTColor();
                }
                if ((fd = dialog.getSWTFontData()) != null) {
                    VariableInformationTab.this.sample.setFont(VariableInformationTab.this.resourceManager.createFont(FontDescriptor.createFrom((FontData)fd)));
                }
                if ((rgb = dialog.getRGB()) != null) {
                    VariableInformationTab.this.sample.setForeground(VariableInformationTab.this.resourceManager.createColor(rgb));
                }
                VariableInformationTab.this.fontComposite.layout();
            }

            public void apply(WriteGraph graph, Resource input) throws DatabaseException {
                graph.markUndoPoint();
                Resource element = graph.getPossibleObject(input, ModelingResources.getInstance((ReadGraph)graph).ComponentToElement);
                if (element != null) {
                    G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
                    graph.deny(element, g2d.HasFont);
                    StringBuilder sb = new StringBuilder();
                    if (this.f != null) {
                        graph.claim(element, g2d.HasFont, G2DUtils.createFont((WriteGraph)graph, (Font)this.f));
                        sb.append(" font to " + this.f.getName());
                    }
                    graph.deny(element, g2d.HasColor);
                    if (this.color != null) {
                        graph.claim(element, g2d.HasColor, G2DUtils.createColor((WriteGraph)graph, (Color)this.color));
                        sb.append(" color to " + this.color.getRGB());
                    }
                    sb.insert(0, "Modified");
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)sb.toString());
                }
            }

            public void setInput(ISessionContext context, Object parameter) {
                super.setInput(context, parameter);
                this.input = parameter;
            }
        });
    }

    protected void createControlLayoutVertical() {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.informationGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo((Composite)this.informationGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.information.getWidget());
        GridDataFactory.fillDefaults().span(1, 2).applyTo((Control)this.orientationComposite);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo(this.orientationComposite);
        GridDataFactory.fillDefaults().applyTo((Control)this.rangeGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo((Composite)this.rangeGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.rangeStart.getWidget());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.rangeEnd.getWidget());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.rangeStep.getWidget());
        GridDataFactory.fillDefaults().applyTo((Control)this.fontComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.fontComposite);
    }

    protected void createControlLayoutHorizontal(boolean wideScreen) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.informationGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo((Composite)this.informationGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.information.getWidget());
        GridDataFactory.fillDefaults().span(1, 2).applyTo((Control)this.orientationComposite);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo(this.orientationComposite);
        GridDataFactory.fillDefaults().applyTo((Control)this.rangeGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(6).applyTo((Composite)this.rangeGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.rangeStart.getWidget());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.rangeEnd.getWidget());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.rangeStep.getWidget());
        GridDataFactory.fillDefaults().applyTo((Control)this.fontComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.fontComposite);
    }
}

