/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ISelectionPainterNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.scenegraph.utils.NodeUtil;

public class HoverShapeNode
extends ShapeNode
implements ISelectionPainterNode {
    private static final long serialVersionUID = -4580969977763722602L;
    public transient boolean hover = false;

    protected void renderShape(Graphics2D g2d, Shape s) {
        Stroke stroke;
        float lineWidth;
        boolean fill;
        boolean bl = fill = Boolean.TRUE.equals(this.dynamicFill) ? true : this.fill;
        if (fill) {
            g2d.fill(s);
        }
        Color oldColor = g2d.getColor();
        BasicStroke oldStroke = (BasicStroke)g2d.getStroke();
        Composite oldComposite = g2d.getComposite();
        boolean selected = NodeUtil.isSelected((INode)this, (int)1);
        if (selected) {
            lineWidth = oldStroke.getLineWidth() * 5.0f;
            g2d.setStroke(new BasicStroke(lineWidth < 1.0f ? lineWidth : 1.0f));
            g2d.setComposite(AlphaComposite.SrcOver.derive(0.5f));
            g2d.setColor(Color.RED);
            g2d.draw(s);
            g2d.setColor(oldColor);
        }
        if (!selected && this.hover) {
            g2d.setColor(Color.LIGHT_GRAY);
            lineWidth = oldStroke.getLineWidth() * 5.0f;
            g2d.setStroke(new BasicStroke(lineWidth < 1.0f ? lineWidth : 1.0f));
            g2d.draw(s);
        }
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
        g2d.setComposite(oldComposite);
        Stroke stroke2 = stroke = this.dynamicStroke != null ? this.dynamicStroke : this.stroke;
        if (stroke != null) {
            g2d.draw(s);
        }
    }

    public void setHover(boolean hover) {
        this.hover = hover;
        this.repaint();
    }
}

