/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.issues;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.DoesNotExist;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.errors.Failure;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.ui.issues.SCLIssuesTableEntry;

public class SCLIssuesContentProvider
implements IStructuredContentProvider {
    public static final int MAX_ISSUE_COUNT = 1000;
    Viewer viewer;
    ModuleRepository repository;
    boolean disposed = false;
    AtomicBoolean refreshInProgress = new AtomicBoolean(false);
    THashMap<String, CompilationError[]> currentFailures = new THashMap();
    THashMap<String, UpdateListener> updateListeners = new THashMap();

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        this.repository = (ModuleRepository)newInput;
        if (newInput != null) {
            this.listenIssues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateListener getUpdateListener(final String moduleName) {
        UpdateListener listener;
        THashMap<String, UpdateListener> tHashMap = this.updateListeners;
        synchronized (tHashMap) {
            listener = (UpdateListener)this.updateListeners.get((Object)moduleName);
            if (listener == null) {
                listener = new UpdateListener(){

                    public void notifyAboutUpdate() {
                        if (!SCLIssuesContentProvider.this.disposed) {
                            SCLIssuesContentProvider.this.listenModule(moduleName);
                        }
                    }
                };
                this.updateListeners.put((Object)moduleName, (Object)listener);
            }
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenModule(String moduleName) {
        if (this.repository == null) {
            return;
        }
        Failable result = this.repository.getModule(moduleName, this.getUpdateListener(moduleName));
        THashMap<String, CompilationError[]> tHashMap = this.currentFailures;
        synchronized (tHashMap) {
            if (result instanceof Failure) {
                Failure failure = (Failure)result;
                this.currentFailures.put((Object)moduleName, (Object)failure.errors);
            } else if (result == DoesNotExist.INSTANCE) {
                if (this.currentFailures.remove((Object)moduleName) == null) {
                    return;
                }
            } else {
                CompilationError[] warnings = ((Module)result.getResult()).getWarnings();
                if (warnings.length == 0) {
                    if (this.currentFailures.remove((Object)moduleName) == null) {
                        return;
                    }
                } else {
                    this.currentFailures.put((Object)moduleName, (Object)warnings);
                }
            }
        }
        this.refresh();
    }

    private void refresh() {
        if (!this.refreshInProgress.compareAndSet(false, true)) {
            return;
        }
        if (this.viewer == null) {
            return;
        }
        final Control control = this.viewer.getControl();
        if (control.isDisposed() || this.disposed) {
            return;
        }
        control.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (control.isDisposed() || SCLIssuesContentProvider.this.disposed) {
                    return;
                }
                SCLIssuesContentProvider.this.refreshInProgress.set(false);
                SCLIssuesContentProvider.this.viewer.refresh();
            }
        });
    }

    private void listenIssues() {
        new Thread(){

            @Override
            public void run() {
                if (SCLIssuesContentProvider.this.repository == null) {
                    return;
                }
                SCLIssuesContentProvider.this.repository.getSourceRepository().forAllModules((TObjectProcedure)new TObjectProcedure<String>(){

                    public boolean execute(String moduleName) {
                        SCLIssuesContentProvider.this.listenModule(moduleName);
                        return true;
                    }
                });
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.repository != null) {
            THashMap<String, UpdateListener> tHashMap = this.updateListeners;
            synchronized (tHashMap) {
                this.updateListeners.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, UpdateListener>(){

                    public boolean execute(String moduleName, UpdateListener listener) {
                        listener.stopListening();
                        return true;
                    }
                });
                this.updateListeners.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getElements(Object inputElement) {
        ArrayList<SCLIssuesTableEntry> result = new ArrayList<SCLIssuesTableEntry>();
        THashMap<String, CompilationError[]> tHashMap = this.currentFailures;
        synchronized (tHashMap) {
            Object[] moduleNames = this.currentFailures.keySet().toArray(new String[this.currentFailures.size()]);
            Arrays.sort(moduleNames);
            Object[] objectArray = moduleNames;
            int n = moduleNames.length;
            int n2 = 0;
            while (n2 < n) {
                CompilationError[] errors;
                Object moduleName = objectArray[n2];
                CompilationError[] compilationErrorArray = errors = (CompilationError[])this.currentFailures.get(moduleName);
                int n3 = errors.length;
                int n4 = 0;
                while (n4 < n3) {
                    CompilationError error = compilationErrorArray[n4];
                    result.add(new SCLIssuesTableEntry((String)moduleName, error));
                    ++n4;
                }
                if (result.size() >= 1000) break;
                ++n2;
            }
        }
        Collections.sort(result);
        return result.toArray();
    }
}

