/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.scl.ui.console.ErrorAnnotation;
import org.simantics.scl.ui.console.Preferences;

public abstract class AbstractCommandConsole
extends Composite {
    public static final String PLUGIN_ID = "org.simantics.scl.ui";
    public static final int COMMAND_HISTORY_SIZE = 50;
    public static final int SASH_HEIGHT = 3;
    LocalResourceManager resourceManager;
    StyledText output;
    Sash sash;
    protected StyledText input;
    int userInputHeight = 0;
    int minInputHeight = 0;
    protected Color greenColor;
    protected Color redColor;
    ArrayList<String> commandHistory = new ArrayList();
    int commandHistoryPos = 0;
    boolean outputModiLock = false;
    String validatedText;
    Job validationJob = new Job("SCL input validation"){

        protected IStatus run(IProgressMonitor monitor) {
            String text = AbstractCommandConsole.this.validatedText;
            AbstractCommandConsole.this.asyncSetErrorAnnotations(text, AbstractCommandConsole.this.validate(text));
            return Status.OK_STATUS;
        }
    };
    Job preValidationJob = new Job("SCL input validation"){

        protected IStatus run(IProgressMonitor monitor) {
            if (!AbstractCommandConsole.this.input.isDisposed()) {
                AbstractCommandConsole.this.input.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).AbstractCommandConsole.this.input.isDisposed()) {
                            (this).AbstractCommandConsole.this.validatedText = (this).AbstractCommandConsole.this.input.getText();
                            (this).AbstractCommandConsole.this.validationJob.setPriority(40);
                            (this).AbstractCommandConsole.this.validationJob.schedule();
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    };
    private StringBuilder outputBuffer = new StringBuilder();
    private ArrayList<StyleRange> styleRanges = new ArrayList();
    private volatile boolean outputScheduled = false;
    public static final ErrorAnnotation[] EMPTY_ANNOTATION_ARRAY = new ErrorAnnotation[0];
    String errorAnnotationsForCommand;
    ErrorAnnotation[] errorAnnotations = EMPTY_ANNOTATION_ARRAY;

    public AbstractCommandConsole(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public boolean setFocus() {
        return this.input.setFocus();
    }

    protected boolean canExecuteCommand() {
        return true;
    }

    private void createControl() {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);
        this.greenColor = this.resourceManager.createColor(new RGB(0, 128, 0));
        this.redColor = this.resourceManager.createColor(new RGB(172, 0, 0));
        this.setLayout((Layout)new FormLayout());
        Font textFont = new Font((Device)this.getDisplay(), "Courier New", 12, 0);
        this.sash = new Sash((Composite)this, 256);
        this.sash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Rectangle bounds = AbstractCommandConsole.this.getBounds();
                int max = bounds.y + bounds.height;
                AbstractCommandConsole.this.userInputHeight = max - e.y;
                int actualInputHeight = Math.max(AbstractCommandConsole.this.userInputHeight, AbstractCommandConsole.this.minInputHeight);
                AbstractCommandConsole.this.sash.setBounds(e.x, max - actualInputHeight, e.width, e.height);
                AbstractCommandConsole.this.setInputHeight(actualInputHeight);
            }
        });
        this.output = new StyledText((Composite)this, 770);
        this.output.setFont(textFont);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment((Control)this.sash);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        this.output.setLayoutData((Object)formData);
        this.output.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (AbstractCommandConsole.this.outputModiLock) {
                    return;
                }
                AbstractCommandConsole.this.input.append(e.text);
                AbstractCommandConsole.this.input.setFocus();
                AbstractCommandConsole.this.input.setCaretOffset(AbstractCommandConsole.this.input.getText().length());
                e.doit = false;
            }
        });
        StyledText deco = new StyledText((Composite)this, 10);
        deco.setFont(textFont);
        deco.setEnabled(false);
        GC gc = new GC((Drawable)deco);
        int inputLeftPos = gc.getFontMetrics().getAverageCharWidth() * 2;
        deco.setText(">");
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.sash);
        formData2.bottom = new FormAttachment(100);
        formData2.left = new FormAttachment(0);
        formData2.right = new FormAttachment(0, inputLeftPos);
        deco.setLayoutData((Object)formData2);
        this.input = new StyledText((Composite)this, 2);
        this.input.setFont(textFont);
        formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.sash);
        formData2.bottom = new FormAttachment(100);
        formData2.left = new FormAttachment(0, inputLeftPos);
        formData2.right = new FormAttachment(100);
        this.input.setLayoutData((Object)formData2);
        this.adjustInputSize("");
        this.input.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                switch (event.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        if ((event.stateMask & 0x40000) != 0) break;
                        if (AbstractCommandConsole.this.canExecuteCommand()) {
                            AbstractCommandConsole.this.execute();
                        }
                        event.doit = false;
                        break;
                    }
                    case 0x1000001: 
                    case 0x1000002: {
                        if ((event.stateMask & 0x40000) == 0) break;
                        int targetHistoryPos = AbstractCommandConsole.this.commandHistoryPos;
                        if (event.keyCode == 0x1000001) {
                            if (AbstractCommandConsole.this.commandHistoryPos <= 0) {
                                return;
                            }
                            --targetHistoryPos;
                        } else {
                            if (AbstractCommandConsole.this.commandHistoryPos >= AbstractCommandConsole.this.commandHistory.size() - 1) {
                                return;
                            }
                            ++targetHistoryPos;
                        }
                        AbstractCommandConsole.this.setInputText(AbstractCommandConsole.this.commandHistory.get(targetHistoryPos));
                        AbstractCommandConsole.this.commandHistoryPos = targetHistoryPos;
                        event.doit = false;
                    }
                }
            }
        });
        this.input.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.text.contains("\n")) {
                    int lineId = AbstractCommandConsole.this.input.getLineAtOffset(e.start);
                    int lineOffset = AbstractCommandConsole.this.input.getOffsetAtLine(lineId);
                    int indentAmount = 0;
                    while (lineOffset + indentAmount < AbstractCommandConsole.this.input.getCharCount() && AbstractCommandConsole.this.input.getTextRange(lineOffset + indentAmount, 1).equals(" ")) {
                        ++indentAmount;
                    }
                    StringBuilder indent = new StringBuilder();
                    indent.append('\n');
                    int i = 0;
                    while (i < indentAmount) {
                        indent.append(' ');
                        ++i;
                    }
                    e.text = e.text.replace("\n", indent);
                }
            }
        });
        this.input.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCommandConsole.this.adjustInputSize(AbstractCommandConsole.this.input.getText());
                AbstractCommandConsole.this.commandHistoryPos = AbstractCommandConsole.this.commandHistory.size();
            }
        });
        Listener hoverListener = new Listener(){
            DefaultToolTip toolTip;
            int min;
            int max;
            boolean toolTipVisible;
            {
                this.toolTip = new DefaultToolTip((Control)AbstractCommandConsole.this.input, 1, true);
                this.toolTipVisible = false;
            }

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 32: {
                        int offset = AbstractCommandConsole.this.getOffsetInInput(e.x, e.y);
                        if (offset == -1) {
                            return;
                        }
                        this.min = Integer.MIN_VALUE;
                        this.max = Integer.MAX_VALUE;
                        StringBuilder description = new StringBuilder();
                        boolean first = true;
                        ErrorAnnotation[] errorAnnotationArray = AbstractCommandConsole.this.errorAnnotations;
                        int n = AbstractCommandConsole.this.errorAnnotations.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ErrorAnnotation annotation = errorAnnotationArray[n2];
                            if (annotation.start <= offset && annotation.end > offset) {
                                this.min = Math.max(this.min, annotation.start);
                                this.max = Math.max(this.min, annotation.end);
                                if (first) {
                                    first = false;
                                } else {
                                    description.append('\n');
                                }
                                description.append(annotation.description);
                            }
                            ++n2;
                        }
                        if (this.min != Integer.MIN_VALUE) {
                            Rectangle bounds = AbstractCommandConsole.this.input.getTextBounds(this.min, this.max - 1);
                            this.toolTip.setText(description.toString());
                            this.toolTip.show(new Point(bounds.x, bounds.y + bounds.height));
                            this.toolTipVisible = true;
                        }
                        return;
                    }
                    case 5: {
                        int offset;
                        if (this.toolTipVisible && ((offset = AbstractCommandConsole.this.getOffsetInInput(e.x, e.y)) < this.min || offset >= this.max)) {
                            this.toolTip.hide();
                            this.toolTipVisible = false;
                            return;
                        }
                        return;
                    }
                    case 7: {
                        if (this.toolTipVisible) {
                            this.toolTip.hide();
                            this.toolTipVisible = false;
                        }
                        return;
                    }
                }
            }
        };
        this.input.addListener(32, hoverListener);
        this.input.addListener(5, hoverListener);
        this.input.addListener(7, hoverListener);
        this.readPreferences();
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                try {
                    AbstractCommandConsole.this.writePreferences();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private int getOffsetInInput(int x, int y) {
        Rectangle rect;
        int offset;
        try {
            offset = this.input.getOffsetAtLocation(new Point(x, y));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
        if (offset == this.input.getText().length()) {
            --offset;
        } else if (offset > 0 && !(rect = this.input.getTextBounds(offset, offset)).contains(x, y)) {
            --offset;
        }
        return offset;
    }

    public void setInputText(String text) {
        this.input.setText(text);
        this.input.setCaretOffset(text.length());
        this.adjustInputSize(text);
    }

    private void asyncValidate() {
        if (!this.input.getText().equals(this.errorAnnotationsForCommand)) {
            this.preValidationJob.cancel();
            this.preValidationJob.setPriority(40);
            this.preValidationJob.schedule(500L);
        }
    }

    private static int rowCount(String text) {
        int rowCount = 1;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\n') {
                ++rowCount;
            }
            ++i;
        }
        return rowCount;
    }

    private void adjustInputSize(String text) {
        int lineHeight = this.input.getLineHeight();
        int height = AbstractCommandConsole.rowCount(text) * lineHeight + 3;
        if (height != this.minInputHeight) {
            this.minInputHeight = height;
            this.setInputHeight(Math.max(this.minInputHeight, this.userInputHeight));
        }
    }

    private void setInputHeight(int inputHeight) {
        FormData formData = new FormData();
        formData.top = new FormAttachment(100, -inputHeight);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.height = 3;
        this.sash.setLayoutData((Object)formData);
        this.layout(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendOutput(String text, Color foreground, Color background) {
        StringBuilder stringBuilder = this.outputBuffer;
        synchronized (stringBuilder) {
            this.styleRanges.add(new StyleRange(this.outputBuffer.length(), text.length(), foreground, background));
            this.outputBuffer.append(text);
        }
        if (!this.outputScheduled) {
            this.outputScheduled = true;
            Display display = Display.getDefault();
            if (display.isDisposed()) {
                return;
            }
            display.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StyleRange[] styleRangeArray;
                    String outputText;
                    if (AbstractCommandConsole.this.output.isDisposed()) {
                        return;
                    }
                    StringBuilder stringBuilder = AbstractCommandConsole.this.outputBuffer;
                    synchronized (stringBuilder) {
                        AbstractCommandConsole.this.outputScheduled = false;
                        outputText = AbstractCommandConsole.this.outputBuffer.toString();
                        AbstractCommandConsole.this.outputBuffer = new StringBuilder();
                        styleRangeArray = AbstractCommandConsole.this.styleRanges.toArray(new StyleRange[AbstractCommandConsole.this.styleRanges.size()]);
                        AbstractCommandConsole.this.styleRanges.clear();
                    }
                    int pos = AbstractCommandConsole.this.output.getCharCount();
                    AbstractCommandConsole.this.outputModiLock = true;
                    AbstractCommandConsole.this.output.replaceTextRange(pos, 0, outputText);
                    AbstractCommandConsole.this.outputModiLock = false;
                    StyleRange[] styleRangeArray2 = styleRangeArray;
                    int n = styleRangeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StyleRange styleRange = styleRangeArray2[n2];
                        styleRange.start += pos;
                        AbstractCommandConsole.this.output.setStyleRange(styleRange);
                        ++n2;
                    }
                    AbstractCommandConsole.this.output.setCaretOffset(AbstractCommandConsole.this.output.getCharCount());
                    AbstractCommandConsole.this.output.showSelection();
                }
            });
        }
    }

    private void execute() {
        String command = this.input.getText().trim();
        if (command.isEmpty()) {
            return;
        }
        if (this.commandHistory.isEmpty() || !this.commandHistory.get(this.commandHistory.size() - 1).equals(command)) {
            this.commandHistory.add(command);
            if (this.commandHistory.size() > 100) {
                this.commandHistory = new ArrayList<String>(this.commandHistory.subList(50, 100));
            }
        }
        this.commandHistoryPos = this.commandHistory.size();
        this.input.setText("");
        this.execute(command);
    }

    private void syncSetErrorAnnotations(String forCommand, ErrorAnnotation[] annotations) {
        this.errorAnnotationsForCommand = forCommand;
        this.errorAnnotations = annotations;
        StyleRange clearRange = new StyleRange(0, forCommand.length(), null, null);
        this.input.setStyleRange(clearRange);
        int i = 0;
        while (i < annotations.length) {
            ErrorAnnotation annotation = annotations[i];
            StyleRange range = new StyleRange(annotation.start, annotation.end - annotation.start, null, null);
            range.underline = true;
            range.underlineColor = this.redColor;
            range.underlineStyle = 3;
            try {
                this.input.setStyleRange(range);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                range.start = 0;
                range.length = 1;
                this.input.setStyleRange(range);
                System.err.println("The following error message didn't have a proper location:");
                System.err.println(annotation.description);
            }
            ++i;
        }
    }

    private void asyncSetErrorAnnotations(final String forCommand, final ErrorAnnotation[] annotations) {
        if (this.input.isDisposed()) {
            return;
        }
        this.input.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractCommandConsole.this.input.isDisposed()) {
                    return;
                }
                if (!AbstractCommandConsole.this.input.getText().equals(forCommand)) {
                    return;
                }
                AbstractCommandConsole.this.syncSetErrorAnnotations(forCommand, annotations);
            }
        });
    }

    private boolean readPreferences() {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        String commandHistoryPref = store.getString("COMMAND_HISTORY");
        Deque<String> recentImportPaths = Preferences.decodePaths(commandHistoryPref);
        this.commandHistory = new ArrayList<String>(recentImportPaths);
        this.commandHistoryPos = this.commandHistory.size();
        return true;
    }

    private void writePreferences() throws IOException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        store.putValue("COMMAND_HISTORY", Preferences.encodePaths(this.commandHistory));
        if (store.needsSaving()) {
            store.save();
        }
    }

    public abstract void execute(String var1);

    public abstract ErrorAnnotation[] validate(String var1);

    public void clear() {
        this.outputModiLock = true;
        this.output.setText("");
        this.outputModiLock = false;
    }

    public StyledText getOutputWidget() {
        return this.output;
    }
}

