/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.assist;

import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class StyledTextContentAdapter
implements IControlContentAdapter,
IControlContentAdapter2 {
    public String getControlContents(Control control) {
        return ((StyledText)control).getText();
    }

    public int getCursorPosition(Control control) {
        return ((StyledText)control).getCaretOffset();
    }

    public Rectangle getInsertionBounds(Control control) {
        StyledText text = (StyledText)control;
        Point caretOrigin = text.getLocationAtOffset(text.getCaretOffset());
        return new Rectangle(caretOrigin.x + text.getClientArea().x, caretOrigin.y + text.getClientArea().y + 3, 1, text.getLineHeight());
    }

    public void insertControlContents(Control control, String contents, int cursorPosition) {
        int endRange;
        StyledText text = (StyledText)control;
        cursorPosition = Math.min(cursorPosition, contents.length());
        int caretEndRange = text.getCaretOffset();
        String currentText = text.getText();
        int offset = caretEndRange;
        int length = currentText.length();
        while (--offset >= 0 && Character.isJavaIdentifierPart(currentText.charAt(offset)) && !Character.isWhitespace(currentText.charAt(offset))) {
            --length;
        }
        int nameSpaceBeginRange = currentText.lastIndexOf(".", caretEndRange - 1);
        if (nameSpaceBeginRange > length) {
            length = nameSpaceBeginRange;
        }
        if (caretEndRange < (endRange = currentText.length())) {
            endRange = caretEndRange;
        }
        text.setSelection(length, endRange);
        text.insert(contents);
        int proposalFirstLettersCount = endRange - length;
        text.setCaretOffset(caretEndRange + cursorPosition - proposalFirstLettersCount);
    }

    public void setControlContents(Control control, String contents, int cursorPosition) {
        ((StyledText)control).setText(contents);
        ((StyledText)control).setCaretOffset(cursorPosition);
    }

    public void setCursorPosition(Control control, int index) {
        ((StyledText)control).setCaretOffset(index);
    }

    public Point getSelection(Control control) {
        return ((StyledText)control).getSelection();
    }

    public void setSelection(Control control, Point range) {
        ((StyledText)control).setSelection(range);
    }
}

