/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.scl.scriptEditor;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.simantics.Simantics;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.modeling.ui.scl.scriptEditor.ReadSCLScriptDefinition;
import org.simantics.modeling.ui.scl.scriptEditor.SCLScriptEditorInput;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.ErrorSeverity;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.runtime.reporting.AbstractSCLReportingHandler;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLScriptAnnotationModel
extends AnnotationModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLScriptAnnotationModel.class);
    private final SCLScriptEditorInput input;
    private final ModuleRepository repository;
    private volatile boolean connected = false;
    private Listener<String> sourceListener = new Listener<String>(){

        public void execute(String result) {
            if (SCLScriptAnnotationModel.this.connected && result != null) {
                SCLScriptAnnotationModel.this.updateAnnotations(result);
            }
        }

        public void exception(Throwable t) {
            LOGGER.error("Failed to read SCL script source from " + SCLScriptAnnotationModel.this.input.getScriptURI(), t);
        }

        public boolean isDisposed() {
            return !SCLScriptAnnotationModel.this.connected;
        }
    };
    private static final SCLReportingHandler NOP = new AbstractSCLReportingHandler(){

        public void print(String text) {
        }
    };

    public SCLScriptAnnotationModel(SCLScriptEditorInput input, ModuleRepository repository) {
        this.input = input;
        this.repository = repository;
    }

    private void listenToSource() {
        Simantics.getSession().asyncRequest((Read)new ReadSCLScriptDefinition(this.input.getScriptURI()), this.sourceListener);
    }

    private void updateAnnotations(String sourceText) {
        CompilationError[] errors = new CommandSession(this.repository, NOP).validate(sourceText);
        this.setAnnotations(Arrays.asList(errors));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAnnotations(List<CompilationError> errors) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.removeAllAnnotations();
            for (CompilationError error : errors) {
                Annotation annotation = new Annotation(error.severity == ErrorSeverity.ERROR || error.severity == ErrorSeverity.IMPORT_ERROR ? "org.eclipse.ui.workbench.texteditor.error" : "org.eclipse.ui.workbench.texteditor.warning", true, error.description);
                int begin = Locations.beginOf((long)error.location);
                int end = Locations.endOf((long)error.location);
                if (begin < 0 || end < begin) {
                    begin = 0;
                    end = 1;
                }
                this.addAnnotation(annotation, new Position(begin, end - begin));
            }
        }
    }

    public void connect(IDocument document) {
        super.connect(document);
        this.connected = true;
        this.listenToSource();
    }

    public void disconnect(IDocument document) {
        this.connected = false;
        super.disconnect(document);
    }
}

