/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.function;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.ExplorerState;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.model.actions.ActionBrowseContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContexts;
import org.simantics.browsing.ui.model.nodetypes.EntityNodeType;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.nodetypes.SpecialNodeType;
import org.simantics.browsing.ui.swt.GraphExplorerStateBean;
import org.simantics.browsing.ui.swt.GraphExplorerStateNodeBean;
import org.simantics.browsing.ui.swt.IdentifiedStatePersistor;
import org.simantics.browsing.ui.swt.NodeContextValueBean;
import org.simantics.browsing.ui.swt.StringArrayBean;
import org.simantics.browsing.ui.swt.StringBean;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.impl.ArrayListBinding;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.StringUtil;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;

class StandardPersistor
extends IdentifiedStatePersistor {
    public StandardPersistor(String configurationId) {
        super(configurationId);
    }

    protected Path getMementoPath(File stateLocation, NodeContext root) {
        Object input;
        if (root != null && (input = root.getConstant(BuiltinKeys.INPUT)) instanceof Resource) {
            Resource r = (Resource)input;
            return stateLocation.toPath().resolve(StringUtil.escapeToFileName((String)(String.valueOf(this.id) + "#" + r.getResourceId() + ".ge")));
        }
        return null;
    }

    protected GraphExplorerStateBean toStateBean(ExplorerState state, NodeContext root) {
        Object input = root.getConstant(BuiltinKeys.INPUT);
        if (input instanceof Resource) {
            return super.toStateBean(state, root);
        }
        return null;
    }

    protected GraphExplorerStateNodeBean[] toNodeBeans(NodeContext[] contexts) {
        ArrayList<GraphExplorerStateNodeBean> result = new ArrayList<GraphExplorerStateNodeBean>(contexts.length);
        NodeContext[] nodeContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            NodeContext node = nodeContextArray[n2];
            GraphExplorerStateNodeBean bean = this.buildNodeBean(node);
            if (bean != null) {
                result.add(bean);
            }
            ++n2;
        }
        return result.toArray(GraphExplorerStateNodeBean.NONE);
    }

    protected NodeContext[] toNodeContexts(GraphExplorerStateNodeBean[] beans) throws Exception {
        ArrayList<NodeContext> result = new ArrayList<NodeContext>(beans.length);
        GraphExplorerStateNodeBean[] graphExplorerStateNodeBeanArray = beans;
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            NodeContext node;
            GraphExplorerStateNodeBean bean = graphExplorerStateNodeBeanArray[n2];
            NodeContext nodeContext = node = bean != null ? this.buildNodeContext(bean) : null;
            if (node != null) {
                result.add(node);
            }
            ++n2;
        }
        return result.toArray(NodeContext.NONE);
    }

    protected NodeContext buildNodeContext(GraphExplorerStateNodeBean node) throws Exception {
        ArrayList<Object> keysAndValues = new ArrayList<Object>(node.map.size());
        for (Map.Entry entry : node.map.entrySet()) {
            NodeContext.ConstantKey<?> key = this.decodeKey((String)entry.getKey());
            Object value = this.decodeValue(key, (Bean)entry.getValue());
            keysAndValues.add(key);
            keysAndValues.add(value);
        }
        return NodeContextBuilder.buildWithData((Object[])keysAndValues.toArray());
    }

    protected GraphExplorerStateNodeBean buildNodeBean(NodeContext nodeContext) {
        if (nodeContext instanceof NodeContextBuilder.MapNodeContext) {
            NodeContextBuilder.MapNodeContext ctx = (NodeContextBuilder.MapNodeContext)nodeContext;
            GraphExplorerStateNodeBean node = new GraphExplorerStateNodeBean();
            for (NodeContext.ConstantKey key : ctx.getKeys()) {
                String[] uris;
                Object value = ctx.getConstant(key);
                if (value instanceof Resource) {
                    node.map.put(key.getClass().getName(), new NodeContextValueBean((Resource)value));
                    continue;
                }
                if (value instanceof EntityNodeType) {
                    node.map.put(key.getClass().getName(), new NodeContextValueBean((EntityNodeType)value));
                    continue;
                }
                if (value instanceof SpecialNodeType) {
                    node.map.put(key.getClass().getName(), new NodeContextValueBean((SpecialNodeType)value));
                    continue;
                }
                if (key == BuiltinKeys.UI_CONTEXT) {
                    node.map.put(key.getClass().getName(), new StringBean((String)value));
                    continue;
                }
                if (key == BuiltinKeys.BROWSE_CONTEXT) {
                    uris = value != null ? ((BrowseContext)value).getURIs() : null;
                    node.map.put(key.getClass().getName(), new StringArrayBean(uris));
                    continue;
                }
                if (key != BuiltinKeys.ACTION_BROWSE_CONTEXT) continue;
                uris = value != null ? ((ActionBrowseContext)value).getURIs() : null;
                node.map.put(key.getClass().getName(), new StringArrayBean(uris));
            }
            return node;
        }
        return null;
    }

    private NodeContext.ConstantKey<?> decodeKey(String name) {
        if (BuiltinKeys.INPUT.getClass().getName().equals(name)) {
            return BuiltinKeys.INPUT;
        }
        if (BuiltinKeys.UI_CONTEXT.getClass().getName().equals(name)) {
            return BuiltinKeys.UI_CONTEXT;
        }
        if (BuiltinKeys.BROWSE_CONTEXT.getClass().getName().equals(name)) {
            return BuiltinKeys.BROWSE_CONTEXT;
        }
        if (BuiltinKeys.ACTION_BROWSE_CONTEXT.getClass().getName().equals(name)) {
            return BuiltinKeys.ACTION_BROWSE_CONTEXT;
        }
        if (NodeType.TYPE.getClass().getName().equals(name)) {
            return NodeType.TYPE;
        }
        throw new IllegalArgumentException(name);
    }

    private Object decodeValue(NodeContext.ConstantKey<?> key, Bean bean) throws Exception {
        if (key == BuiltinKeys.BROWSE_CONTEXT) {
            String[] uris = (String[])bean.getField("strings");
            return uris == null ? null : BrowseContexts.toBrowseContext((RequestProcessor)Simantics.getSession(), (String[])uris);
        }
        if (key == BuiltinKeys.ACTION_BROWSE_CONTEXT) {
            String[] uris = (String[])bean.getField("strings");
            return uris == null ? null : BrowseContexts.toActionBrowseContext((RequestProcessor)Simantics.getSession(), (String[])uris);
        }
        if (key == BuiltinKeys.UI_CONTEXT) {
            return bean.getField("string");
        }
        String name = (String)bean.getField("name");
        if (Resource.class.getName().equals(name)) {
            return bean.getField("resource", Bindings.getBinding(Resource.class));
        }
        if (EntityNodeType.class.getName().equals(name)) {
            List entityType = (List)bean.getField("resources", (Binding)new ArrayListBinding(Bindings.getBinding(Resource.class)));
            return EntityNodeType.create((Collection)entityType);
        }
        if (SpecialNodeType.class.getName().equals(name)) {
            Resource resource = (Resource)bean.getField("resource", Bindings.getBinding(Resource.class));
            String contentType = (String)bean.getField("className");
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(contentType);
            return new SpecialNodeType(resource, clazz);
        }
        throw new IllegalArgumentException("key = " + key + ", bean = " + bean);
    }
}

