/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.ActionFactory2;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.AssignConnectionTypesRequest;
import org.simantics.modeling.GetConnectionTypes;
import org.simantics.modeling.ui.actions.ConfigureConnectionTypesDialog;
import org.simantics.structural2.modelingRules.AllowedConnectionTypes;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class ConfigureConnectionTypes
implements ActionFactory,
ActionFactory2 {
    private static final ConnectionType[] NO_CONNECTION_TYPES = new ConnectionType[0];

    public Runnable create(Collection<?> targets) {
        final ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Object target : targets) {
            if (!(target instanceof Resource)) {
                return null;
            }
            resources.add((Resource)target);
        }
        return new Runnable(){

            @Override
            public void run() {
                ConfigureConnectionTypes.this.assignTypes(resources);
            }
        };
    }

    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource connectionPoint = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                ConfigureConnectionTypes.this.assignTypes(Collections.singletonList(connectionPoint));
            }
        };
    }

    private static Resource getCommonModel(final Collection<Resource> connectionPoints) {
        try {
            return (Resource)Simantics.sync((ReadInterface)new UniqueRead<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    return ConfigureConnectionTypes.getPossibleIndexRoot(graph, connectionPoints);
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return null;
        }
    }

    private static Resource getPossibleIndexRoot(ReadGraph g, Collection<Resource> connectionPoints) throws DatabaseException {
        Resource model = null;
        for (Resource connectionPoint : connectionPoints) {
            Resource m = ConfigureConnectionTypes.getIndexRootOf(g, connectionPoint);
            if (m == null) {
                return null;
            }
            if (model == null) {
                model = m;
                continue;
            }
            if (model.equals(m)) continue;
            return null;
        }
        return model;
    }

    private static Resource getIndexRootOf(ReadGraph g, Resource connectionPoint) throws DatabaseException {
        return (Resource)g.syncRequest((Read)new PossibleIndexRoot(connectionPoint));
    }

    private static ConnectionType[] getConnectionTypes(final Collection<Resource> connectionPoints) {
        try {
            return (ConnectionType[])Simantics.getSession().syncRequest((Read)new Read<ConnectionType[]>(){

                public ConnectionType[] perform(ReadGraph g) throws DatabaseException {
                    return ConfigureConnectionTypes.getConnectionTypes(g, connectionPoints);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return NO_CONNECTION_TYPES;
        }
    }

    private static ConnectionType[] getConnectionTypes(ReadGraph g, Collection<Resource> connectionPoints) throws DatabaseException {
        Resource root = ConfigureConnectionTypes.getPossibleIndexRoot(g, connectionPoints);
        if (root == null) {
            return NO_CONNECTION_TYPES;
        }
        ArrayList<ConnectionType> result = new ArrayList<ConnectionType>();
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        for (Resource type : GetConnectionTypes.getConnectionTypes((ReadGraph)g, (Resource)root)) {
            Tristate selected = ConfigureConnectionTypes.getConnectionTypeSelectionState(g, type, connectionPoints, DIA);
            selected = selected != null ? selected : Tristate.NONE;
            result.add(new ConnectionType(type, NameUtils.getSafeLabel((ReadGraph)g, (Resource)type), selected, selected));
        }
        Collections.sort(result);
        return result.toArray(new ConnectionType[result.size()]);
    }

    protected static Tristate getConnectionTypeSelectionState(ReadGraph graph, Resource connectionType, Collection<Resource> connectionPoints, DiagramResource DIA) throws DatabaseException {
        Tristate selected = null;
        for (Resource connectionPoint : connectionPoints) {
            Collection allowed = (Collection)graph.syncRequest((Read)new AllowedConnectionTypes(connectionPoint));
            selected = Tristate.add(selected, allowed.contains(connectionType));
        }
        return selected != null ? selected : Tristate.NONE;
    }

    private static ConnectionType[] selectedElements(ConnectionType[] connectionTypes) {
        int count = 0;
        ConnectionType[] connectionTypeArray = connectionTypes;
        int n = connectionTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionType connectionType = connectionTypeArray[n2];
            if (connectionType.selected != Tristate.NONE) {
                ++count;
            }
            ++n2;
        }
        ConnectionType[] result = new ConnectionType[count];
        count = 0;
        ConnectionType[] connectionTypeArray2 = connectionTypes;
        int n3 = connectionTypes.length;
        n = 0;
        while (n < n3) {
            ConnectionType connectionType = connectionTypeArray2[n];
            if (connectionType.selected != Tristate.NONE) {
                result[count++] = connectionType;
            }
            ++n;
        }
        return result;
    }

    public void assignTypes(Collection<Resource> connectionPoints) {
        if (connectionPoints.isEmpty()) {
            return;
        }
        Resource indexRoot = ConfigureConnectionTypes.getCommonModel(connectionPoints);
        if (indexRoot == null) {
            ShowMessage.showInformation((String)"Same Model Required", (String)"All the selected connection points must be from within the same index root.");
            return;
        }
        AtomicReference<ConnectionType[]> types = new AtomicReference<ConnectionType[]>(ConfigureConnectionTypes.getConnectionTypes(connectionPoints));
        StringBuilder message = new StringBuilder();
        if (connectionPoints.size() > 1) {
            message.append("Select connection types for the selected connection points");
        } else {
            message.append("Select connection types for the selected connection point");
        }
        ConfigureConnectionTypesDialog dialog = new ConfigureConnectionTypesDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), types.get(), new ContentProviderImpl(), (ILabelProvider)new LabelProviderImpl(), new CheckStateProviderImpl(), message.toString()){

            @Override
            protected void checkStateChanged(Object[] elements, boolean checked) {
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object _g = objectArray[n2];
                    ConnectionType g = (ConnectionType)_g;
                    g.selected = checked ? Tristate.ALL : Tristate.NONE;
                    this.listViewer.refresh();
                    ++n2;
                }
            }
        };
        dialog.setTitle("Connection Type Assignments");
        dialog.setInitialSelections(ConfigureConnectionTypes.selectedElements(types.get()));
        if (dialog.open() == 0) {
            ArrayList<ConnectionType> added = new ArrayList<ConnectionType>();
            ArrayList<ConnectionType> removed = new ArrayList<ConnectionType>();
            ConnectionType[] connectionTypeArray = types.get();
            int n = connectionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionType g = connectionTypeArray[n2];
                if (g.selected != g.originallySelected && g.selected == Tristate.ALL) {
                    added.add(g);
                }
                if (g.selected != g.originallySelected && g.selected == Tristate.NONE) {
                    removed.add(g);
                }
                ++n2;
            }
            if (!added.isEmpty() || !removed.isEmpty()) {
                ArrayList<Resource> addedConnectionTypes = new ArrayList<Resource>();
                ArrayList<Resource> removedConnectionTypes = new ArrayList<Resource>();
                for (ConnectionType type : added) {
                    addedConnectionTypes.add(type.resource);
                }
                for (ConnectionType type : removed) {
                    removedConnectionTypes.add(type.resource);
                }
                Simantics.getSession().asyncRequest((Write)new AssignConnectionTypesRequest(addedConnectionTypes, removedConnectionTypes, connectionPoints));
            }
        }
    }

    private static class CheckStateProviderImpl
    implements ICheckStateProvider {
        private CheckStateProviderImpl() {
        }

        public boolean isChecked(Object element) {
            return ((ConnectionType)element).selected != Tristate.NONE;
        }

        public boolean isGrayed(Object element) {
            return ((ConnectionType)element).selected == Tristate.SOME;
        }
    }

    private static class ConnectionType
    implements Comparable<ConnectionType> {
        Resource resource;
        String name;
        Tristate originallySelected;
        Tristate selected;

        public ConnectionType(Resource resource, String name, Tristate originallySelected, Tristate selected) {
            this.resource = resource;
            this.name = name;
            this.originallySelected = originallySelected;
            this.selected = selected;
        }

        @Override
        public int compareTo(ConnectionType o) {
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)this.name, (Object)o.name);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "[name=" + this.name + ", originally selected=" + (Object)((Object)this.originallySelected) + ", selected=" + (Object)((Object)this.selected) + "]";
        }
    }

    private static class ContentProviderImpl
    implements IStructuredContentProvider {
        private ContentProviderImpl() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }
    }

    private static class LabelProviderImpl
    extends LabelProvider {
        private LabelProviderImpl() {
        }

        public String getText(Object element) {
            return ((ConnectionType)element).name;
        }
    }

    static enum Tristate {
        NONE,
        SOME,
        ALL;


        public static Tristate add(Tristate current, boolean next) {
            if (current == null) {
                return next ? ALL : NONE;
            }
            switch (current) {
                case ALL: {
                    return next ? ALL : SOME;
                }
                case SOME: {
                    return next ? SOME : SOME;
                }
                case NONE: {
                    return next ? SOME : NONE;
                }
            }
            return NONE;
        }
    }
}

