/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.graph.compiler.CompilationResult;
import org.simantics.ltk.Problem;
import org.simantics.modeling.CompilePGraphs;
import org.simantics.utils.ui.ExceptionUtils;

public class CompilePGraphsAction
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        return () -> {
            try {
                CompilePGraphs.compilePGraphs((Resource)((Resource)target), (CompilePGraphs.UserAgent)new CompileUserAgent());
            }
            catch (IOException | DatabaseException e) {
                ExceptionUtils.logAndShowError((Throwable)e);
            }
        };
    }

    public static class CompileUserAgent
    implements CompilePGraphs.UserAgent {
        public void reportProblems(CompilationResult result) {
            class ErrorMessageDialog
            extends MessageDialog {
                private final /* synthetic */ CompilationResult val$result;

                public ErrorMessageDialog(Shell shell, CompilationResult compilationResult) {
                    this.val$result = compilationResult;
                    super(shell, "Unsatisfied dependencies", null, "The following dependencies were missing. Please import the dependencies and try again.", 1, new String[]{"Continue"}, 0);
                }

                protected Control createCustomArea(Composite composite) {
                    GridLayoutFactory.fillDefaults().applyTo(composite);
                    List list = new List(composite, 2056);
                    GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)list);
                    for (Problem problem : this.val$result.getErrors()) {
                        list.add(problem.getLocation() + ": " + problem.getDescription() + "\n");
                    }
                    for (Problem problem : this.val$result.getWarnings()) {
                        list.add(problem.getLocation() + ": " + problem.getDescription() + "\n");
                    }
                    return composite;
                }
            }
            ErrorMessageDialog md = new ErrorMessageDialog(Display.getCurrent().getActiveShell(), result);
            md.open();
        }
    }
}

