/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui;

import java.util.Arrays;
import java.util.Comparator;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryProcessor;
import org.simantics.browsing.ui.common.processors.IsExpandedProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.ui.DoubleClickEvent;
import org.simantics.ui.IDoubleClickAction;
import org.simantics.ui.workbench.action.IWorkbenchActionHints;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.ui.workbench.editor.EditorRegistry;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.action.IPriorityAction;
import org.simantics.utils.ui.action.PriorityAction;

public class ExpandNodeHandler
implements IDoubleClickAction {
    public void doubleClickEvent(DoubleClickEvent e) throws DatabaseException {
        ReadGraph g = e.getGraph();
        NodeContext node = (NodeContext)ISelectionUtils.getSinglePossibleKey((Object)e.getResource(), (IHintContext.Key)SelectionHints.KEY_MAIN, NodeContext.class);
        if (node == null) {
            return;
        }
        Object widget = e.getHintContext().getHint(IWorkbenchActionHints.KEY_WIDGET);
        if (!(widget instanceof GraphExplorer)) {
            return;
        }
        GraphExplorer explorer = (GraphExplorer)widget;
        EditorAdapter[] editorAdapters = EditorRegistry.getInstance().getAdaptersFor(g, (Object)node);
        Arrays.sort(editorAdapters, new Comparator<EditorAdapter>(){

            @Override
            public int compare(EditorAdapter o1, EditorAdapter o2) {
                return -(o1.getPriority() - o2.getPriority());
            }
        });
        if (editorAdapters.length == 0) {
            e.add(this.expandAction(explorer, node));
            e.consume();
        } else if (editorAdapters.length > 1 && editorAdapters[0].getPriority() == editorAdapters[1].getPriority()) {
            e.add(this.expandAction(explorer, node));
            e.consume();
        }
    }

    private IPriorityAction expandAction(final GraphExplorer explorer, final NodeContext node) {
        return new PriorityAction(100){

            public void run() {
                PrimitiveQueryProcessor pqp = explorer.getPrimitiveProcessor(BuiltinKeys.IS_EXPANDED);
                if (pqp instanceof IsExpandedProcessor) {
                    IsExpandedProcessor iep;
                    boolean expanded = (iep = (IsExpandedProcessor)pqp).getExpanded(node);
                    iep.replaceExpanded(node, !expanded);
                }
            }
        };
    }
}

