/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.DelayedWriteRequest;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.DoesNotContainValueException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.NoInverseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.DelayedWrite;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.utils.datastructures.Callback;

public class Transaction {
    private static ThreadLocal<TransactionInfo> transactions = new ThreadLocal();

    public static ReadGraph readGraph() {
        TransactionInfo t = transactions.get();
        return t == null ? null : t.rg;
    }

    public static WriteGraph writeGraph() {
        TransactionInfo t = transactions.get();
        return t == null ? null : t.wg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object setGraph(Object graph) {
        if (graph == null) {
            transactions.set(null);
            return null;
        }
        ReadGraph oldGraph = null;
        TransactionInfo t = transactions.get();
        if (t != null) {
            oldGraph = t.rg;
            if (graph instanceof WriteGraph) {
                t.wg = (WriteGraph)graph;
                t.rg = (ReadGraph)graph;
            } else {
                if (!(graph instanceof ReadGraph)) throw new RuntimeDatabaseException("Not a sync graph");
                t.wg = null;
                t.rg = (ReadGraph)graph;
            }
        } else {
            t = new TransactionInfo(graph);
        }
        transactions.set(t);
        return oldGraph;
    }

    public static void startTransaction(RequestProcessor processor, boolean write) throws DatabaseException {
        Transaction.startTransaction(processor, write ? Type.WRITE : Type.READ);
    }

    public static void startTransaction(RequestProcessor processor, Type type) throws DatabaseException {
        switch (type) {
            case READ: {
                if (transactions.get() != null) {
                    throw new RuntimeDatabaseException("There is already a transaction.");
                }
                final Semaphore started = new Semaphore(0);
                final TransactionInfo t = new TransactionInfo();
                t.es = new Semaphore(0);
                t.ts = new Semaphore(0);
                transactions.set(t);
                Read<Object> request = new Read<Object>(){

                    public Object perform(ReadGraph g) throws DatabaseException {
                        t.wg = null;
                        t.rg = g;
                        started.release();
                        try {
                            t.ts.acquire();
                        }
                        catch (InterruptedException interruptedException) {}
                        return null;
                    }
                };
                Procedure<Object> procedure = new Procedure<Object>(){

                    public void execute(Object result) {
                        t.es.release(9999);
                    }

                    public void exception(Throwable ex) {
                        t.error = ex instanceof DatabaseException ? (DatabaseException)ex : new DatabaseException(ex);
                        t.es.release(9999);
                    }
                };
                processor.asyncRequest((Read)request, (Procedure)procedure);
                try {
                    started.acquire(1);
                    break;
                }
                catch (InterruptedException interruptedException) {
                    throw new DatabaseException("Thread was interrupted.");
                }
            }
            case WRITE: {
                if (transactions.get() != null) {
                    throw new RuntimeDatabaseException("There is already a transaction.");
                }
                final Semaphore started = new Semaphore(0);
                final TransactionInfo t = new TransactionInfo();
                t.es = new Semaphore(0);
                t.ts = new Semaphore(0);
                transactions.set(t);
                Callback<DatabaseException> callback = new Callback<DatabaseException>(){

                    public void run(DatabaseException parameter) {
                        t.error = parameter;
                        t.es.release(9999);
                    }
                };
                Write request = new Write(){

                    public void perform(WriteGraph g) throws DatabaseException {
                        t.wg = g;
                        t.rg = g;
                        started.release();
                        try {
                            t.ts.acquire();
                        }
                        catch (InterruptedException interruptedException) {}
                        if (!t.commit) {
                            throw new CancelTransactionException();
                        }
                    }
                };
                processor.asyncRequest(request, (Callback)callback);
                try {
                    started.acquire(1);
                    break;
                }
                catch (InterruptedException interruptedException) {
                    throw new DatabaseException("Thread was interrupted.");
                }
            }
            case DELAYED_WRITE: {
                if (transactions.get() != null) {
                    throw new RuntimeDatabaseException("There is already a transaction.");
                }
                final Semaphore started = new Semaphore(0);
                final TransactionInfo t = new TransactionInfo();
                t.es = new Semaphore(0);
                t.ts = new Semaphore(0);
                transactions.set(t);
                Callback<DatabaseException> callback = new Callback<DatabaseException>(){

                    public void run(DatabaseException parameter) {
                        t.error = parameter;
                        t.es.release(9999);
                    }
                };
                DelayedWriteRequest request = new DelayedWriteRequest(){

                    public void perform(WriteGraph g) throws DatabaseException {
                        t.wg = g;
                        t.rg = g;
                        started.release();
                        try {
                            t.ts.acquire();
                        }
                        catch (InterruptedException interruptedException) {}
                        if (!t.commit) {
                            throw new CancelTransactionException();
                        }
                    }
                };
                processor.asyncRequest((DelayedWrite)request, (Callback)callback);
                try {
                    started.acquire(1);
                    break;
                }
                catch (InterruptedException interruptedException) {
                    throw new DatabaseException("Thread was interrupted.");
                }
            }
        }
    }

    public static void endTransaction() throws DatabaseException {
        TransactionInfo t = transactions.get();
        if (t == null) {
            return;
        }
        t.ts.release(9999);
        try {
            t.es.acquire();
        }
        catch (InterruptedException e) {
            throw new DatabaseException((Throwable)e);
        }
        if (t.error != null && !(t.error instanceof CancelTransactionException)) {
            throw t.error;
        }
        transactions.set(null);
    }

    public static void commit() throws DatabaseException {
        TransactionInfo t = transactions.get();
        if (t == null) {
            throw new RuntimeDatabaseException("There is not transaction to commit.");
        }
        t.commit = true;
        Transaction.endTransaction();
    }

    public static String getURI(Resource resource) throws ResourceNotFoundException, ValidationException, ServiceException {
        return Transaction.readGraph().getPossibleURI(resource);
    }

    public static String getPossibleURI(Resource resource) throws ResourceNotFoundException, ValidationException, ServiceException {
        return Transaction.readGraph().getPossibleURI(resource);
    }

    public static Resource getResource(String uri) throws ResourceNotFoundException, ValidationException, ServiceException {
        return Transaction.readGraph().getResource(uri);
    }

    public static Resource getPossibleResource(String uri) throws ResourceNotFoundException, ValidationException, ServiceException {
        return Transaction.readGraph().getPossibleResource(uri);
    }

    public static Resource getBuiltin(String id) throws ResourceNotFoundException, ServiceException {
        return Transaction.readGraph().getBuiltin(id);
    }

    public static Collection<Statement> getStatements(Resource subject, Resource relation) throws ManyObjectsForFunctionalRelationException, ServiceException {
        return Transaction.readGraph().getStatements(subject, relation);
    }

    public static Collection<Statement> getAssertedStatements(Resource subject, Resource relation) throws ManyObjectsForFunctionalRelationException, ServiceException {
        return Transaction.readGraph().getAssertedStatements(subject, relation);
    }

    public static Collection<Resource> getPredicates(Resource subject) throws ServiceException {
        return Transaction.readGraph().getPredicates(subject);
    }

    public static Collection<Resource> getPrincipalTypes(Resource subject) throws ServiceException {
        return Transaction.readGraph().getPrincipalTypes(subject);
    }

    public static Set<Resource> getTypes(Resource subject) throws ServiceException {
        return Transaction.readGraph().getTypes(subject);
    }

    public static Set<Resource> getSupertypes(Resource subject) throws ServiceException {
        return Transaction.readGraph().getSupertypes(subject);
    }

    public static Set<Resource> getSuperrelations(Resource subject) throws ServiceException {
        return Transaction.readGraph().getSuperrelations(subject);
    }

    public static Collection<Resource> getObjects(Resource subject, Resource relation) throws ManyObjectsForFunctionalRelationException, ServiceException {
        return Transaction.readGraph().getObjects(subject, relation);
    }

    public static Collection<Resource> getAssertedObjects(Resource subject, Resource relation) throws ManyObjectsForFunctionalRelationException, ServiceException {
        return Transaction.readGraph().getAssertedObjects(subject, relation);
    }

    public static Resource getInverse(Resource relation) throws NoInverseException, ManyObjectsForFunctionalRelationException, ServiceException {
        return Transaction.readGraph().getInverse(relation);
    }

    public static Resource getSingleObject(Resource subject, Resource relation) throws NoSingleResultException, ManyObjectsForFunctionalRelationException, ServiceException {
        return Transaction.readGraph().getSingleObject(subject, relation);
    }

    public static Statement getSingleStatement(Resource subject, Resource relation) throws NoSingleResultException, ManyObjectsForFunctionalRelationException, ServiceException {
        return Transaction.readGraph().getSingleStatement(subject, relation);
    }

    public static Resource getSingleType(Resource subject) throws NoSingleResultException, ServiceException {
        return Transaction.readGraph().getSingleType(subject);
    }

    public static Resource getSingleType(Resource subject, Resource baseType) throws NoSingleResultException, ServiceException {
        return Transaction.readGraph().getSingleType(subject, baseType);
    }

    public static <T> T getValue(Resource subject) throws DoesNotContainValueException, ServiceException {
        return (T)Transaction.readGraph().getValue(subject);
    }

    public static <T> T getValue(Resource subject, Binding binding) throws DoesNotContainValueException, BindingException, ServiceException {
        return (T)Transaction.readGraph().getValue(subject, binding);
    }

    public static <T> T getRelatedValue(Resource subject, Resource relation) throws NoSingleResultException, DoesNotContainValueException, ServiceException {
        return (T)Transaction.readGraph().getRelatedValue(subject, relation);
    }

    public static <T> T getRelatedValue(Resource subject, Resource relation, Binding binding) throws NoSingleResultException, DoesNotContainValueException, BindingException, ServiceException {
        return (T)Transaction.readGraph().getRelatedValue(subject, relation, binding);
    }

    public static <T> T adapt(Resource resource, Class<T> clazz) throws AdaptionException, ValidationException, ServiceException {
        return (T)Transaction.readGraph().adapt(resource, clazz);
    }

    public static <T> T adaptUnique(Resource resource, Class<T> clazz) throws AdaptionException, ValidationException, ServiceException {
        return (T)Transaction.readGraph().adaptUnique(resource, clazz);
    }

    public static Resource getPossibleInverse(Resource relation) throws ManyObjectsForFunctionalRelationException, ServiceException {
        return Transaction.readGraph().getPossibleInverse(relation);
    }

    public static Resource getPossibleObject(Resource subject, Resource relation) throws ManyObjectsForFunctionalRelationException, ServiceException {
        return Transaction.readGraph().getPossibleObject(subject, relation);
    }

    public static Statement getPossibleStatement(Resource subject, Resource relation) throws ManyObjectsForFunctionalRelationException, ServiceException {
        return Transaction.readGraph().getPossibleStatement(subject, relation);
    }

    public static Resource getPossibleType(Resource subject, Resource baseType) throws ServiceException {
        return Transaction.readGraph().getPossibleType(subject, baseType);
    }

    public static <T> T getPossibleValue(Resource subject) throws ServiceException {
        return (T)Transaction.readGraph().getPossibleValue(subject);
    }

    public static <T> T getPossibleValue(Resource subject, Binding binding) throws BindingException, ServiceException {
        return (T)Transaction.readGraph().getPossibleValue(subject, binding);
    }

    public static <T> T getPossibleRelatedValue(Resource subject, Resource relation) throws ManyObjectsForFunctionalRelationException, ServiceException {
        return (T)Transaction.readGraph().getPossibleRelatedValue(subject, relation);
    }

    public static <T> T getPossibleRelatedValue(Resource subject, Resource relation, Binding binding) throws ManyObjectsForFunctionalRelationException, BindingException, ServiceException {
        return (T)Transaction.readGraph().getPossibleRelatedValue(subject, relation, binding);
    }

    public static <T> T getPossibleAdapter(Resource resource, Class<T> clazz) throws ValidationException, ServiceException {
        return (T)Transaction.readGraph().getPossibleAdapter(resource, clazz);
    }

    public static <T> T getPossibleUniqueAdapter(Resource resource, Class<T> clazz) throws ValidationException, ServiceException {
        return (T)Transaction.readGraph().getPossibleUniqueAdapter(resource, clazz);
    }

    public static boolean isInstanceOf(Resource resource, Resource type) throws ServiceException {
        return Transaction.readGraph().isInstanceOf(resource, type);
    }

    public static boolean isInheritedFrom(Resource resource, Resource type) throws ServiceException {
        return Transaction.readGraph().isInheritedFrom(resource, type);
    }

    public static boolean isSubrelationOf(Resource resource, Resource relation) throws ServiceException {
        return Transaction.readGraph().isSubrelationOf(resource, relation);
    }

    public static boolean hasStatement(Resource subject) throws ServiceException {
        return Transaction.readGraph().hasStatement(subject);
    }

    public static boolean hasStatement(Resource subject, Resource relation) throws ServiceException {
        return Transaction.readGraph().hasStatement(subject, relation);
    }

    public static boolean hasStatement(Resource subject, Resource relation, Resource object) throws ServiceException {
        return Transaction.readGraph().hasStatement(subject, relation, object);
    }

    public static boolean hasValue(Resource subject) throws ServiceException {
        return Transaction.readGraph().hasValue(subject);
    }

    public static Datatype getDataType(Resource subject) throws DatabaseException {
        return Transaction.readGraph().getDataType(subject);
    }

    public static <T extends Accessor> T getAccessor(Resource subject) throws DatabaseException {
        return (T)Transaction.readGraph().getAccessor(subject);
    }

    public static void claim(Resource subject, Resource predicate, Resource object) throws ServiceException {
        Transaction.writeGraph().claim(subject, predicate, object);
    }

    public static void claimValue(Resource resource, Resource predicate, Object value) throws ManyObjectsForFunctionalRelationException, ServiceException, DatabaseException {
        Transaction.writeGraph().claimLiteral(resource, predicate, value);
    }

    public static void claimValue(Resource resource, Resource predicate, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException, DatabaseException {
        Transaction.writeGraph().claimValue(resource, value, binding);
    }

    public static void claimValue(Resource resource, Resource predicate, Resource inverse, Resource type, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException, DatabaseException {
        Transaction.writeGraph().claimLiteral(resource, predicate, inverse, type, value, binding);
    }

    public static void deny(Resource subject) throws ServiceException {
        Transaction.writeGraph().deny(subject);
    }

    public static void deny(Resource subject, Resource predicate) throws ServiceException {
        Transaction.writeGraph().deny(subject, predicate);
    }

    public static void deny(Resource subject, Resource predicate, Resource object) throws ServiceException {
        Transaction.writeGraph().deny(subject, predicate, object);
    }

    public static void denyStatement(Resource subject, Resource predicate, Resource object) throws ServiceException {
        Transaction.writeGraph().denyStatement(subject, predicate, object);
    }

    public static void deny(Statement statement) throws ServiceException {
        Transaction.writeGraph().deny(statement);
    }

    public static void denyValue(Resource resource, Resource predicate) throws ManyObjectsForFunctionalRelationException, ServiceException {
        Transaction.writeGraph().denyValue(resource, predicate);
    }

    private static class TransactionInfo {
        WriteGraph wg;
        ReadGraph rg;
        Semaphore ts;
        Semaphore es;
        DatabaseException error;
        boolean commit = false;

        TransactionInfo() {
        }

        TransactionInfo(Object graph) {
            if (graph instanceof WriteGraph) {
                this.wg = (WriteGraph)graph;
                this.rg = (ReadGraph)graph;
            } else if (graph instanceof ReadGraph) {
                this.wg = null;
                this.rg = (ReadGraph)graph;
            } else {
                throw new RuntimeDatabaseException("Not a sync graph");
            }
        }
    }

    public static enum Type {
        READ,
        WRITE,
        DELAYED_WRITE;

    }
}

