/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.issues;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.DoesNotExist;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.errors.Failure;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.osgi.issues.SCLIssueProviderFactory;
import org.simantics.scl.osgi.issues.SCLIssuesTableEntry;
import org.simantics.scl.ui.editor2.OpenSCLDefinition;

public class SCLModuleIssueProvider
implements SCLIssueProviderFactory.SCLIssueProvider {
    ModuleRepository repository = SCLOsgi.MODULE_REPOSITORY;
    THashMap<String, CompilationError[]> currentFailures = new THashMap();
    THashMap<String, UpdateListener> updateListeners = new THashMap();
    private boolean disposed;

    SCLModuleIssueProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateListener getUpdateListener(final String moduleName, final Runnable callback) {
        UpdateListener listener;
        THashMap<String, UpdateListener> tHashMap = this.updateListeners;
        synchronized (tHashMap) {
            listener = (UpdateListener)this.updateListeners.get((Object)moduleName);
            if (listener == null) {
                listener = new UpdateListener(){

                    public void notifyAboutUpdate() {
                        if (!SCLModuleIssueProvider.this.disposed) {
                            SCLModuleIssueProvider.this.listenModule(moduleName, callback);
                        }
                    }
                };
                this.updateListeners.put((Object)moduleName, (Object)listener);
            }
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenModule(String moduleName, Runnable callback) {
        if (this.repository == null) {
            return;
        }
        Failable result = this.repository.getModule(moduleName, this.getUpdateListener(moduleName, callback));
        THashMap<String, CompilationError[]> tHashMap = this.currentFailures;
        synchronized (tHashMap) {
            if (result instanceof Failure) {
                Failure failure = (Failure)result;
                this.currentFailures.put((Object)moduleName, (Object)failure.errors);
            } else if (result == DoesNotExist.INSTANCE) {
                if (this.currentFailures.remove((Object)moduleName) == null) {
                    return;
                }
            } else {
                CompilationError[] warnings = ((Module)result.getResult()).getWarnings();
                if (warnings.length == 0) {
                    if (this.currentFailures.remove((Object)moduleName) == null) {
                        return;
                    }
                } else {
                    this.currentFailures.put((Object)moduleName, (Object)warnings);
                }
            }
        }
        if (callback != null) {
            callback.run();
        }
    }

    public void listenIssues(final Runnable callback) {
        new Thread(){

            @Override
            public void run() {
                if (SCLModuleIssueProvider.this.repository == null) {
                    return;
                }
                SCLModuleIssueProvider.this.repository.getSourceRepository().forAllModules((TObjectProcedure)new TObjectProcedure<String>(){

                    public boolean execute(String moduleName) {
                        SCLModuleIssueProvider.this.listenModule(moduleName, callback);
                        return true;
                    }
                });
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SCLIssuesTableEntry> getIssues() {
        ArrayList<SCLIssuesTableEntry> result = new ArrayList<SCLIssuesTableEntry>();
        THashMap<String, CompilationError[]> tHashMap = this.currentFailures;
        synchronized (tHashMap) {
            Object[] moduleNames = this.currentFailures.keySet().toArray(new String[this.currentFailures.size()]);
            Arrays.sort(moduleNames);
            Object[] objectArray = moduleNames;
            int n = moduleNames.length;
            int n2 = 0;
            while (n2 < n) {
                CompilationError[] errors;
                Object moduleName = objectArray[n2];
                CompilationError[] compilationErrorArray = errors = (CompilationError[])this.currentFailures.get(moduleName);
                int n3 = errors.length;
                int n4 = 0;
                while (n4 < n3) {
                    CompilationError error = compilationErrorArray[n4];
                    result.add(new SCLIssuesTableEntry((String)moduleName, error){

                        public void openLocation() {
                            OpenSCLDefinition.scheduleOpenDefinition(this.moduleName, this.error.location);
                        }
                    });
                    ++n4;
                }
                ++n2;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.repository != null) {
            THashMap<String, UpdateListener> tHashMap = this.updateListeners;
            synchronized (tHashMap) {
                this.updateListeners.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, UpdateListener>(){

                    public boolean execute(String moduleName, UpdateListener listener) {
                        listener.stopListening();
                        return true;
                    }
                });
                this.updateListeners.clear();
            }
        }
    }

    public static class SCLModuleIssueProviderFactory
    implements SCLIssueProviderFactory {
        public SCLIssueProviderFactory.SCLIssueProvider getSCLIssueProvider() {
            return new SCLModuleIssueProvider();
        }
    }
}

