/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.module;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.modules.Documentation;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.rules.MappingRelation;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.environment.filter.NamespaceFilter;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.internal.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.debug.ModuleDebugInfo;
import org.simantics.scl.compiler.top.ModuleInitializer;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.runtime.profiling.BranchPoint;

public class ConcreteModule
implements Module {
    String moduleName;
    String defaultLocalName;
    String deprecation;
    THashMap<String, TypeDescriptor> typeDescriptors = new THashMap();
    THashMap<String, EffectConstructor> effectConstructors = new THashMap();
    THashMap<String, TypeClass> typeClasses = new THashMap();
    THashMap<TCon, ArrayList<TypeClassInstance>> typeClassInstances = new THashMap();
    THashMap<String, SCLValue> values = new THashMap();
    THashMap<String, List<Constant>> fieldAccessors = new THashMap();
    THashMap<String, SCLRelation> relations = new THashMap(2);
    THashMap<String, SCLEntityType> entityTypes = new THashMap(2);
    THashMap<String, TransformationRule> rules = new THashMap(2);
    THashMap<String, MappingRelation> mappingRelations = new THashMap(2);
    THashMap<String, CHRRuleset> rulesets = new THashMap(2);
    ArrayList<ImportDeclaration> dependencies = new ArrayList();
    THashMap<String, BranchPoint[]> branchPoints;
    CompilationError[] warnings = CompilationError.EMPTY_ARRAY;
    Map<String, byte[]> classes = Collections.emptyMap();
    ClassLoader parentClassLoader;
    ModuleInitializer moduleInitializer;
    protected Documentation documentation;
    public ModuleDebugInfo moduleDebugInfo;

    public ConcreteModule(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    public String getDefaultLocalName() {
        return this.defaultLocalName;
    }

    public void setDefaultLocalName(String defaultLocalName) {
        this.defaultLocalName = defaultLocalName;
    }

    public boolean addTypeDescriptor(String name, TypeDescriptor typeConstructor) {
        return this.typeDescriptors.put((Object)name, (Object)typeConstructor) != null;
    }

    public boolean addEffectConstructor(String name, EffectConstructor effectConstructor) {
        return this.effectConstructors.put((Object)name, (Object)effectConstructor) != null;
    }

    public boolean addTypeClass(String name, TypeClass typeClass) {
        return this.typeClasses.put((Object)name, (Object)typeClass) != null;
    }

    public void addTypeClassInstance(TCon typeClass, TypeClassInstance typeClassInstance) {
        ArrayList<TypeClassInstance> instances = (ArrayList<TypeClassInstance>)this.typeClassInstances.get((Object)typeClass);
        if (instances == null) {
            instances = new ArrayList<TypeClassInstance>();
            this.typeClassInstances.put((Object)typeClass, instances);
        }
        instances.add(typeClassInstance);
    }

    public boolean addRule(TransformationRule rule) {
        return this.rules.put((Object)rule.name.name, (Object)rule) != null;
    }

    public boolean addMappingRelation(MappingRelation relation) {
        return this.mappingRelations.put((Object)relation.name.name, (Object)relation) != null;
    }

    public Collection<TCon> getTypeClassesWithInstances() {
        return this.typeClassInstances.keySet();
    }

    public boolean addValue(SCLValue value) {
        return this.values.put((Object)value.getName().name, (Object)value) != null;
    }

    public SCLValue addValue(String name, Constant constant) {
        SCLValue value = new SCLValue(Name.create(this.moduleName, name), constant);
        this.addValue(value);
        return value;
    }

    @Override
    public List<Constant> getFieldAccessors(String name) {
        return (List)this.fieldAccessors.get((Object)name);
    }

    public void addRelation(String name, SCLRelation relation) {
        this.relations.put((Object)name, (Object)relation);
    }

    public void addEntityType(String name, SCLEntityType entityType) {
        this.entityTypes.put((Object)name, (Object)entityType);
    }

    public void addDependency(ImportDeclaration module) {
        if (!this.dependencies.contains(module)) {
            this.dependencies.add(module);
        }
    }

    public Collection<SCLValue> getValues() {
        return this.values.values();
    }

    @Override
    public Collection<TransformationRule> getRules() {
        return this.rules.values();
    }

    public Collection<MappingRelation> getMappingRelations() {
        return this.mappingRelations.values();
    }

    @Override
    public String getName() {
        return this.moduleName;
    }

    @Override
    public SCLValue getValue(String name) {
        return (SCLValue)this.values.get((Object)name);
    }

    @Override
    public SCLRelation getRelation(String name) {
        return (SCLRelation)this.relations.get((Object)name);
    }

    @Override
    public MappingRelation getMappingRelation(String name) {
        return (MappingRelation)this.mappingRelations.get((Object)name);
    }

    @Override
    public TransformationRule getRule(String name) {
        return (TransformationRule)this.rules.get((Object)name);
    }

    @Override
    public SCLEntityType getEntityType(String name) {
        return (SCLEntityType)this.entityTypes.get((Object)name);
    }

    @Override
    public TypeClass getTypeClass(String name) {
        return (TypeClass)this.typeClasses.get((Object)name);
    }

    @Override
    public Collection<TypeClassInstance> getInstances(TCon typeClass) {
        Collection result = (Collection)this.typeClassInstances.get((Object)typeClass);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public TypeDescriptor getTypeDescriptor(String name) {
        return (TypeDescriptor)this.typeDescriptors.get((Object)name);
    }

    @Override
    public EffectConstructor getEffectConstructor(String name) {
        return (EffectConstructor)this.effectConstructors.get((Object)name);
    }

    @Override
    public CHRRuleset getRuleset(String name) {
        return (CHRRuleset)this.rulesets.get((Object)name);
    }

    public Collection<TypeClass> getTypeClasses() {
        return this.typeClasses.values();
    }

    public THashMap<TCon, ArrayList<TypeClassInstance>> getTypeInstances() {
        return this.typeClassInstances;
    }

    @Override
    public List<ImportDeclaration> getDependencies() {
        return this.dependencies;
    }

    public void setDocumentation(Documentation documentation) {
        this.documentation = documentation;
    }

    @Override
    public Documentation getDocumentation() {
        return this.documentation;
    }

    public void setClasses(Map<String, byte[]> classes) {
        this.classes = classes;
    }

    @Override
    public byte[] getClass(String name) {
        return this.classes.get(name);
    }

    public void setModuleInitializer(ModuleInitializer moduleInitializer) {
        this.moduleInitializer = moduleInitializer;
    }

    @Override
    public ModuleInitializer getModuleInitializer() {
        return this.moduleInitializer;
    }

    public String toString() {
        return this.moduleName;
    }

    @Override
    public void findValuesForPrefix(final String prefix, final NamespaceFilter filter, final TObjectProcedure<SCLValue> proc) {
        this.values.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, SCLValue>(){

            public boolean execute(String name, SCLValue value) {
                if (value.isPrivateOrDerived()) {
                    return true;
                }
                String lowerPrefix = prefix.toLowerCase();
                String lowerName = name.toLowerCase();
                if (lowerName.startsWith(lowerPrefix) && filter.isValueIncluded(name)) {
                    proc.execute((Object)value);
                }
                return true;
            }
        });
    }

    @Override
    public void findValuesForPrefix(String prefix, NamespaceFilter filter, Consumer<SCLValue> consumer) {
        this.values.values().forEach(value -> {
            String lowerPrefix = prefix.toLowerCase();
            String lowerName = value.getName().name.toLowerCase();
            if (lowerName.startsWith(lowerPrefix) && filter.isValueIncluded(value.getName().name)) {
                consumer.accept((SCLValue)value);
            }
        });
    }

    @Override
    public List<String> getValueNames() {
        return new ArrayList<String>(this.values.keySet());
    }

    public Collection<SCLRelation> getRelations() {
        return this.relations.values();
    }

    @Override
    public void findTypesForPrefix(String prefix, NamespaceFilter filter, Consumer<TCon> consumer) {
        this.typeDescriptors.values().forEach(type -> {
            TCon tcon = type.name;
            if (tcon.name.toLowerCase().startsWith(prefix.toLowerCase()) && filter.isValueIncluded(tcon.name)) {
                consumer.accept(tcon);
            }
        });
    }

    public void setBranchPoints(THashMap<String, BranchPoint[]> branchPoints) {
        this.branchPoints = branchPoints;
    }

    @Override
    public THashMap<String, BranchPoint[]> getBranchPoints() {
        return this.branchPoints;
    }

    @Override
    public void dispose() {
    }

    public void setWarnings(CompilationError[] warnings) {
        this.warnings = warnings;
    }

    @Override
    public CompilationError[] getWarnings() {
        return this.warnings;
    }

    @Override
    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        if (parentClassLoader == null) {
            throw new NullPointerException();
        }
        this.parentClassLoader = parentClassLoader;
    }

    public void addFieldAccessor(String name, Constant accessor) {
        ArrayList<Constant> list = (ArrayList<Constant>)this.fieldAccessors.get((Object)name);
        if (list == null) {
            list = new ArrayList<Constant>(2);
            this.fieldAccessors.put((Object)name, list);
        }
        list.add(accessor);
    }

    public void addRuleset(String name, CHRRuleset ruleset) {
        this.rulesets.put((Object)name, (Object)ruleset);
    }

    @Override
    public String getDeprecation() {
        return this.deprecation;
    }

    public void setDeprecation(String deprecation) {
        this.deprecation = deprecation;
    }

    @Override
    public ModuleDebugInfo getModuleDebugInfo() {
        return this.moduleDebugInfo;
    }
}

