/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.types;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.elaboration.modules.TypeAlias;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.environment.AmbiguousNameException;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class TVarAst
extends TypeAst {
    public final String name;

    public TVarAst(String name) {
        this.name = name;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append(this.name);
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        TCon con;
        block14: {
            char c = this.name.charAt(0);
            if (c == '(') {
                int i = 1;
                while (i < this.name.length() - 1) {
                    if (this.name.charAt(i) != ',') {
                        try {
                            con = Environments.getTypeDescriptorName(context.getEnvironment(), this.name.substring(1, this.name.length() - 1));
                        }
                        catch (AmbiguousNameException e) {
                            context.getErrorLog().log(this.location, e.getMessage());
                            return Types.metaVar(Kinds.STAR);
                        }
                        if (con == null) {
                            context.getErrorLog().log(this.location, "Didn't find type constructor " + this.name + ".");
                            return Types.metaVar(Kinds.STAR);
                        }
                        break block14;
                    }
                    ++i;
                }
                con = Types.con("Builtin", this.name);
            } else {
                TypeDescriptor tdesc;
                if (Character.isLowerCase(c)) {
                    return context.resolveTypeVariable(this.location, this.name, expectedKind);
                }
                if (c == '?') {
                    return context.resolveExistential(this.location, this.name, expectedKind);
                }
                try {
                    tdesc = Environments.getTypeDescriptor(context.getEnvironment(), this.name);
                }
                catch (AmbiguousNameException e) {
                    context.getErrorLog().log(this.location, e.getMessage());
                    return Types.metaVar(Kinds.STAR);
                }
                if (tdesc == null) {
                    context.getErrorLog().log(this.location, "Didn't find type constructor " + this.name + ".");
                    return Types.metaVar(Kinds.STAR);
                }
                if (tdesc instanceof TypeAlias) {
                    TypeAlias alias = (TypeAlias)tdesc;
                    if (alias.getArity() > 0) {
                        context.getErrorLog().log(this.location, "The alias expects " + alias.getArity() + " parameters, but none are given.");
                        return Types.metaVar(Kinds.metaVar());
                    }
                    return alias.body;
                }
                con = tdesc.name;
            }
        }
        Kind providedKind = context.getKind(con);
        context.unify(this.location, providedKind, expectedKind);
        return con;
    }

    @Override
    public Type toType(TypeElaborationContext context) {
        Type con;
        block8: {
            char c = this.name.charAt(0);
            if (c == '(') {
                int i = 1;
                while (i < this.name.length() - 1) {
                    if (this.name.charAt(i) != ',') {
                        con = context.resolveTypeConstructor(this.name.substring(1, this.name.length() - 1));
                        if (con == null) {
                            System.err.println("Didn't find type constructor " + this.name + ".");
                            return Types.metaVar(Kinds.STAR);
                        }
                        break block8;
                    }
                    ++i;
                }
                con = Types.con("Builtin", this.name);
            } else {
                if (Character.isLowerCase(c)) {
                    return context.resolveTypeVariable(this.name);
                }
                if (c == '?') {
                    return context.resolveExistential(this.name);
                }
                con = context.resolveTypeConstructor(this.name);
                if (con == null) {
                    System.err.println("Didn't find type constructor " + this.name + ".");
                    return Types.metaVar(Kinds.STAR);
                }
            }
        }
        return con;
    }

    @Override
    public Type toEffect(TypeTranslationContext context) {
        TCon con;
        char c = this.name.charAt(0);
        if (Character.isLowerCase(c)) {
            return context.resolveTypeVariable(this.location, this.name, Kinds.EFFECT);
        }
        try {
            con = Environments.getEffectConstructorName(context.getEnvironment(), this.name);
        }
        catch (AmbiguousNameException e) {
            context.getErrorLog().log(this.location, e.getMessage());
            return Types.metaVar(Kinds.EFFECT);
        }
        if (con == null) {
            context.getErrorLog().log(this.location, "Didn't find effect constructor " + this.name + ".");
            return Types.metaVar(Kinds.EFFECT);
        }
        return con;
    }

    @Override
    public Type toEffect(TypeElaborationContext context) {
        char c = this.name.charAt(0);
        if (Character.isLowerCase(c)) {
            return context.resolveTypeVariable(this.name);
        }
        if (c == '?') {
            return context.resolveExistential(this.name);
        }
        Type con = context.resolveTypeConstructor(this.name);
        if (con == null) {
            System.err.println("Didn't find effect constructor " + this.name + ".");
            return Types.metaVar(Kinds.EFFECT);
        }
        return con;
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public void collectReferences(TObjectIntHashMap<String> typeNameMap, TIntHashSet set) {
        if (typeNameMap.containsKey((Object)this.name)) {
            set.add(typeNameMap.get((Object)this.name));
        }
    }
}

