/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.types;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class TPredAst
extends TypeAst {
    public final TypeAst constraint;
    public final TypeAst type;

    public TPredAst(TypeAst constraint, TypeAst type) {
        this.constraint = constraint;
        this.type = type;
    }

    @Override
    public void toString(StringBuilder b) {
        this.constraint.toString(b);
        b.append(" => ");
        this.type.toString(b);
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        context.unify(this.location, Kinds.STAR, expectedKind);
        return Types.constrained(this.constraint.toTFuncApply(context), this.type.toType(context, Kinds.STAR));
    }

    @Override
    public Type toType(TypeElaborationContext context) {
        return Types.constrained(this.constraint.toTFuncApply(context), this.type.toType(context));
    }

    @Override
    public int getPrecedence() {
        return 2;
    }

    @Override
    public void collectReferences(TObjectIntHashMap<String> typeNameMap, TIntHashSet set) {
        this.constraint.collectReferences(typeNameMap, set);
        this.type.collectReferences(typeNameMap, set);
    }
}

