/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.precedence.Associativity;
import org.simantics.scl.compiler.common.precedence.Precedence;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.CharacterConstant;
import org.simantics.scl.compiler.constants.StringConstant;
import org.simantics.scl.compiler.elaboration.chr.ast.CHRAstAtom;
import org.simantics.scl.compiler.elaboration.chr.ast.CHRAstBinds;
import org.simantics.scl.compiler.elaboration.chr.ast.CHRAstConjunction;
import org.simantics.scl.compiler.elaboration.chr.ast.CHRAstEquals;
import org.simantics.scl.compiler.elaboration.chr.ast.CHRAstQuery;
import org.simantics.scl.compiler.elaboration.equation.EqBasic;
import org.simantics.scl.compiler.elaboration.equation.EqGuard;
import org.simantics.scl.compiler.elaboration.equation.Equation;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EAsPattern;
import org.simantics.scl.compiler.elaboration.expressions.EBinary;
import org.simantics.scl.compiler.elaboration.expressions.EBinaryRightSide;
import org.simantics.scl.compiler.elaboration.expressions.EBlock;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EEnforce;
import org.simantics.scl.compiler.elaboration.expressions.EEquations;
import org.simantics.scl.compiler.elaboration.expressions.EFieldAccess;
import org.simantics.scl.compiler.elaboration.expressions.EIf;
import org.simantics.scl.compiler.elaboration.expressions.EIntegerLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.EListComprehension;
import org.simantics.scl.compiler.elaboration.expressions.EListLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EMatch;
import org.simantics.scl.compiler.elaboration.expressions.EPreCHRSelect;
import org.simantics.scl.compiler.elaboration.expressions.ERange;
import org.simantics.scl.compiler.elaboration.expressions.ERealLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ERecord;
import org.simantics.scl.compiler.elaboration.expressions.ESelect;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.EStringLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ETransformation;
import org.simantics.scl.compiler.elaboration.expressions.ETypeAnnotation;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.EViewPattern;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.GuardedExpression;
import org.simantics.scl.compiler.elaboration.expressions.GuardedExpressionGroup;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.accessor.ExpressionAccessor;
import org.simantics.scl.compiler.elaboration.expressions.accessor.FieldAccessor;
import org.simantics.scl.compiler.elaboration.expressions.accessor.IdAccessor;
import org.simantics.scl.compiler.elaboration.expressions.accessor.StringAccessor;
import org.simantics.scl.compiler.elaboration.expressions.block.BindStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.BlockType;
import org.simantics.scl.compiler.elaboration.expressions.block.CHRStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.ConstraintStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.GuardStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.IncludeStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.RuleStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.elaboration.expressions.list.ListAssignment;
import org.simantics.scl.compiler.elaboration.expressions.list.ListGenerator;
import org.simantics.scl.compiler.elaboration.expressions.list.ListGuard;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifier;
import org.simantics.scl.compiler.elaboration.expressions.list.ListSeq;
import org.simantics.scl.compiler.elaboration.expressions.list.ListThen;
import org.simantics.scl.compiler.elaboration.expressions.records.FieldAssignment;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.query.QAlternative;
import org.simantics.scl.compiler.elaboration.query.QConjunction;
import org.simantics.scl.compiler.elaboration.query.QDisjunction;
import org.simantics.scl.compiler.elaboration.query.QNegation;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.pre.QPreBinds;
import org.simantics.scl.compiler.elaboration.query.pre.QPreEquals;
import org.simantics.scl.compiler.elaboration.query.pre.QPreGuard;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.header.ModuleHeader;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.internal.parsing.Token;
import org.simantics.scl.compiler.internal.parsing.declarations.ConstructorAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DAnnotationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DClassAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DDataAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DDerivingInstanceAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DDocumentationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DEffectAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DFixityAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DImportJavaAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DInstanceAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DMappingRelationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DRelationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DRuleAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DRulesetAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DTypeAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DValueAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DValueTypeAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DeclarationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.FieldDescription;
import org.simantics.scl.compiler.internal.parsing.declarations.FundepAst;
import org.simantics.scl.compiler.internal.parsing.exceptions.SCLSyntaxErrorException;
import org.simantics.scl.compiler.internal.parsing.parser.SCLParser;
import org.simantics.scl.compiler.internal.parsing.parser.SCLParserOptions;
import org.simantics.scl.compiler.internal.parsing.parser.SCLPostLexer;
import org.simantics.scl.compiler.internal.parsing.types.TApplyAst;
import org.simantics.scl.compiler.internal.parsing.types.TEffectAst;
import org.simantics.scl.compiler.internal.parsing.types.TForAllAst;
import org.simantics.scl.compiler.internal.parsing.types.TFunctionAst;
import org.simantics.scl.compiler.internal.parsing.types.TListAst;
import org.simantics.scl.compiler.internal.parsing.types.TPredAst;
import org.simantics.scl.compiler.internal.parsing.types.TTupleAst;
import org.simantics.scl.compiler.internal.parsing.types.TVarAst;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.types.Types;

public class SCLParserImpl
extends SCLParser {
    private final SCLPostLexer lexer;
    private SCLParserOptions options;
    private CompilationContext context;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public SCLParserImpl(Reader reader) {
        this.lexer = new SCLPostLexer(reader);
    }

    public SCLPostLexer getLexer() {
        return this.lexer;
    }

    public void setCompilationContext(CompilationContext context) {
        this.context = context;
        this.lexer.setCompilationContext(context);
    }

    public void setParserOptions(SCLParserOptions options) {
        this.options = options;
        this.lexer.setParserOptions(options);
    }

    public boolean isEmpty() throws Exception {
        return this.lexer.peekToken().id == 85;
    }

    @Override
    protected Token nextToken() {
        try {
            Token token = this.lexer.nextToken();
            return token;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object reduceDeclarations() {
        ArrayList<DeclarationAst> declarations = new ArrayList<DeclarationAst>(this.length() / 2);
        int i = 1;
        while (i < this.length()) {
            declarations.add((DeclarationAst)this.get(i));
            i += 2;
        }
        return declarations;
    }

    @Override
    protected Object reduceModule() {
        ArrayList<DeclarationAst> declarations = new ArrayList<DeclarationAst>(this.length() / 2 + 1);
        int i = 0;
        while (i < this.length()) {
            DeclarationAst declaration = (DeclarationAst)this.get(i);
            if (declaration != null) {
                declarations.add(declaration);
            }
            i += 2;
        }
        return declarations;
    }

    @Override
    protected Object reduceModuleHeader() {
        FieldAssignment[] fields = new FieldAssignment[this.length() / 2 - 1];
        int i = 0;
        while (i < fields.length) {
            fields[i] = (FieldAssignment)this.get(2 + i * 2);
            ++i;
        }
        this.context.header = ModuleHeader.process(this.context.errorLog, fields);
        return null;
    }

    @Override
    protected Object reduceLocalTypeAnnotation() {
        if (this.length() == 1) {
            return this.get(0);
        }
        return new ETypeAnnotation((Expression)this.get(0), (TypeAst)this.get(2));
    }

    @Override
    protected Object reduceTypeAnnotation() {
        EVar[] names = new EVar[this.length() / 2];
        int i = 0;
        while (i < names.length) {
            names[i] = (EVar)this.get(i * 2);
            ++i;
        }
        return new DValueTypeAst(names, (TypeAst)this.get(this.length() - 1));
    }

    @Override
    protected Object reduceValueDefinition() {
        Expression rhs = (Expression)this.get(1);
        return new DValueAst((Expression)this.get(0), rhs);
    }

    @Override
    protected Object reduceDataDefinition() {
        int i = 2;
        ArrayList<String> parameters = new ArrayList<String>();
        while (i < this.length()) {
            Token token = (Token)this.get(i++);
            if (token.id != 7) break;
            parameters.add(token.text);
        }
        ArrayList<ConstructorAst> constructors = new ArrayList<ConstructorAst>();
        while (i < this.length()) {
            constructors.add((ConstructorAst)this.get(i));
            i += 2;
        }
        return new DDataAst(((Token)this.get((int)1)).text, parameters.toArray(new String[parameters.size()]), constructors.toArray(new ConstructorAst[constructors.size()]), new String[0]);
    }

    @Override
    protected Object reduceTypeDefinition() {
        int i = 2;
        ArrayList<String> parameters = new ArrayList<String>();
        while (true) {
            Token token = (Token)this.get(i++);
            if (token.id != 7) break;
            parameters.add(token.text);
        }
        return new DTypeAst(((Token)this.get((int)1)).text, parameters.toArray(new String[parameters.size()]), (TypeAst)this.get(i));
    }

    @Override
    protected Object reduceClassDefinition() {
        int i = 1;
        ArrayList context = this.get(i) instanceof Token ? new ArrayList(0) : (ArrayList)this.get(i++);
        String name = ((Token)this.get((int)i++)).text;
        ArrayList<String> parameters = new ArrayList<String>();
        while (i < this.length()) {
            Token token = (Token)this.get(i);
            if (token.id != 7) break;
            parameters.add(token.text);
            ++i;
        }
        ArrayList declarations = null;
        FundepAst[] fundeps = FundepAst.EMPTY_ARRAY;
        while (i < this.length()) {
            Token token = (Token)this.get(i++);
            if (token.id == 12) {
                declarations = (ArrayList)this.get(i++);
                continue;
            }
            if (token.id == 9) {
                fundeps = (FundepAst[])this.get(i++);
                continue;
            }
            throw new InternalCompilerError();
        }
        return new DClassAst(context, name, parameters.toArray(new String[parameters.size()]), fundeps, declarations);
    }

    @Override
    protected Object reduceFundep() {
        String[] from = new String[this.length() - 2];
        int i = 0;
        while (i < from.length) {
            from[i] = ((Token)this.get((int)i)).text;
            ++i;
        }
        String to = ((Token)this.get((int)(this.length() - 1))).text;
        return new FundepAst(from, to);
    }

    @Override
    protected Object reduceFundeps() {
        FundepAst[] fundeps = new FundepAst[(this.length() + 1) / 2];
        int i = 0;
        while (i < fundeps.length) {
            fundeps[i] = (FundepAst)this.get(i * 2);
            ++i;
        }
        return fundeps;
    }

    @Override
    protected Object reduceInstanceDefinition() {
        int i = 1;
        ArrayList context = this.get(i) instanceof Token ? new ArrayList(0) : (ArrayList)this.get(i++);
        Token nameToken = (Token)this.get(i++);
        EVar name = new EVar(nameToken);
        ArrayList<TypeAst> parameters = new ArrayList<TypeAst>();
        while (i < this.length()) {
            Object symbol;
            if ((symbol = this.get(i++)) instanceof Token) break;
            parameters.add((TypeAst)symbol);
        }
        ArrayList declarations = null;
        if (i < this.length()) {
            declarations = (ArrayList)this.get(i);
        }
        return new DInstanceAst(context, name, parameters.toArray(new TypeAst[parameters.size()]), declarations);
    }

    @Override
    protected Object reduceDerivingInstanceDefinition() {
        int i = 2;
        ArrayList context = this.get(i) instanceof Token ? new ArrayList(0) : (ArrayList)this.get(i++);
        Token nameToken = (Token)this.get(i++);
        EVar name = new EVar(nameToken);
        ArrayList<TypeAst> parameters = new ArrayList<TypeAst>();
        while (i < this.length()) {
            Object symbol = this.get(i++);
            parameters.add((TypeAst)symbol);
        }
        return new DDerivingInstanceAst(context, name, parameters.toArray(new TypeAst[parameters.size()]));
    }

    @Override
    protected Object reduceDocumentationString() {
        return new DDocumentationAst(((Token)this.get((int)1)).text);
    }

    @Override
    protected Object reduceAnnotation() {
        ArrayList<Expression> parameters = new ArrayList<Expression>(this.length() - 1);
        int i = 1;
        while (i < this.length()) {
            parameters.add((Expression)this.get(i));
            ++i;
        }
        return new DAnnotationAst((Token)this.get(0), parameters);
    }

    @Override
    protected Object reducePrecedenceDefinition() {
        EVar[] symbols = new EVar[this.length() / 2];
        int i = 0;
        while (i < symbols.length) {
            symbols[i] = (EVar)this.get(2 * i + 2);
            ++i;
        }
        Token token = (Token)this.get(0);
        Associativity associativity = token.text.equals("infixl") ? Associativity.LEFT : (token.text.equals("infixr") ? Associativity.RIGHT : Associativity.NONASSOC);
        return new DFixityAst(new Precedence(Integer.parseInt(((Token)this.get((int)1)).text), associativity), symbols);
    }

    @Override
    protected Object reduceImport() {
        Object temp;
        int pos = 0;
        String importKeyword = ((Token)this.get((int)pos++)).text;
        int n = ++pos;
        String moduleName = ((Token)this.get((int)n)).text;
        String localName = "";
        if (++pos < this.length() && (temp = this.get(pos)) instanceof Token) {
            Token token = (Token)temp;
            if (token.id == 32) {
                int n2 = ++pos;
                ++pos;
                localName = ((Token)this.get((int)n2)).text;
            }
        }
        ImportDeclaration.ImportSpec spec = ImportDeclaration.DEFAULT_SPEC;
        if (pos < this.length()) {
            spec = (ImportDeclaration.ImportSpec)this.get(pos++);
        }
        return new ImportDeclaration(moduleName, localName, importKeyword.equals("include"), spec);
    }

    @Override
    protected Object reduceJustImport() {
        return this.get(0);
    }

    @Override
    protected Object reduceImportJava() {
        return new DImportJavaAst(((Token)this.get((int)2)).text, (ArrayList)this.get(4));
    }

    @Override
    protected Object reduceEffectDefinition() {
        return new DEffectAst(((Token)this.get((int)1)).text, ((Token)this.get((int)3)).text, ((Token)this.get((int)5)).text);
    }

    @Override
    protected Object reduceVarId() {
        return new EVar((Token)this.get(0));
    }

    @Override
    protected Object reduceEscapedSymbol() {
        return new EVar((Token)this.get(0));
    }

    @Override
    protected Object reduceTupleTypeConstructor() {
        return new TVarAst(Types.tupleConstructor((int)(this.length() - 1)).name);
    }

    @Override
    protected Object reduceArrow() {
        int i = this.length() - 1;
        TypeAst result = (TypeAst)this.get(i);
        i -= 2;
        while (i >= 0) {
            result = ((Token)this.get((int)(i + 1))).text.equals("=>") ? new TPredAst((TypeAst)this.get(i), result) : new TFunctionAst((TypeAst)this.get(i), result);
            i -= 2;
        }
        return result;
    }

    @Override
    protected Object reduceBinary() {
        if (this.length() == 1) {
            return this.get(0);
        }
        int i = 0;
        EVar negation = null;
        if (this.get(i) instanceof Token) {
            Token token = (Token)this.get(i++);
            negation = new EVar(token);
        }
        EBinary binary = new EBinary((Expression)this.get(i++), negation);
        while (i < this.length()) {
            EVar operator = (EVar)this.get(i++);
            Expression right = (Expression)this.get(i++);
            binary.rights.add(new EBinaryRightSide(operator, right));
        }
        return binary;
    }

    @Override
    protected Object reduceSimpleRhs() {
        if (this.length() == 2) {
            return this.get(1);
        }
        EBlock block = (EBlock)this.get(3);
        Expression expression = (Expression)this.get(1);
        block.addStatement(new GuardStatement(expression));
        block.location = Locations.location(Locations.beginOf(expression.location), Locations.endOf(block.location));
        return block;
    }

    private GuardedExpressionGroup reduceGuardedExpressionGroup(int length) {
        GuardedExpression[] expressions = new GuardedExpression[length];
        int i = 0;
        while (i < expressions.length) {
            expressions[i] = (GuardedExpression)this.get(i);
            ++i;
        }
        return new GuardedExpressionGroup(expressions);
    }

    @Override
    protected Object reduceGuardedRhs() {
        int length = this.length();
        if (length > 2 && this.get(length - 2) instanceof Token) {
            EBlock block = (EBlock)this.get(length - 1);
            block.addStatement(new GuardStatement(this.reduceGuardedExpressionGroup(length - 2)));
            block.location = 9223372034707292160L;
            return block;
        }
        return this.reduceGuardedExpressionGroup(length);
    }

    @Override
    protected Object reduceStatements() {
        EBlock block = new EBlock();
        if (this.length() > 2) {
            int i = 1;
            while (i < this.length()) {
                block.addStatement((Statement)this.get(i));
                i += 2;
            }
        }
        return block;
    }

    @Override
    protected Object reduceConstructor() {
        int idPos = 0;
        while (idPos < this.length()) {
            if (((Token)this.get((int)idPos)).id == 7) break;
            idPos += 2;
        }
        DAnnotationAst[] annotations = idPos == 0 ? DAnnotationAst.EMPTY_ARRAY : new DAnnotationAst[idPos / 2];
        int i = 0;
        while (i < idPos / 2) {
            annotations[i] = new DAnnotationAst((Token)this.get(i * 2), Arrays.asList((Expression)this.get(i * 2 + 1)));
            ++i;
        }
        TypeAst[] parameters = new TypeAst[this.length() - idPos - 1];
        int i2 = 0;
        while (i2 < parameters.length) {
            parameters[i2] = (TypeAst)this.get(i2 + idPos + 1);
            ++i2;
        }
        return new ConstructorAst(annotations, (Token)this.get(idPos), parameters, null);
    }

    @Override
    protected Object reduceContext() {
        ArrayList<TypeAst> result = new ArrayList<TypeAst>(this.length() / 2 - 1);
        int i = 1;
        while (i < this.length() - 2) {
            result.add((TypeAst)this.get(i));
            i += 2;
        }
        return result;
    }

    @Override
    protected Object reduceTypeVar() {
        return new TVarAst(((Token)this.get((int)0)).text);
    }

    @Override
    protected Object reduceTupleType() {
        if (this.length() == 2) {
            return new TTupleAst(TypeAst.EMPTY_ARRAY);
        }
        if (this.length() == 3) {
            Symbol sym = (Symbol)this.get(1);
            sym.location = 9223372034707292160L;
            return sym;
        }
        int dim = this.length() / 2;
        TypeAst[] parameters = new TypeAst[dim];
        int i = 0;
        while (i < dim) {
            parameters[i] = (TypeAst)this.get(i * 2 + 1);
            ++i;
        }
        return new TTupleAst(parameters);
    }

    @Override
    protected Object reduceListType() {
        return new TListAst((TypeAst)this.get(1));
    }

    @Override
    protected Object reduceListTypeConstructor() {
        return new TVarAst("[]");
    }

    @Override
    protected Object reduceTupleConstructor() {
        return new EVar(Types.tupleConstructor((int)(this.length() - 1)).name);
    }

    @Override
    protected Object reduceVar() {
        return this.get(0);
    }

    @Override
    protected Object reduceBlank() {
        return new EVar(((Token)this.get((int)0)).location, "_");
    }

    @Override
    protected Object reduceInteger() {
        return new EIntegerLiteral(((Token)this.get((int)0)).text);
    }

    @Override
    protected Object reduceFloat() {
        return new ERealLiteral(((Token)this.get((int)0)).text);
    }

    @Override
    protected Object reduceString() {
        return this.get(0);
    }

    @Override
    protected Object reduceChar() {
        String text = ((Token)this.get((int)0)).text;
        char c = text.charAt(text.length() - 2);
        if (text.length() == 4) {
            switch (c) {
                case 'n': {
                    c = '\n';
                    break;
                }
                case 't': {
                    c = '\t';
                    break;
                }
                case 'b': {
                    c = '\b';
                    break;
                }
                case 'f': {
                    c = '\f';
                    break;
                }
                case 'r': {
                    c = '\r';
                }
            }
        }
        return new ELiteral(new CharacterConstant(c));
    }

    @Override
    protected Object reduceTuple() {
        if (this.length() == 2) {
            return new EConstant(Builtins.TUPLE_CONSTRUCTORS[0]);
        }
        if (this.length() == 3) {
            Symbol sym = (Symbol)this.get(1);
            sym.location = 9223372034707292160L;
            return sym;
        }
        int dim = this.length() / 2;
        Expression[] parameters = new Expression[dim];
        int i = 0;
        while (i < dim) {
            parameters[i] = (Expression)this.get(i * 2 + 1);
            ++i;
        }
        EConstant tupleConstructor = new EConstant(Builtins.TUPLE_CONSTRUCTORS[dim]);
        tupleConstructor.location = Locations.location(Locations.beginOf(((Token)this.get((int)0)).location), Locations.endOf(((Token)this.get((int)(this.length() - 1))).location));
        return new EApply((Expression)tupleConstructor, parameters);
    }

    public static Expression rightSection(EVar op, Expression e) {
        long loc = Locations.combine(op.location, e.location);
        Variable var = new Variable("rightSectionTemp");
        return new ESimpleLambda(loc, var, (Expression)new EApply(loc, (Expression)op, new EVariable(loc, var), e));
    }

    @Override
    protected Object reduceRightSection() {
        Variable var = new Variable("rightSectionTemp");
        long loc = Locations.combine(((Token)this.get((int)0)).location, ((Token)this.get((int)(this.length() - 1))).location);
        EVar symbol = (EVar)this.get(1);
        return new ESimpleLambda(var, new EApply(loc, (Expression)symbol, new EVariable(loc, var), (Expression)this.get(2)));
    }

    @Override
    protected Object reduceLeftSection() {
        return new EApply((Expression)((EVar)this.get(2)), (Expression)this.get(1));
    }

    @Override
    protected Object reduceListLiteral() {
        if (this.length() == 2) {
            return new EListLiteral(Expression.EMPTY_ARRAY);
        }
        int dim = this.length() / 2;
        Expression[] components = new Expression[dim];
        int i = 0;
        while (i < dim) {
            components[i] = (Expression)this.get(i * 2 + 1);
            ++i;
        }
        return new EListLiteral(components);
    }

    @Override
    protected Object reduceRange() {
        return new ERange((Expression)this.get(1), (Expression)this.get(3));
    }

    @Override
    protected Object reduceListComprehension() {
        ListQualifier qualifier = (ListQualifier)this.get(3);
        int i = 5;
        while (i < this.length()) {
            ListQualifier right = (ListQualifier)this.get(i);
            if (right instanceof ListThen) {
                ((ListThen)right).setLeft(qualifier);
                qualifier = right;
            } else {
                qualifier = new ListSeq(qualifier, right);
            }
            i += 2;
        }
        return new EListComprehension((Expression)this.get(1), qualifier);
    }

    @Override
    protected Object reduceAs() {
        Token id = (Token)this.get(0);
        return new EAsPattern(new EVar(id.location, id.text), (Expression)this.get(2));
    }

    @Override
    protected Object reduceGuardedExpEq() {
        Expression[] guards = new Expression[this.length() / 2 - 1];
        int i = 0;
        while (i < guards.length) {
            guards[i] = (Expression)this.get(i * 2 + 1);
            ++i;
        }
        return new GuardedExpression(guards, (Expression)this.get(this.length() - 1));
    }

    @Override
    protected Object reduceLambda() {
        Expression[] patterns = new Expression[this.length() - 3];
        int i = 0;
        while (i < patterns.length) {
            patterns[i] = (Expression)this.get(i + 1);
            ++i;
        }
        Case case_ = new Case(patterns, (Expression)this.get(this.length() - 1));
        case_.setLhs(Locations.combine(patterns[0].location, patterns[patterns.length - 1].location));
        return new ELambda(case_);
    }

    @Override
    protected Object reduceLambdaMatch() {
        Case[] cases = new Case[this.length() / 2 - 1];
        int i = 0;
        while (i < cases.length) {
            cases[i] = (Case)this.get(i * 2 + 2);
            ++i;
        }
        return new ELambda(cases);
    }

    @Override
    protected Object reduceLet() {
        EBlock block = (EBlock)this.get(1);
        Expression expression = (Expression)this.get(3);
        block.addStatement(new GuardStatement(expression));
        Token letToken = (Token)this.get(0);
        block.location = Locations.location(Locations.beginOf(letToken.location), Locations.endOf(expression.location));
        return block;
    }

    @Override
    protected Object reduceIf() {
        return new EIf((Expression)this.get(1), (Expression)this.get(3), this.length() == 6 ? (Expression)this.get(5) : null);
    }

    @Override
    protected Object reduceMatch() {
        Case[] cases = new Case[this.length() / 2 - 2];
        int i = 0;
        while (i < cases.length) {
            cases[i] = (Case)this.get(i * 2 + 4);
            ++i;
        }
        return new EMatch((Expression)this.get(1), cases);
    }

    @Override
    protected Object reduceDo() {
        EBlock block = (EBlock)this.get(1);
        Token doToken = (Token)this.get(0);
        switch (doToken.text) {
            case "mdo": {
                block.setBlockType(BlockType.Monad);
                break;
            }
            case "edo": {
                block.setBlockType(BlockType.MonadE);
            }
        }
        block.location = Locations.location(Locations.beginOf(doToken.location), Locations.endOf(block.location));
        return block;
    }

    @Override
    protected Object reduceSelect() {
        return new ESelect(((Token)this.get((int)0)).id, (Expression)this.get(1), new QConjunction((Query[])this.get(3)));
    }

    @Override
    protected Object reduceEnforce() {
        return new EEnforce(new QConjunction((Query[])this.get(1)));
    }

    @Override
    protected Object reduceApply() {
        if (this.length() == 1) {
            return this.get(0);
        }
        Expression[] parameters = new Expression[this.length() - 1];
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = (Expression)this.get(i + 1);
            ++i;
        }
        return new EApply((Expression)this.get(0), parameters);
    }

    @Override
    protected Object reduceSymbol() {
        return new EVar(((Token)this.get((int)0)).text);
    }

    @Override
    protected Object reduceEscapedId() {
        return new EVar(((Token)this.get((int)0)).text);
    }

    @Override
    protected Object reduceMinus() {
        return new EVar(((Token)this.get((int)0)).text);
    }

    @Override
    protected Object reduceLess() {
        return new EVar(((Token)this.get((int)0)).text);
    }

    @Override
    protected Object reduceGreater() {
        return new EVar(((Token)this.get((int)0)).text);
    }

    @Override
    protected Object reduceDot() {
        return new EVar(((Token)this.get((int)0)).text);
    }

    @Override
    protected Object reduceCase() {
        return new Case((Expression)this.get(0), (Expression)this.get(1));
    }

    @Override
    protected Object reduceGuardQualifier() {
        return new ListGuard((Expression)this.get(0));
    }

    @Override
    protected Object reduceLetQualifier() {
        return new ListAssignment((Expression)this.get(0), (Expression)this.get(2));
    }

    @Override
    protected Object reduceBindQualifier() {
        return new ListGenerator((Expression)this.get(0), (Expression)this.get(2));
    }

    @Override
    protected Object reduceThenQualifier() {
        return new ListThen((Expression)this.get(1), this.length() == 4 ? (Expression)this.get(3) : null);
    }

    @Override
    protected Object reduceGuardStatement() {
        return new GuardStatement((Expression)this.get(0));
    }

    @Override
    protected Object reduceLetStatement() {
        return new LetStatement((Expression)this.get(0), (Expression)this.get(1));
    }

    @Override
    protected Object reduceBindStatement() {
        return new BindStatement((Expression)this.get(0), (Expression)this.get(2));
    }

    @Override
    protected Object reduceSimpleCaseRhs() {
        return this.get(1);
    }

    @Override
    protected Object reduceGuardedCaseRhs() {
        GuardedExpression[] expressions = new GuardedExpression[this.length()];
        int i = 0;
        while (i < expressions.length) {
            expressions[i] = (GuardedExpression)this.get(i);
            ++i;
        }
        return new GuardedExpressionGroup(expressions);
    }

    @Override
    protected Object reduceGuardedExpArrow() {
        Expression[] guards = new Expression[this.length() / 2 - 1];
        int i = 0;
        while (i < guards.length) {
            guards[i] = (Expression)this.get(i * 2 + 1);
            ++i;
        }
        return new GuardedExpression(guards, (Expression)this.get(this.length() - 1));
    }

    @Override
    protected Object reduceEffect() {
        ArrayList<TypeAst> effects = new ArrayList<TypeAst>(this.length() / 2 - 1);
        int i = 1;
        while (i < this.length() - 1) {
            Token token = (Token)this.get(i);
            TVarAst ast = new TVarAst(token.text);
            ast.location = token.location;
            effects.add(ast);
            i += 2;
        }
        return new TEffectAst(effects, (TypeAst)this.get(this.length() - 1));
    }

    @Override
    protected Object reduceJustEtype() {
        return this.get(0);
    }

    @Override
    protected Object reduceForAll() {
        String[] vars = new String[this.length() - 3];
        int i = 0;
        while (i < vars.length) {
            vars[i] = ((Token)this.get((int)(i + 1))).text;
            ++i;
        }
        return new TForAllAst(vars, (TypeAst)this.get(this.length() - 1));
    }

    @Override
    protected Object reduceApplyType() {
        TypeAst[] parameters = new TypeAst[this.length() - 1];
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = (TypeAst)this.get(i + 1);
            ++i;
        }
        return new TApplyAst((TypeAst)this.get(0), parameters);
    }

    @Override
    protected void postReduce(Object reduced) {
        Object last;
        if (!(reduced instanceof Symbol)) {
            return;
        }
        Symbol sym = (Symbol)reduced;
        if (sym.location != 9223372034707292160L || this.length() == 0) {
            return;
        }
        Object first = this.get(0);
        if (!(first instanceof Symbol)) {
            Object[] ll;
            if (first instanceof List) {
                ll = (Object[])first;
                first = ll.get(0);
            } else {
                ll = (Object[])first;
                first = ll.length > 0 ? ll[0] : this.get(1);
            }
        }
        if (!((last = this.get(this.length() - 1)) instanceof Symbol)) {
            if (last instanceof List) {
                List ll = (List)last;
                last = ll.get(ll.size() - 1);
            } else {
                Object[] ll = (Object[])last;
                last = ll.length > 0 ? ll[ll.length - 1] : this.get(this.length() - 2);
            }
        }
        sym.location = ((Symbol)first).location & 0xFFFFFFFF00000000L | ((Symbol)last).location & 0xFFFFFFFFL;
    }

    @Override
    protected RuntimeException syntaxError(Token token, String description) {
        throw new SCLSyntaxErrorException(token.location, description);
    }

    @Override
    protected Object reduceIdAccessor() {
        return new IdAccessor('.', ((Token)this.get((int)0)).text);
    }

    @Override
    protected Object reduceStringAccessor() {
        return new StringAccessor('.', ((Token)this.get((int)1)).text);
    }

    @Override
    protected Object reduceExpAccessor() {
        return new ExpressionAccessor('.', (Expression)this.get(1));
    }

    @Override
    protected Object reduceFieldAccess() {
        if (this.length() == 1) {
            return this.get(0);
        }
        Expression result = (Expression)this.get(0);
        int i = 2;
        while (i < this.length()) {
            FieldAccessor accessor = (FieldAccessor)this.get(i);
            accessor.accessSeparator = ((Token)this.get((int)(i - 1))).text.charAt(0);
            result = new EFieldAccess(result, accessor);
            i += 2;
        }
        return result;
    }

    @Override
    protected Object reduceQueryBlock() {
        if (this.length() == 2) {
            return Query.EMPTY_ARRAY;
        }
        Query[] queries = new Query[this.length() / 2];
        int i = 0;
        while (i < queries.length) {
            queries[i] = (Query)this.get(2 * i + 1);
            ++i;
        }
        return queries;
    }

    @Override
    protected Object reduceGuardQuery() {
        return new QPreGuard((Expression)this.get(0));
    }

    @Override
    protected Object reduceEqualsQuery() {
        return new QPreEquals((Expression)this.get(0), (Expression)this.get(2));
    }

    @Override
    protected Object reduceBindQuery() {
        return new QPreBinds((Expression)this.get(0), (Expression)this.get(2));
    }

    @Override
    protected Object reduceCompositeQuery() {
        Query[] queries = (Query[])this.get(1);
        switch (((Token)this.get((int)0)).text.charAt(1)) {
            case '&': {
                return new QConjunction(queries);
            }
            case '|': {
                return new QDisjunction(queries);
            }
            case '!': {
                return new QNegation(new QConjunction(queries));
            }
            case '?': {
                return new QAlternative(queries);
            }
        }
        throw new InternalCompilerError();
    }

    @Override
    protected Object reduceRuleStatement() {
        return new RuleStatement((Expression)this.get(0), new QConjunction((Query[])this.get(2)));
    }

    @Override
    protected Object reduceHashedId() {
        return new EVar("#" + ((Token)this.get((int)1)).text);
    }

    @Override
    protected Object reduceStringLiteral() {
        int expCount = this.length() / 3;
        if (expCount == 0) {
            return new ELiteral(new StringConstant(((Token)this.get((int)1)).text));
        }
        String[] strings = new String[expCount + 1];
        Expression[] expressions = new Expression[expCount];
        int i = 0;
        while (i < expCount) {
            strings[i] = ((Token)this.get((int)(i * 3 + 1))).text;
            expressions[i] = (Expression)this.get(i * 3 + 2);
            ++i;
        }
        strings[expCount] = ((Token)this.get((int)(expCount * 3 + 1))).text;
        return new EStringLiteral(strings, expressions);
    }

    @Override
    protected Object reduceOneCommand() {
        return null;
    }

    @Override
    protected Object reduceManyCommands() {
        return null;
    }

    @Override
    protected Object reduceStatementCommand() {
        return null;
    }

    @Override
    protected Object reduceImportCommand() {
        return null;
    }

    @Override
    protected Object reduceImportValueItem() {
        return new EVar(((Token)this.get((int)0)).text);
    }

    @Override
    protected Object reduceImportHiding() {
        EVar[] values = new EVar[(this.length() - 2) / 2];
        int i = 0;
        while (i < values.length) {
            values[i] = (EVar)this.get(i * 2 + 2);
            ++i;
        }
        return new ImportDeclaration.ImportSpec(true, values);
    }

    @Override
    protected Object reduceImportShowing() {
        EVar[] values = new EVar[(this.length() - 1) / 2];
        int i = 0;
        while (i < values.length) {
            values[i] = (EVar)this.get(i * 2 + 1);
            ++i;
        }
        return new ImportDeclaration.ImportSpec(false, values);
    }

    @Override
    protected Object reduceRuleDeclarations() {
        ArrayList<Object> declarations = new ArrayList<Object>(this.length() / 2);
        int i = 1;
        while (i < this.length()) {
            declarations.add(this.get(i));
            i += 2;
        }
        return declarations;
    }

    @Override
    protected Object reduceRuleDefinition() {
        String[] extendsNames = EMPTY_STRING_ARRAY;
        if (this.length() >= 6) {
            int extendsCount = (this.length() - 4) / 2;
            extendsNames = new String[extendsCount];
            int i = 0;
            while (i < extendsCount) {
                extendsNames[i] = ((Token)this.get((int)(3 + i * 2))).text;
                ++i;
            }
        }
        DRuleAst rule = new DRuleAst(((Token)this.get((int)0)).id == 25, ((Token)this.get((int)1)).text, extendsNames);
        ArrayList ruleDeclarations = (ArrayList)this.get(this.length() - 1);
        ArrayList<Query> section = null;
        for (Object decl : ruleDeclarations) {
            if (decl instanceof DAnnotationAst) {
                DAnnotationAst annotation = (DAnnotationAst)decl;
                section = rule.getSection(annotation.id.text.substring(1));
                continue;
            }
            if (decl instanceof Query) {
                if (section == null) {
                    section = rule.getSection("when");
                }
                section.add((Query)decl);
                continue;
            }
            throw new InternalCompilerError();
        }
        return rule;
    }

    @Override
    protected Object reduceQueryRuleDeclaration() {
        return this.get(0);
    }

    @Override
    protected Object reduceMappingRelationDefinition() {
        TypeAst[] types = new TypeAst[this.length() - 2];
        int i = 0;
        while (i < types.length) {
            types[i] = (TypeAst)this.get(i + 2);
            ++i;
        }
        return new DMappingRelationAst(((Token)this.get((int)1)).text, types);
    }

    @Override
    protected Object reduceTransformation() {
        return new ETransformation(((Token)this.get((int)1)).text, new QConjunction((Query[])this.get(3)));
    }

    @Override
    protected Object reduceRelationDefinition() {
        return new DRelationAst((Expression)this.get(0), ((ArrayList)this.get(2)).toArray());
    }

    @Override
    protected Object reduceRecord() {
        FieldAssignment[] fields = new FieldAssignment[this.length() / 2 - 1];
        int i = 0;
        while (i < fields.length) {
            fields[i] = (FieldAssignment)this.get(2 + i * 2);
            ++i;
        }
        return new ERecord(new EVar((Token)this.get(0)), fields);
    }

    @Override
    protected Object reduceField() {
        return new FieldAssignment(((Token)this.get((int)0)).text, (Expression)this.get(2));
    }

    @Override
    protected Object reduceFieldShorthand() {
        return new FieldAssignment(((Token)this.get((int)0)).text, null);
    }

    @Override
    protected Object reduceRecordConstructor() {
        int idPos = 0;
        while (idPos < this.length()) {
            if (((Token)this.get((int)idPos)).id == 7) break;
            idPos += 2;
        }
        DAnnotationAst[] annotations = idPos == 0 ? DAnnotationAst.EMPTY_ARRAY : new DAnnotationAst[idPos / 2];
        int i = 0;
        while (i < idPos / 2) {
            annotations[i] = new DAnnotationAst((Token)this.get(i * 2), Arrays.asList((Expression)this.get(i * 2 + 1)));
            ++i;
        }
        TypeAst[] parameters = new TypeAst[(this.length() - idPos - 1) / 2];
        String[] fieldNames = new String[parameters.length];
        int i2 = 0;
        while (i2 < parameters.length) {
            FieldDescription fieldDesc = (FieldDescription)this.get(idPos + (i2 + 1) * 2);
            parameters[i2] = fieldDesc.type;
            fieldNames[i2] = fieldDesc.name;
            ++i2;
        }
        return new ConstructorAst(annotations, (Token)this.get(idPos), parameters, fieldNames);
    }

    @Override
    protected Object reduceFieldDescription() {
        return new FieldDescription(((Token)this.get((int)0)).text, (TypeAst)this.get(2));
    }

    @Override
    protected Object reduceEq() {
        return (Expression)this.get(2);
    }

    @Override
    protected Object reduceEquationBlock() {
        if (this.length() == 0) {
            return new EEquations(Equation.EMPTY_ARRAY);
        }
        Equation[] equations = new Equation[this.length() / 2 + 1];
        int i = 0;
        while (i < equations.length) {
            equations[i] = (Equation)this.get(2 * i);
            ++i;
        }
        return new EEquations(equations);
    }

    @Override
    protected Object reduceGuardEquation() {
        return new EqGuard((Expression)this.get(0));
    }

    @Override
    protected Object reduceBasicEquation() {
        return new EqBasic((Expression)this.get(0), (Expression)this.get(2));
    }

    @Override
    protected Object reduceViewPattern() {
        return new EViewPattern((Expression)this.get(1), (Expression)this.get(3));
    }

    @Override
    protected Object reduceConstraintStatement() {
        ConstructorAst constructor = (ConstructorAst)this.get(1);
        return new ConstraintStatement(constructor.name, constructor.parameters, constructor.fieldNames, constructor.annotations);
    }

    @Override
    protected Object reduceDummy() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object reduceRulesetDefinition() {
        Token name = (Token)this.get(1);
        EBlock block = (EBlock)this.get(3);
        return new DRulesetAst(name.text, block);
    }

    @Override
    protected Object reduceLocalInclude() {
        Token name = (Token)this.get(1);
        Expression value = (Expression)this.get(2);
        return new IncludeStatement(name, value);
    }

    @Override
    protected Object reduceCHRSelect() {
        return new EPreCHRSelect((CHRAstQuery)this.get(3), (Expression)this.get(1));
    }

    @Override
    protected Object reduceCHRAtom() {
        return CHRAstAtom.atom((Expression)this.get(0));
    }

    @Override
    protected Object reduceCHREquals() {
        return new CHRAstEquals((Expression)this.get(0), (Expression)this.get(2));
    }

    @Override
    protected Object reduceCHRBinds() {
        return new CHRAstBinds((Expression)this.get(0), (Expression)this.get(2));
    }

    @Override
    protected Object reduceCHRConjunction() {
        CHRAstQuery[] conjuncts = new CHRAstQuery[(this.length() + 1) / 2];
        int i = 0;
        while (i < conjuncts.length) {
            conjuncts[i] = (CHRAstQuery)this.get(i * 2);
            ++i;
        }
        return CHRAstConjunction.conjunction(conjuncts);
    }

    @Override
    protected Object reduceVerboseCHRConjunction() {
        CHRAstQuery[] conjuncts = new CHRAstQuery[(this.length() - 1) / 2];
        int i = 0;
        while (i < conjuncts.length) {
            conjuncts[i] = (CHRAstQuery)this.get(i * 2 + 1);
            ++i;
        }
        return CHRAstConjunction.conjunction(conjuncts);
    }

    @Override
    protected Object reduceVerboseCHRStatement() {
        return new CHRStatement((CHRAstQuery)this.get(1), (CHRAstQuery)this.get(3));
    }

    @Override
    protected Object reduceCHRStatement() {
        return new CHRStatement((CHRAstQuery)this.get(0), (CHRAstQuery)this.get(2));
    }

    @Override
    protected Object reduceWildcard() {
        return new FieldAssignment("..", null);
    }
}

