/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.matching;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.EAsPattern;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EExternalConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.EViewPattern;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.GuardedExpressionGroup;
import org.simantics.scl.compiler.elaboration.java.DynamicConstructor;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeConstructor;
import org.simantics.scl.compiler.internal.codegen.continuations.Branch;
import org.simantics.scl.compiler.internal.codegen.continuations.ICont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.elaboration.matching.Row;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.util.Typed;

public class PatternMatchingCompiler {
    public static IVal[] replace(IVal[] vals, int columnToReplace, IVal ... substitution) {
        IVal[] newVals = new IVal[vals.length - 1 + substitution.length];
        int j = 0;
        int i = 0;
        while (i < columnToReplace) {
            newVals[j++] = vals[i];
            ++i;
        }
        i = 0;
        while (i < substitution.length) {
            newVals[j++] = substitution[i];
            ++i;
        }
        i = columnToReplace + 1;
        while (i < vals.length) {
            newVals[j++] = vals[i];
            ++i;
        }
        return newVals;
    }

    private static void splitByConstructors(CodeWriter w, CompilationContext context, IVal[] scrutinee, ICont success, ICont failure, List<Row> rows, int columnId) {
        THashMap matrixMap = new THashMap();
        ArrayList<Branch> branches = new ArrayList<Branch>();
        ArrayList<ExpressionMatrix> matrices = new ArrayList<ExpressionMatrix>();
        int i = 0;
        while (i < rows.size()) {
            CodeWriter newW;
            ExpressionMatrix matrix;
            Typed constructor;
            Expression applyConstructor;
            Row row = rows.get(i);
            Expression pattern = row.patterns[columnId];
            while (true) {
                if (pattern instanceof EApplyType) {
                    pattern = ((EApplyType)pattern).getExpression();
                } else {
                    if (!(pattern instanceof EAsPattern)) break;
                    EAsPattern asPattern = (EAsPattern)pattern;
                    pattern = asPattern.getPattern();
                    asPattern.getVariable().setVal(scrutinee[columnId]);
                }
                row.patterns[columnId] = pattern;
            }
            if (pattern instanceof EVariable) break;
            if (pattern instanceof EApply) {
                CodeWriter newW2;
                ExpressionMatrix matrix2;
                Typed constructor2;
                applyConstructor = (EApply)pattern;
                Expression constructor_ = ((EApply)applyConstructor).getFunction();
                while (constructor_ instanceof EApplyType) {
                    constructor_ = ((EApplyType)constructor_).getExpression();
                }
                Typed[] parameters = ((EApply)applyConstructor).getParameters();
                if (constructor_ instanceof EConstant) {
                    constructor2 = ((EConstant)constructor_).getValue();
                    ExpressionMatrix expressionMatrix = matrix2 = ((SCLValue)constructor2).getValue() == DynamicConstructor.INSTANCE ? null : (ExpressionMatrix)matrixMap.get((Object)((SCLValue)constructor2).getName());
                    if (matrix2 == null) {
                        newW2 = w.createBlock(Types.getTypes(parameters));
                        branches.add(new Branch((Constant)((SCLValue)constructor2).getValue(), newW2.getContinuation()));
                        matrix2 = new ExpressionMatrix(newW2, PatternMatchingCompiler.replace(scrutinee, columnId, newW2.getParameters()));
                        matrices.add(matrix2);
                        matrixMap.put((Object)((SCLValue)constructor2).getName(), (Object)matrix2);
                    }
                    matrix2.rows.add(row.replace(columnId, (Expression[])parameters));
                } else if (constructor_ instanceof ELiteral) {
                    constructor2 = ((ELiteral)constructor_).getValue();
                    matrix2 = (ExpressionMatrix)matrixMap.get((Object)constructor2);
                    if (matrix2 == null) {
                        newW2 = w.createBlock(Types.getTypes(parameters));
                        branches.add(new Branch((Constant)constructor2, newW2.getContinuation()));
                        matrix2 = new ExpressionMatrix(newW2, PatternMatchingCompiler.replace(scrutinee, columnId, newW2.getParameters()));
                        matrices.add(matrix2);
                        matrixMap.put((Object)constructor2, (Object)matrix2);
                    }
                    matrix2.rows.add(row.replace(columnId, (Expression[])parameters));
                }
            } else if (pattern instanceof EConstant) {
                applyConstructor = (EConstant)pattern;
                constructor = ((EConstant)applyConstructor).getValue();
                matrix = (ExpressionMatrix)matrixMap.get((Object)((SCLValue)constructor).getName());
                if (matrix == null) {
                    newW = w.createBlock();
                    branches.add(new Branch((Constant)((SCLValue)constructor).getValue(), newW.getContinuation()));
                    matrix = new ExpressionMatrix(newW, PatternMatchingCompiler.replace(scrutinee, columnId, newW.getParameters()));
                    matrices.add(matrix);
                    matrixMap.put((Object)((SCLValue)constructor).getName(), (Object)matrix);
                }
                matrix.rows.add(row.replace(columnId, Expression.EMPTY_ARRAY));
            } else if (pattern instanceof ELiteral) {
                ELiteral literal = (ELiteral)pattern;
                constructor = literal.getValue();
                matrix = (ExpressionMatrix)matrixMap.get((Object)constructor);
                if (matrix == null) {
                    newW = w.createBlock();
                    branches.add(new Branch((Constant)constructor, newW.getContinuation()));
                    matrix = new ExpressionMatrix(newW, PatternMatchingCompiler.replace(scrutinee, columnId, newW.getParameters()));
                    matrices.add(matrix);
                    matrixMap.put((Object)constructor, (Object)matrix);
                }
                matrix.rows.add(row.replace(columnId, Expression.EMPTY_ARRAY));
            } else if (pattern instanceof EExternalConstant) {
                EExternalConstant constant = (EExternalConstant)pattern;
                constructor = w.getModuleWriter().getExternalConstant(constant.getValue(), constant.getType());
                matrix = (ExpressionMatrix)matrixMap.get((Object)constructor);
                if (matrix == null) {
                    newW = w.createBlock();
                    branches.add(new Branch((Constant)constructor, newW.getContinuation()));
                    matrix = new ExpressionMatrix(newW, PatternMatchingCompiler.replace(scrutinee, columnId, newW.getParameters()));
                    matrices.add(matrix);
                    matrixMap.put((Object)constructor, (Object)matrix);
                }
                matrix.rows.add(row.replace(columnId, Expression.EMPTY_ARRAY));
            } else {
                throw new InternalCompilerError("Cannot handle an instance of " + pattern.getClass().getSimpleName() + " in a pattern.");
            }
            ++i;
        }
        if (i < rows.size()) {
            CodeWriter newW = w.createBlock();
            ICont cont = newW.getContinuation();
            branches.add(new Branch(null, cont));
            PatternMatchingCompiler.split(newW, context, scrutinee, success, failure, rows.subList(i, rows.size()));
            failure = cont;
        } else {
            int maxBranchCount;
            TCon con;
            try {
                con = Types.getConstructor(scrutinee[columnId].getType());
            }
            catch (MatchException matchException) {
                throw new InternalCompilerError();
            }
            TypeConstructor cons = (TypeConstructor)context.environment.getTypeDescriptor(con);
            int n = maxBranchCount = cons.isOpen ? Integer.MAX_VALUE : cons.constructors.length;
            if (branches.size() < maxBranchCount) {
                branches.add(new Branch(null, failure));
            }
        }
        for (ExpressionMatrix mx : matrices) {
            PatternMatchingCompiler.split(mx.w, context, mx.scrutinee, success, failure, mx.rows);
        }
        w.switch_(scrutinee[columnId], branches.toArray(new Branch[branches.size()]));
    }

    private static void splitByViewPattern(CodeWriter w, CompilationContext context, IVal[] scrutinee, ICont success, ICont failure, List<Row> rows, int viewPatternColumn) {
        Row firstRow = rows.get(0);
        EViewPattern firstViewPattern = (EViewPattern)firstRow.patterns[viewPatternColumn];
        firstRow.patterns[viewPatternColumn] = firstViewPattern.pattern;
        int i = 1;
        while (i < rows.size()) {
            Row row = rows.get(i);
            Expression pattern = row.patterns[viewPatternColumn];
            while (true) {
                if (pattern instanceof EApplyType) {
                    pattern = ((EApplyType)pattern).getExpression();
                } else {
                    if (!(pattern instanceof EAsPattern)) break;
                    EAsPattern asPattern = (EAsPattern)pattern;
                    pattern = asPattern.getPattern();
                    asPattern.getVariable().setVal(scrutinee[viewPatternColumn]);
                }
                row.patterns[viewPatternColumn] = pattern;
            }
            if (!(pattern instanceof EViewPattern)) break;
            EViewPattern otherViewPattern = (EViewPattern)pattern;
            if (!otherViewPattern.expression.equalsExpression(firstViewPattern.expression)) break;
            row.patterns[viewPatternColumn] = otherViewPattern.pattern;
            ++i;
        }
        IVal[] newScrutinee = Arrays.copyOf(scrutinee, scrutinee.length);
        newScrutinee[viewPatternColumn] = w.apply(firstViewPattern.location, firstViewPattern.expression.toVal(context, w), scrutinee[viewPatternColumn]);
        if (i == rows.size()) {
            PatternMatchingCompiler.split(w, context, newScrutinee, success, failure, rows);
        } else {
            CodeWriter cont = w.createBlock();
            PatternMatchingCompiler.split(w, context, newScrutinee, success, cont.getContinuation(), rows.subList(0, i));
            PatternMatchingCompiler.split(cont, context, scrutinee, success, failure, rows.subList(i, rows.size()));
        }
    }

    public static void split(CodeWriter w, CompilationContext context, IVal[] scrutinee, ICont success, ICont failure, List<Row> rows) {
        Row firstRow = rows.get(0);
        Expression[] patterns = firstRow.patterns;
        if (scrutinee.length != patterns.length) {
            throw new InternalCompilerError("Scrutinee and patterns have a different length");
        }
        int viewPatternColumn = -1;
        int i = 0;
        while (i < patterns.length) {
            Expression pattern = patterns[i];
            if (pattern instanceof EViewPattern) {
                if (viewPatternColumn == -1) {
                    viewPatternColumn = i;
                }
            } else if (!(pattern instanceof EVariable)) {
                PatternMatchingCompiler.splitByConstructors(w, context, scrutinee, success, failure, rows, i);
                return;
            }
            ++i;
        }
        if (viewPatternColumn >= 0) {
            PatternMatchingCompiler.splitByViewPattern(w, context, scrutinee, success, failure, rows, viewPatternColumn);
            return;
        }
        i = 0;
        while (i < patterns.length) {
            ((EVariable)patterns[i]).getVariable().setVal(scrutinee[i]);
            ++i;
        }
        if (firstRow.value instanceof GuardedExpressionGroup) {
            GuardedExpressionGroup group = (GuardedExpressionGroup)firstRow.value;
            if (rows.size() == 1) {
                group.compile(context, w, success, failure);
            } else {
                CodeWriter newW = w.createBlock();
                ICont cont = newW.getContinuation();
                group.compile(context, w, success, cont);
                PatternMatchingCompiler.split(newW, context, scrutinee, success, failure, rows.subList(1, rows.size()));
            }
        } else {
            w.jump(success, firstRow.value.toVal(context, w));
        }
    }

    private static class ExpressionMatrix {
        final CodeWriter w;
        final IVal[] scrutinee;
        final List<Row> rows = new ArrayList<Row>();

        public ExpressionMatrix(CodeWriter w, IVal[] scrutinee) {
            this.w = w;
            this.scrutinee = scrutinee;
        }
    }
}

