/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.constraints;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.ClassConstant;
import org.simantics.scl.compiler.constants.StringConstant;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.elaboration.constraints.ReduceSerializable;
import org.simantics.scl.compiler.internal.elaboration.constraints.Reduction;
import org.simantics.scl.compiler.internal.elaboration.constraints.Superconstraint;
import org.simantics.scl.compiler.types.TApply;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TFun;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TUnion;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class ConstraintEnvironment {
    Environment environment;

    public ConstraintEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Superconstraint[] getSuperconstraints(TPred constraint) {
        TypeClass tc = this.environment.getTypeClass(constraint.typeClass);
        if (tc == null) {
            throw new InternalCompilerError("Didn't find constraint " + constraint + ". Maybe Prelude is not loaded?");
        }
        if (tc.context.length == 0) {
            return Superconstraint.EMPTY_ARRAY;
        }
        Superconstraint[] result = new Superconstraint[tc.context.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new Superconstraint((TPred)tc.context[i].replace(tc.parameters, constraint.parameters), tc.superGenerators[i]);
            ++i;
        }
        return result;
    }

    public Reduction reduce(TPred constraint) {
        Type parameter;
        if (constraint.typeClass == Types.VEC_COMP && (parameter = Types.canonical(constraint.parameters[0])).isGround()) {
            return new Reduction(new ELiteral(new ClassConstant(Types.pred(Types.VEC_COMP, parameter), parameter)), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
        }
        if (constraint.typeClass == Types.SERIALIZABLE) {
            return ReduceSerializable.reduceSerializable(constraint.parameters[0]);
        }
        if (constraint.typeClass == Types.TYPEABLE) {
            parameter = Types.canonical(constraint.parameters[0]);
            if (parameter instanceof TCon) {
                TCon con = (TCon)parameter;
                return new Reduction(new EApply(9223372034707292160L, (Expression)new EConstant(Builtins.INSTANCE.getValue("TCon")), new ELiteral(new StringConstant(con.module)), new ELiteral(new StringConstant(con.name))), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
            }
            if (parameter instanceof TApply) {
                TApply apply = (TApply)parameter;
                return new Reduction(new EConstant(Builtins.INSTANCE.getValue("TApply")), Type.EMPTY_ARRAY, new TPred[]{Types.pred(Types.TYPEABLE, apply.function), Types.pred(Types.TYPEABLE, apply.parameter)});
            }
            if (parameter instanceof TFun) {
                TFun fun = (TFun)parameter;
                return new Reduction(new EConstant(Builtins.INSTANCE.getValue("TFun")), Type.EMPTY_ARRAY, new TPred[]{Types.pred(Types.TYPEABLE, fun.domain), Types.pred(Types.TYPEABLE, fun.effect), Types.pred(Types.TYPEABLE, fun.range)});
            }
            if (parameter instanceof TUnion) {
                TUnion union = (TUnion)parameter;
                if (union.effects.length == 0) {
                    return new Reduction(new EConstant(Builtins.INSTANCE.getValue("TPure")), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
                }
                if (union.effects.length == 2) {
                    return new Reduction(new EConstant(Builtins.INSTANCE.getValue("TUnion2")), Type.EMPTY_ARRAY, new TPred[]{Types.pred(Types.TYPEABLE, union.effects[0]), Types.pred(Types.TYPEABLE, union.effects[1])});
                }
                if (union.effects.length == 3) {
                    return new Reduction(new EConstant(Builtins.INSTANCE.getValue("TUnion3")), Type.EMPTY_ARRAY, new TPred[]{Types.pred(Types.TYPEABLE, union.effects[0]), Types.pred(Types.TYPEABLE, union.effects[1]), Types.pred(Types.TYPEABLE, union.effects[2])});
                }
            }
        }
        THashMap substitution = new THashMap();
        ArrayList<Reduction> reductions = new ArrayList<Reduction>(1);
        for (TypeClassInstance inst : this.environment.getInstances(constraint.typeClass)) {
            if (Types.match(inst.instance, constraint, (THashMap<TVar, Type>)substitution)) {
                TPred[] demands = new TPred[inst.context.length];
                int i = 0;
                while (i < demands.length) {
                    demands[i] = (TPred)inst.context[i].replace(substitution);
                    ++i;
                }
                Type[] parameters = new Type[inst.generatorParameters.length];
                int i2 = 0;
                while (i2 < parameters.length) {
                    Type parameter2 = (Type)substitution.get((Object)inst.generatorParameters[i2]);
                    if (parameter2 == null) {
                        parameter2 = inst.generatorParameters[i2];
                    }
                    parameters[i2] = parameter2;
                    ++i2;
                }
                reductions.add(new Reduction(new ELiteral(inst.generator), parameters, demands));
            }
            substitution.clear();
        }
        if (reductions.size() == 1) {
            return (Reduction)reductions.get(0);
        }
        if (reductions.size() > 1) {
            throw new InternalCompilerError("Found more than one matching instances for " + constraint.typeClass + ".");
        }
        return null;
    }
}

