/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.ssa.exits;

import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.continuations.ContRef;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAExit;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.ssa.binders.ValRefBinder;
import org.simantics.scl.compiler.internal.codegen.utils.CopyContext;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.internal.codegen.utils.ValRefVisitor;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;

public class Jump
extends SSAExit
implements ValRefBinder {
    private ContRef target;
    private ValRef[] parameters;

    public Jump(ContRef target, ValRef ... parameters) {
        this.setTarget(target);
        this.setParameters(parameters);
    }

    public ContRef getTarget() {
        return this.target;
    }

    public void setTarget(ContRef target) {
        this.target = target;
        target.setParent(this);
    }

    public ValRef[] getParameters() {
        return this.parameters;
    }

    public void setParameters(ValRef[] parameters) {
        this.parameters = parameters;
        ValRef[] valRefArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ValRef parameter = valRefArray[n2];
            parameter.setParent(this);
            ++n2;
        }
    }

    @Override
    public void generateCode(MethodBuilder mb) {
        mb.jump(this.target, ValRef.getBindings(this.parameters));
    }

    @Override
    public void toString(PrintingContext context) {
        context.append(this.target);
        Object[] objectArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ValRef parameter = objectArray[n2];
            context.append(' ');
            context.append(parameter);
            ++n2;
        }
        context.append('\n');
        objectArray = this.getSuccessors();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object block = objectArray[n2];
            context.addBlock((SSABlock)block);
            ++n2;
        }
    }

    @Override
    public void validate(SSAValidationContext context) {
        context.validate(this.target);
        if (this.target.getParent() != this) {
            throw new InternalCompilerError();
        }
        ValRef[] valRefArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ValRef parameter = valRefArray[n2];
            context.validate(parameter);
            if (parameter.getParent() != this) {
                throw new InternalCompilerError();
            }
            ++n2;
        }
        Cont cont = this.target.getBinding();
        context.assertEquals(cont.getArity(), this.parameters.length);
    }

    @Override
    public void destroy() {
        this.target.remove();
        ValRef[] valRefArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ValRef parameter = valRefArray[n2];
            parameter.remove();
            ++n2;
        }
    }

    @Override
    public SSAExit copy(CopyContext context) {
        return new Jump(context.copy(this.target), context.copy(this.parameters));
    }

    @Override
    public void replace(TVar[] vars, Type[] replacements) {
        ValRef[] valRefArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ValRef parameter = valRefArray[n2];
            parameter.replace(vars, replacements);
            ++n2;
        }
    }

    @Override
    public void collectFreeVariables(SSAFunction function, ArrayList<ValRef> vars) {
        ValRef[] valRefArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ValRef parameter = valRefArray[n2];
            parameter.collectFreeVariables(function, vars);
            ++n2;
        }
    }

    @Override
    public Cont addParametersInFrontOf(ContRef contRef, Val[] newParameters, Val[] oldParameters, Cont proxy) {
        ValRef[] occurences;
        ValRef[] valRefArray = occurences = ValRef.createOccurrences(newParameters);
        int n = occurences.length;
        int n2 = 0;
        while (n2 < n) {
            ValRef ref = valRefArray[n2];
            ref.setParent(this);
            ++n2;
        }
        this.parameters = ValRef.concat(occurences, this.parameters);
        return proxy;
    }

    public void setParameter(int position, ValRef parameter) {
        this.parameters[position] = parameter;
        parameter.setParent(this);
    }

    public ValRef getParameter(int position) {
        return this.parameters[position];
    }

    @Override
    public boolean isJump(Cont cont, Val parameter) {
        return this.target.getBinding() == cont && this.parameters.length == 1 && this.parameters[0].getBinding() == parameter;
    }

    @Override
    public SSABlock[] getSuccessors() {
        Cont cont = this.target.getBinding();
        if (cont instanceof SSABlock) {
            return new SSABlock[]{(SSABlock)cont};
        }
        return SSABlock.EMPTY_ARRAY;
    }

    @Override
    public void forValRefs(ValRefVisitor visitor) {
        ValRef[] valRefArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ValRef parameter = valRefArray[n2];
            visitor.visit(parameter);
            ++n2;
        }
    }

    @Override
    public void cleanup() {
        ValRef[] valRefArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ValRef parameter = valRefArray[n2];
            parameter.remove();
            ++n2;
        }
    }
}

