/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.relations;

import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.relations.AbstractRelation;
import org.simantics.scl.compiler.elaboration.relations.CompositeRelation;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class TransitiveClosureRelation
extends AbstractRelation
implements CompositeRelation {
    SCLRelation baseRelation;

    public TransitiveClosureRelation(SCLRelation baseRelation) {
        this.baseRelation = baseRelation;
    }

    @Override
    public TVar[] getTypeVariables() {
        return this.baseRelation.getTypeVariables();
    }

    @Override
    public Type[] getParameterTypes() {
        return this.baseRelation.getParameterTypes();
    }

    @Override
    public double getSelectivity(int boundVariabes) {
        return this.baseRelation.getSelectivity(boundVariabes) * 5.0;
    }

    @Override
    public int getRequiredVariablesMask() {
        return this.baseRelation.getRequiredVariablesMask();
    }

    @Override
    public void generate(long location, QueryCompilationContext context, Type[] typeParameters, Variable[] parameters, int boundVariables) {
        Variable solved;
        Variable bound;
        if (boundVariables == (1 << parameters.length - 1) - 1) {
            bound = parameters[0];
            solved = parameters[parameters.length - 1];
        } else if (boundVariables == (1 << parameters.length) - 2) {
            bound = parameters[parameters.length - 1];
            solved = parameters[0];
        } else {
            throw new UnsupportedOperationException("boundVariables = " + boundVariables);
        }
        Type type = this.baseRelation.getParameterTypes()[0];
        if (typeParameters.length > 0) {
            type = type.replace(this.getTypeVariables(), typeParameters);
        }
        Expression continuation = context.getContinuation();
        System.out.println("continuation = " + continuation + " :: " + continuation.getType());
        Variable set = new Variable("set", Types.apply((Type)Types.con("MSet", "T"), type));
        Variable f = new Variable("f", Types.functionE(type, (Type)Types.PROC, continuation.getType()));
        Variable innerSolved = new Variable("tcTemp", solved.getType());
        System.out.println("set :: " + set.getType());
        System.out.println("f :: " + f.getType());
        System.out.println("tcTemp :: " + innerSolved.getType());
        QueryCompilationContext newContext = context.createSubcontext(new EApply((Expression)new EVariable(f), (Expression)new EVariable(innerSolved)));
        Variable[] innerParameters = new Variable[parameters.length];
        if (boundVariables == (1 << parameters.length - 1) - 1) {
            innerParameters[0] = solved;
            innerParameters[parameters.length - 1] = innerSolved;
        } else {
            innerParameters[0] = innerSolved;
            innerParameters[parameters.length - 1] = solved;
        }
        int i = 1;
        while (i < parameters.length - 1) {
            innerParameters[i] = parameters[i];
            ++i;
        }
        this.baseRelation.generate(location, newContext, typeParameters, innerParameters, boundVariables);
        continuation = context.disjunction(continuation, newContext.getContinuation());
        continuation = Expressions.if_(Expressions.apply((EnvironmentalContext)context.getCompilationContext(), (Type)Types.PROC, Names.MSet_add, type, Expressions.var(set), Expressions.var(solved)), continuation, context.failure());
        continuation = Expressions.lambda((Type)Types.PROC, solved, continuation);
        continuation = Expressions.letRec(f, continuation, Expressions.apply(Expressions.var(f), Expressions.var(bound)));
        continuation = Expressions.let(set, Expressions.apply((EnvironmentalContext)context.getCompilationContext(), (Type)Types.PROC, Names.MSet_create, type, Expressions.tuple()), continuation);
        context.setContinuation(continuation);
    }

    @Override
    public SCLRelation[] getSubrelations() {
        return new SCLRelation[]{this.baseRelation};
    }

    @Override
    public Type getEnforceEffect() {
        return this.baseRelation.getEnforceEffect();
    }

    @Override
    public Type getQueryEffect() {
        return this.baseRelation.getQueryEffect();
    }
}

