/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Set;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.precedence.Precedence;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.NoRepConstant;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.ELambdaType;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.LhsType;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.PatternMatchingLhs;
import org.simantics.scl.compiler.elaboration.expressions.printing.ExpressionToStringVisitor;
import org.simantics.scl.compiler.elaboration.expressions.visitors.CollectEffectsVisitor;
import org.simantics.scl.compiler.elaboration.expressions.visitors.CollectFreeVariablesVisitor;
import org.simantics.scl.compiler.elaboration.expressions.visitors.CollectRefsVisitor;
import org.simantics.scl.compiler.elaboration.expressions.visitors.CollectVarsVisitor;
import org.simantics.scl.compiler.elaboration.expressions.visitors.ForVariablesUsesVisitor;
import org.simantics.scl.compiler.elaboration.expressions.visitors.StandardExpressionVisitor;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.elaboration.decomposed.DecomposedExpression;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.types.TForAll;
import org.simantics.scl.compiler.types.TFun;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.Typed;

public abstract class Expression
extends Symbol
implements Typed {
    public static final Expression[] EMPTY_ARRAY = new Expression[0];
    private transient Type type;

    public Expression() {
    }

    public Expression(long loc) {
        this.location = loc;
    }

    @Override
    public Type getType() {
        if (this.type == null) {
            try {
                this.updateType();
            }
            catch (MatchException e) {
                throw new InternalCompilerError(this.location, (Throwable)e);
            }
            if (this.type == null) {
                throw new InternalCompilerError(this.location, String.valueOf(this.getClass().getSimpleName()) + ".updateType couldn't compute its type.");
            }
        }
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
    }

    public Expression inferType(TypingContext context) {
        return this.checkBasicType(context, Types.metaVar(Kinds.STAR));
    }

    public Expression checkBasicType(TypingContext context, Type requiredType) {
        return context.subsume(this.inferType(context), requiredType);
    }

    protected Expression applyPUnit(TypingContext context) {
        TFun fun;
        Type type = Types.canonical(this.getType());
        if (type instanceof TFun && (fun = (TFun)type).getCanonicalDomain() == Types.PUNIT) {
            EApply result = new EApply(this.location, this, new ELiteral(NoRepConstant.PUNIT));
            result.effect = fun.getCanonicalEffect();
            context.declareEffect(this.location, result.effect);
            return result;
        }
        return this;
    }

    public Expression checkIgnoredType(TypingContext context) {
        Expression expression = this.inferType(context);
        if (Types.canonical(expression.getType()) != Types.UNIT) {
            expression = new ESimpleLet(this.location, null, expression, new ELiteral(NoRepConstant.PUNIT));
        }
        return expression;
    }

    public final Expression checkType(TypingContext context, Type requiredType) {
        if (!context.isInPattern()) {
            if ((requiredType = Types.canonical(requiredType)) instanceof TForAll) {
                TForAll forAll = (TForAll)requiredType;
                TVar var = forAll.var;
                TVar newVar = Types.var(var.getKind());
                requiredType = Types.canonical(forAll.type).replace(var, newVar);
                return new ELambdaType(new TVar[]{newVar}, this.checkType(context, requiredType));
            }
            if (requiredType instanceof TFun) {
                TFun fun = (TFun)requiredType;
                if (fun.domain instanceof TPred) {
                    ArrayList<Variable> constraints = new ArrayList<Variable>(2);
                    do {
                        constraints.add(new Variable("constraint", fun.domain));
                        requiredType = Types.canonical(fun.range);
                        if (!(requiredType instanceof TFun)) break;
                        fun = (TFun)requiredType;
                    } while (fun.domain instanceof TPred);
                    context.pushConstraintFrame(constraints.toArray(new Variable[constraints.size()]));
                    Expression expression = this.checkType(context, requiredType);
                    context.popConstraintFrame();
                    int i = constraints.size() - 1;
                    while (i >= 0) {
                        expression = new ESimpleLambda((Variable)constraints.get(i), expression);
                        --i;
                    }
                    return expression;
                }
                if (fun.domain == Types.PUNIT) {
                    context.pushEffectUpperBound(this.location, fun.effect);
                    Expression expr = this.checkType(context, fun.range);
                    context.popEffectUpperBound();
                    Variable var = new Variable("punit", Types.PUNIT);
                    return new ESimpleLambda(this.location, var, fun.effect, expr);
                }
            }
        }
        return this.checkBasicType(context, requiredType);
    }

    public final void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        this.accept(new CollectRefsVisitor(allRefs, refs));
    }

    public final void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.accept(new CollectVarsVisitor(allVars, vars));
    }

    public final void forVariableUses(VariableProcedure procedure) {
        this.accept(new ForVariablesUsesVisitor(procedure));
    }

    public Expression decomposeMatching() {
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        ExpressionToStringVisitor visitor = new ExpressionToStringVisitor(b);
        this.accept(visitor);
        return b.toString();
    }

    protected abstract void updateType() throws MatchException;

    public static void assertEquals(long loc, Type a, Type b) throws TypeValidationException {
        if (!Types.equals(a, b)) {
            throw new TypeValidationException(loc);
        }
    }

    public abstract IVal toVal(CompilationContext var1, CodeWriter var2);

    public Expression closure(TVar ... vars) {
        if (vars.length == 0) {
            return this;
        }
        return new ELambdaType(vars, this);
    }

    public Expression simplify(SimplificationContext context) {
        System.out.println("#############################");
        System.out.println(this);
        throw new InternalCompilerError(this.location, String.valueOf(this.getClass().getSimpleName()) + " does not support simplify method.");
    }

    public abstract Expression resolve(TranslationContext var1);

    public EVar getPatternHead() throws NotPatternException {
        throw new NotPatternException(this);
    }

    public LhsType getLhsType() throws NotPatternException {
        throw new NotPatternException(this);
    }

    protected void collectVariableNames(PatternMatchingLhs lhsType) throws NotPatternException {
        throw new NotPatternException(this);
    }

    public void getParameters(TranslationContext translationContext, ArrayList<Expression> parameters) {
        throw new InternalCompilerError(this.location, "Class " + this.getClass().getSimpleName() + " does not support getParameters.");
    }

    public Expression resolveAsPattern(TranslationContext context) {
        context.getErrorLog().log(this.location, "Pattern was expected here.");
        return new EError();
    }

    public Expression checkTypeAsPattern(TypingContext context, Type requiredType) {
        if (context.isInPattern()) {
            throw new InternalCompilerError(this.location, "Already in a pattern.");
        }
        context.setInPattern(true);
        Expression expression = this.checkType(context, requiredType);
        context.setInPattern(false);
        return expression;
    }

    public Set<Variable> getFreeVariables() {
        CollectFreeVariablesVisitor visitor = new CollectFreeVariablesVisitor();
        this.accept(visitor);
        return visitor.getFreeVariables();
    }

    public static Expression[] concat(Expression[] a, Expression[] b) {
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        Expression[] result = new Expression[a.length + b.length];
        int i = 0;
        while (i < a.length) {
            result[i] = a[i];
            ++i;
        }
        i = 0;
        while (i < b.length) {
            result[i + a.length] = b[i];
            ++i;
        }
        return result;
    }

    public Expression replace(ReplaceContext context) {
        throw new InternalCompilerError(this.location, String.valueOf(this.getClass().getSimpleName()) + " does not support replace.");
    }

    public static Expression[] replace(ReplaceContext context, Expression[] expressions) {
        Expression[] result = new Expression[expressions.length];
        int i = 0;
        while (i < expressions.length) {
            result[i] = expressions[i].replace(context);
            ++i;
        }
        return result;
    }

    public Expression copy() {
        return this.replace(new ReplaceContext(null));
    }

    public Expression copy(TypingContext typingContext) {
        return this.replace(new ReplaceContext(typingContext));
    }

    public abstract void setLocationDeep(long var1);

    public Expression replaceInPattern(ReplaceContext context) {
        context.inPattern = true;
        Expression result = this.replace(context);
        context.inPattern = false;
        return result;
    }

    public int getFunctionDefinitionPatternArity() throws NotPatternException {
        throw new NotPatternException(this);
    }

    public IVal lambdaToVal(CompilationContext context, CodeWriter w) {
        DecomposedExpression decomposed = DecomposedExpression.decompose(context.errorLog, this);
        CodeWriter newW = w.createFunction(decomposed.typeParameters, decomposed.effect, decomposed.returnType, decomposed.parameterTypes);
        IVal[] parameters = newW.getParameters();
        Val functionVal = newW.getFunction().getTarget();
        int i = 0;
        while (i < parameters.length) {
            decomposed.parameters[i].setVal(parameters[i]);
            ++i;
        }
        newW.return_(decomposed.body.toVal(context, newW));
        return functionVal;
    }

    public IExpression toIExpression(ExpressionInterpretationContext context) {
        throw new UnsupportedOperationException();
    }

    public static IExpression[] toIExpressions(ExpressionInterpretationContext target, Expression[] expressions) {
        IExpression[] result = new IExpression[expressions.length];
        int i = 0;
        while (i < expressions.length) {
            result[i] = expressions[i].toIExpression(target);
            ++i;
        }
        return result;
    }

    public Expression applyType(Type type) {
        return new EApplyType(this.location, this, type);
    }

    public boolean isEffectful() {
        return true;
    }

    public boolean isFunctionPattern() {
        return false;
    }

    public boolean isConstructorApplication() {
        return false;
    }

    public Type getEffect() {
        CollectEffectsVisitor visitor = new CollectEffectsVisitor();
        this.accept(visitor);
        return visitor.getCombinedEffect();
    }

    public abstract void accept(ExpressionVisitor var1);

    public void collectRelationRefs(final TObjectIntHashMap<SCLRelation> allRefs, final TIntHashSet refs) {
        this.accept(new StandardExpressionVisitor(){

            @Override
            public void visit(QAtom query) {
                int id = allRefs.get((Object)query.relation);
                if (id >= 0) {
                    refs.add(id);
                }
            }
        });
    }

    public boolean isFunctionDefinitionLhs() {
        return false;
    }

    public Precedence getPrecedence() {
        return Precedence.DEFAULT;
    }

    public boolean isPattern(int arity) {
        return false;
    }

    public abstract Expression accept(ExpressionTransformer var1);

    public boolean equalsExpression(Expression expression) {
        return false;
    }

    public int getSyntacticFunctionArity() {
        return 0;
    }

    public static class TypeValidationException
    extends Exception {
        private static final long serialVersionUID = 3181298127162041248L;
        long loc;

        public TypeValidationException(long loc) {
            this.loc = loc;
        }

        public long getLoc() {
            return this.loc;
        }

        public TypeValidationException(long loc, Throwable cause) {
            super(cause);
            this.loc = loc;
        }
    }
}

