/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.QExists;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.compilation.EnforcingContext;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class EEnforce
extends SimplifiableExpression {
    public Query query;

    public EEnforce(Query query) {
        this.query = query;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.tupleConstructor(0));
    }

    @Override
    public Expression inferType(TypingContext context) {
        this.query.checkType(context);
        return this.compile(context);
    }

    public Expression compile(TypingContext context) {
        return this.query.generateEnforce(new EnforcingContext(context));
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        throw new InternalCompilerError();
    }

    @Override
    public Expression resolve(TranslationContext context) {
        context.pushExistentialFrame();
        this.query = this.query.resolve(context);
        Variable[] variables = context.popExistentialFrame();
        if (variables.length > 0) {
            this.query = new QExists(variables, this.query);
        }
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.query.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression replace(ReplaceContext context) {
        return new EEnforce(this.query.replace(context));
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

