/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr.plan;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.BooleanConstant;
import org.simantics.scl.compiler.elaboration.chr.plan.PartnerFact;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanContext;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanOp;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;

public class AccessFactOp
extends PlanOp {
    Expression inputFact;
    CHRConstraint constraint;
    Variable[] variables;
    boolean killAfterMatch;

    public AccessFactOp(long location, Expression inputFact, CHRConstraint constraint, Variable[] variables, boolean killAfterMatch) {
        super(location);
        this.inputFact = inputFact;
        this.constraint = constraint;
        this.variables = variables;
        this.killAfterMatch = killAfterMatch;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("ACCESS  ");
        if (this.killAfterMatch) {
            b.append("- ");
        }
        b.append(this.constraint);
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            b.append(' ').append(variable);
            ++n2;
        }
        b.append(" = ").append(this.inputFact);
    }

    @Override
    public void generateCode(CompilationContext context, PlanContext planContext, CodeWriter w) {
        IVal inputVal = this.inputFact.toVal(context, w);
        int i = 0;
        while (i < this.variables.length) {
            this.variables[i].setVal(this.constraint.accessComponent(this.location, w, inputVal, i));
            ++i;
        }
        IVal activeId = w.apply(this.location, this.constraint.accessId, inputVal);
        CodeWriter end = this.constraint.mayBeRemoved() ? w.createBlock() : null;
        planContext.partnerFacts.add(new PartnerFact(true, activeId, this.constraint, inputVal, this.constraint.mayBeRemoved(), this.killAfterMatch, null, null, end == null ? null : end.getContinuation()));
        planContext.nextOp(w);
        if (end != null) {
            end.return_(BooleanConstant.FALSE);
        }
    }
}

