/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.completions;

import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.compilation.DeclarationClassification;
import org.simantics.scl.compiler.compilation.Elaboration;
import org.simantics.scl.compiler.completions.Completion;
import org.simantics.scl.compiler.completions.CompletionComparator;
import org.simantics.scl.compiler.completions.CompletionRequest;
import org.simantics.scl.compiler.completions.CompletionType;
import org.simantics.scl.compiler.completions.PrefixUtil;
import org.simantics.scl.compiler.completions.parsing.RobustModuleParser;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.EnvironmentFactoryImpl;
import org.simantics.scl.compiler.environment.Namespace;
import org.simantics.scl.compiler.environment.filter.AcceptAllNamespaceFilter;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.internal.parsing.declarations.ConstructorAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DDataAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DDocumentationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DTypeAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DValueTypeAst;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.types.TCon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Completions {
    private static final Logger LOGGER = LoggerFactory.getLogger(Completions.class);

    public static List<Completion> findCompletions(final CompletionRequest request) {
        DeclarationClassification declarations;
        String prefix;
        CompilationContext context;
        ArrayList<Completion> completions;
        AtomicInteger maxNumberOfCompletions;
        block19: {
            maxNumberOfCompletions = new AtomicInteger(request.maxNumberOfCompletions);
            completions = new ArrayList<Completion>();
            String moduleName = request.moduleSource.getModuleName();
            context = new CompilationContext();
            prefix = PrefixUtil.findPrefix(request.sourceText, request.position).toLowerCase();
            declarations = RobustModuleParser.parse(context, request.sourceText);
            if (!prefix.contains(".")) {
                int n;
                int n2;
                Symbol[] symbolArray;
                THashSet valuesAlreadyAdded = new THashSet();
                for (DDataAst dataAst : declarations.dataTypesAst) {
                    if (dataAst.name.toLowerCase().startsWith(prefix)) {
                        completions.add(Completions.createLocalTypeCompletion(request.position, prefix, declarations, moduleName, dataAst.name));
                        if (maxNumberOfCompletions.decrementAndGet() <= 0) break block19;
                    }
                    symbolArray = dataAst.constructors;
                    n2 = dataAst.constructors.length;
                    n = 0;
                    while (n < n2) {
                        ConstructorAst constructor = symbolArray[n];
                        if (constructor.name.text.toLowerCase().startsWith(prefix) && valuesAlreadyAdded.add((Object)constructor.name.text)) {
                            completions.add(Completions.createLocalValueCompletion(request.position, prefix, declarations, moduleName, constructor.name.text, null));
                            if (maxNumberOfCompletions.decrementAndGet() <= 0) break block19;
                        }
                        ++n;
                    }
                }
                for (DTypeAst typeAst : declarations.typeAliasesAst) {
                    if (!typeAst.name.toLowerCase().startsWith(prefix)) continue;
                    completions.add(Completions.createLocalTypeCompletion(request.position, prefix, declarations, moduleName, typeAst.name));
                    if (maxNumberOfCompletions.decrementAndGet() > 0) {
                        continue;
                    }
                    break block19;
                }
                for (DValueTypeAst valueType : declarations.typeAnnotationsAst) {
                    symbolArray = valueType.names;
                    n2 = valueType.names.length;
                    n = 0;
                    while (n < n2) {
                        Symbol var = symbolArray[n];
                        if (((EVar)var).name.toLowerCase().startsWith(prefix) && valuesAlreadyAdded.add((Object)((EVar)var).name)) {
                            completions.add(Completions.createLocalValueCompletion(request.position, prefix, declarations, moduleName, ((EVar)var).name, valueType.type));
                            if (maxNumberOfCompletions.decrementAndGet() <= 0) break block19;
                        }
                        ++n;
                    }
                }
                for (String valueName : declarations.valueDefinitionsAst.getValueNames()) {
                    if (!valueName.toLowerCase().startsWith(prefix) || !valuesAlreadyAdded.add((Object)valueName)) continue;
                    completions.add(Completions.createLocalValueCompletion(request.position, prefix, declarations, moduleName, valueName, null));
                    if (maxNumberOfCompletions.decrementAndGet() <= 0) break;
                }
            }
        }
        ArrayList<ImportDeclaration> imports = Elaboration.processRelativeImports(null, request.moduleSource.getModuleName(), declarations.importsAst);
        EnvironmentFactoryImpl environmentFactory = new EnvironmentFactoryImpl(request.repository, request.moduleSource.getBuiltinImports(null), null);
        Environment environment = environmentFactory.createEnvironmentRobustly(context, imports.toArray(new ImportDeclaration[imports.size()]));
        Namespace namespace = environment.getLocalNamespace();
        int pos = 0;
        while (true) {
            int p;
            if ((p = prefix.indexOf(46, pos)) == -1) {
                prefix = prefix.substring(pos);
                break;
            }
            String namespaceName = prefix.substring(pos, p);
            Namespace temp = namespace.getNamespace(namespaceName);
            if (temp == null) {
                prefix = prefix.substring(pos);
                break;
            }
            namespace = temp;
            pos = p + 1;
        }
        final String prefix_ = prefix;
        final THashSet namespacesAlreadyAdded = new THashSet();
        namespacesAlreadyAdded.add((Object)"");
        for (String localNamespace : namespace.getNamespaces()) {
            if (!localNamespace.toLowerCase().startsWith(prefix) || !namespacesAlreadyAdded.add((Object)localNamespace)) continue;
            completions.add(Completions.createNamespaceCompletion(request.position, prefix, localNamespace));
        }
        namespace.findTypesForPrefix(prefix, AcceptAllNamespaceFilter.INSTANCE, type -> {
            completions.add(Completions.createImportedTypeCompletion(completionRequest.position, prefix_, type));
            maxNumberOfCompletions.decrementAndGet();
        });
        namespace.findValuesForPrefix(prefix, AcceptAllNamespaceFilter.INSTANCE, new TObjectProcedure<SCLValue>(){

            public boolean execute(SCLValue value) {
                String name = value.getName().name;
                int dp = name.indexOf(46, prefix_.length());
                if (dp != -1) {
                    String localNamespace = name.substring(0, dp);
                    if (namespacesAlreadyAdded.add((Object)localNamespace)) {
                        completions.add(Completions.createNamespaceCompletion(request.position, prefix_, localNamespace));
                        return maxNumberOfCompletions.decrementAndGet() > 0;
                    }
                    return true;
                }
                completions.add(Completions.createImportedValueCompletion(request.position, prefix_, value));
                return maxNumberOfCompletions.decrementAndGet() > 0;
            }
        });
        Collections.sort(completions, new CompletionComparator());
        return completions;
    }

    private static Completion createNamespaceCompletion(int position, String prefix, String localNamespace) {
        int length = prefix.length();
        int begin = position - length;
        return new Completion(position - length, length, localNamespace, begin + localNamespace.length(), CompletionType.Namespace, null, localNamespace, null, null);
    }

    private static Completion createLocalValueCompletion(int position, String prefix, DeclarationClassification declarations, String moduleName, String valueName, TypeAst type) {
        int length = prefix.length();
        int begin = position - length;
        DDocumentationAst documentationAst = (DDocumentationAst)declarations.valueDocumentation.get((Object)valueName);
        String documentation = documentationAst != null ? documentationAst.documentation : null;
        return new Completion(position - length, length, valueName, begin + valueName.length(), CompletionType.Value, moduleName, valueName, type != null ? type.toString() : null, documentation);
    }

    private static Completion createLocalTypeCompletion(int position, String prefix, DeclarationClassification declarations, String moduleName, String typeName) {
        int length = prefix.length();
        int begin = position - length;
        return new Completion(position - length, length, typeName, begin + typeName.length(), CompletionType.Type, moduleName, typeName, null, null);
    }

    private static Completion createImportedValueCompletion(int position, String prefix, SCLValue value) {
        int length = prefix.length();
        int begin = position - length;
        String documentation = value.documentation;
        Name name = value.getName();
        return new Completion(position - length, length, name.name, begin + name.name.length(), CompletionType.Value, name.module, name.name, value.getType().toString(), documentation);
    }

    private static Completion createImportedTypeCompletion(int position, String prefix, TCon type) {
        int length = prefix.length();
        int begin = position - length;
        return new Completion(position - length, length, type.name, begin + type.name.length(), CompletionType.Type, type.module, type.name, null, "");
    }
}

