/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.compilation;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import org.simantics.scl.compiler.compilation.CodeGeneration;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.compilation.CompilationTimer;
import org.simantics.scl.compiler.compilation.DeclarationClassification;
import org.simantics.scl.compiler.compilation.DocumentationGeneration;
import org.simantics.scl.compiler.compilation.Elaboration;
import org.simantics.scl.compiler.compilation.TypeChecking;
import org.simantics.scl.compiler.environment.EnvironmentFactory;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidatorFactory;
import org.simantics.scl.compiler.internal.parsing.declarations.DeclarationAst;
import org.simantics.scl.compiler.internal.parsing.exceptions.SCLSyntaxErrorException;
import org.simantics.scl.compiler.internal.parsing.parser.SCLParserImpl;
import org.simantics.scl.compiler.internal.parsing.parser.SCLParserOptions;
import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.module.options.ModuleCompilationOptions;
import org.simantics.scl.compiler.top.ModuleInitializer;
import org.simantics.scl.compiler.top.StandardModuleInitializer;

public class SCLCompiler {
    CompilationContext compilationContext = new CompilationContext();
    DeclarationClassification declarations = new DeclarationClassification(this.compilationContext);
    Map<String, byte[]> classes;
    ConcreteModule module;
    ModuleInitializer moduleInitializer;
    private CompilationTimer timer;
    private ModuleCompilationOptions options;
    JavaReferenceValidatorFactory jrvFactory;

    public SCLCompiler(ModuleCompilationOptions options, JavaReferenceValidatorFactory jrvFactory) {
        this.options = options == null ? ModuleCompilationOptions.STANDARD_OPTIONS : options;
        this.jrvFactory = jrvFactory;
    }

    public void addSource(Reader sourceReader) {
        try {
            try {
                SCLParserImpl parser = new SCLParserImpl(sourceReader);
                parser.setParserOptions(SCLParserOptions.MODULE_DEFAULT);
                parser.setCompilationContext(this.compilationContext);
                if (!parser.isEmpty()) {
                    for (DeclarationAst declaration : (ArrayList)parser.parseModule()) {
                        this.declarations.handle(declaration);
                    }
                }
            }
            catch (SCLSyntaxErrorException e) {
                this.compilationContext.errorLog.log(e.location, e.getMessage());
                try {
                    sourceReader.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (Exception e) {
                this.compilationContext.errorLog.log(e);
                try {
                    sourceReader.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                sourceReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean hasErrors() {
        return !this.compilationContext.errorLog.hasNoErrors();
    }

    public void compile(EnvironmentFactory localEnvironmentFactory, String moduleName) {
        try {
            if (this.hasErrors()) {
                return;
            }
            Elaboration elaboration = new Elaboration(this.compilationContext, this.timer, localEnvironmentFactory, moduleName, this.compilationContext.header, this.declarations.importsAst, this.jrvFactory, this.declarations.valueDefinitionsAst, this.declarations.relationDefinitionsAst);
            if (this.options.computeCoverage) {
                elaboration.addCoverageBranchPoints();
            }
            if (this.options.collectDebugInfo) {
                elaboration.collectDebugInfo();
            }
            if (this.hasErrors()) {
                return;
            }
            elaboration.addTypesToEnvironment(this.declarations.dataTypesAst, this.declarations.typeAliasesAst, this.declarations.effectsAst, this.declarations.rulesetsAst);
            if (this.hasErrors()) {
                return;
            }
            elaboration.processTypeAliases(this.declarations.typeAliasesAst);
            if (this.hasErrors()) {
                return;
            }
            elaboration.processDataTypes(this.declarations.dataTypesAst);
            if (this.hasErrors()) {
                return;
            }
            elaboration.processTypeClasses(this.declarations.typeClassesAst);
            if (this.hasErrors()) {
                return;
            }
            elaboration.processDerivingInstances(this.declarations.derivingInstancesAst, this.declarations.instancesAst);
            if (this.hasErrors()) {
                return;
            }
            elaboration.processInstances(this.declarations.instancesAst);
            if (this.hasErrors()) {
                return;
            }
            elaboration.processJavaMethods(this.declarations.javaMethodDeclarations);
            if (this.hasErrors()) {
                return;
            }
            elaboration.processRulesets(this.declarations.rulesetsAst);
            if (this.hasErrors()) {
                return;
            }
            elaboration.addDataTypesToEnvironment();
            elaboration.addTypeClassesToEnvironment();
            elaboration.preprocessValueDefinitions(this.declarations.typeAnnotationsAst);
            elaboration.processMappingRelations(this.declarations.mappingRelationsAst);
            elaboration.addFixityToEnvironment(this.declarations.fixityAst);
            elaboration.addValueDefinitionsToEnvironment(this.declarations.typeAnnotationsAst);
            elaboration.processRules(this.declarations.rulesAst);
            elaboration.addSupplementedTypeAnnotationsToEnvironment();
            if (this.hasErrors()) {
                return;
            }
            new TypeChecking(this.compilationContext, elaboration.module).typeCheck();
            new DocumentationGeneration(this.declarations.valueDocumentation, this.declarations.typeDocumentation, this.declarations.classDocumentation, elaboration.module).generateDocumentation();
            this.declarations = null;
            if (this.hasErrors()) {
                return;
            }
            CodeGeneration codeGeneration = new CodeGeneration(this.compilationContext, elaboration.javaReferenceValidator, elaboration.module);
            codeGeneration.simplifyValues();
            if (this.hasErrors()) {
                return;
            }
            codeGeneration.convertToSSA();
            if (this.hasErrors()) {
                return;
            }
            codeGeneration.optimizeSSA();
            if (this.hasErrors()) {
                return;
            }
            codeGeneration.generateCode();
            if (this.hasErrors()) {
                return;
            }
            codeGeneration.generateDataTypes(elaboration.dataTypes);
            if (this.hasErrors()) {
                return;
            }
            codeGeneration.generateTypeClasses();
            if (this.hasErrors()) {
                return;
            }
            codeGeneration.generateTypeClassInstances();
            if (this.hasErrors()) {
                return;
            }
            this.classes = codeGeneration.classes;
            this.module = codeGeneration.module;
            this.moduleInitializer = StandardModuleInitializer.create(this.compilationContext.namingPolicy.getModuleClassName(), codeGeneration.externalConstants);
            this.module.setClasses(this.classes);
            this.module.setParentClassLoader(elaboration.javaReferenceValidator.getClassLoader());
            this.module.setModuleInitializer(this.moduleInitializer);
            this.module.setBranchPoints(elaboration.branchPoints);
            if (this.compilationContext.errorLog.hasErrorsOrWarnings()) {
                this.module.setWarnings(this.compilationContext.errorLog.getErrors());
            }
        }
        catch (Exception e) {
            this.compilationContext.errorLog.log(e);
        }
    }

    public ErrorLog getErrorLog() {
        return this.compilationContext.errorLog;
    }

    public Map<String, byte[]> getClasses() {
        return this.classes;
    }

    public ConcreteModule getModule() {
        return this.module;
    }

    public ModuleInitializer getModuleInitializer() {
        return this.moduleInitializer;
    }

    private void initializeTiming() {
        this.timer = new CompilationTimer();
    }

    private void phaseFinished(String phaseName) {
        this.timer.phaseFinished(phaseName);
    }

    private void reportTiming(String moduleName) {
        this.timer.report(moduleName);
    }
}

