/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.queries;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.queries.ComponentLocation;

public class GetComponentLocation
extends UnaryRead<Variable, ComponentLocation> {
    public GetComponentLocation(Variable component) {
        super((Object)component);
    }

    public ComponentLocation perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        boolean isInsideStructure = false;
        boolean isInsideModelConfiguration = false;
        boolean hasRepresentation = ((Variable)this.parameter).getPossibleRepresents(graph) != null;
        Variable firstRepresentedParent = GetComponentLocation.findFirstParentWithRepresentation(graph, (Variable)this.parameter, STR);
        if (firstRepresentedParent == null) {
            return null;
        }
        Resource realParentComposite = graph.getPossibleObject(firstRepresentedParent.getRepresents(graph), L0.PartOf);
        if (realParentComposite == null) {
            return null;
        }
        isInsideStructure = graph.hasStatement(realParentComposite, STR.Defines);
        Variable firstParentComposite = GetComponentLocation.findFirstParentComposite(graph, firstRepresentedParent, STR);
        if (firstParentComposite != null) {
            Variable configurationContext = Variables.getPossibleConfigurationContext((ReadGraph)graph, (Variable)firstParentComposite);
            RVI rvi = firstParentComposite.getPossibleRVI(graph);
            if (rvi != null) {
                Variable firstConfigurationParentComposite = rvi.resolvePossible(graph, configurationContext);
                isInsideModelConfiguration = firstConfigurationParentComposite != null;
            }
        }
        return new ComponentLocation(isInsideStructure, isInsideModelConfiguration, hasRepresentation);
    }

    private static Variable findFirstParentWithRepresentation(ReadGraph graph, Variable var, StructuralResource2 STR) throws DatabaseException {
        while (var != null) {
            Resource represents = var.getPossibleRepresents(graph);
            if (represents != null) {
                return var;
            }
            var = var.getParent(graph);
        }
        return null;
    }

    private static Variable findFirstParentComposite(ReadGraph graph, Variable var, StructuralResource2 STR) throws DatabaseException {
        while (var != null) {
            Resource represents = var.getPossibleRepresents(graph);
            if (represents != null && graph.isInstanceOf(represents, STR.Composite)) {
                return var;
            }
            var = var.getParent(graph);
        }
        return null;
    }
}

