/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.function;

import gnu.trove.map.hash.THashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.datatypes.utils.BTreeContentBean;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.StandardRealm;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.function.StandardChildDomainChildren;
import org.simantics.db.layer0.request.PossibleActiveRun;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.ConstantChildVariable;
import org.simantics.db.layer0.variable.ConstantPropertyVariableBuilder;
import org.simantics.db.layer0.variable.ProxyChildVariable;
import org.simantics.db.layer0.variable.ProxyVariables;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableMapImpl;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.document.server.io.IColor;
import org.simantics.document.server.io.IFont;
import org.simantics.document.server.io.ITableCell;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.graph.ExcelFormula;
import org.simantics.spreadsheet.graph.SpreadsheetBook;
import org.simantics.spreadsheet.graph.SpreadsheetCell;
import org.simantics.spreadsheet.graph.SpreadsheetCellContent;
import org.simantics.spreadsheet.graph.SpreadsheetFormula;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.graph.SpreadsheetSCLConstant;
import org.simantics.spreadsheet.graph.SpreadsheetSessionManager;
import org.simantics.spreadsheet.graph.SpreadsheetStyle;
import org.simantics.spreadsheet.graph.celleditor.GraphCellEditorAdapter;
import org.simantics.spreadsheet.graph.function.CompileSCLValueRequest;
import org.simantics.spreadsheet.graph.function.LineContentBean;
import org.simantics.spreadsheet.graph.function.LineContentBeanCell;
import org.simantics.spreadsheet.graph.parser.ParseException;
import org.simantics.spreadsheet.graph.parser.SheetFormulaParser;
import org.simantics.spreadsheet.graph.parser.ast.AstValue;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class All {
    private static Set<String> CLASSIFICATIONS = new HashSet<String>();
    private static ConstantPropertyVariableBuilder immutableBuilder = new ConstantPropertyVariableBuilder("immutable", (Object)true, (Binding)Bindings.BOOLEAN);
    @SCLValue(type="ValueAccessor")
    public static ValueAccessor contentValueAccessor;
    @SCLValue(type="ValueAccessor")
    public static ValueAccessor contentDisplayValueAccessor;
    @SCLValue(type="VariableMap")
    public static VariableMap stringArrayChildren;
    @SCLValue(type="VariableMap")
    public static VariableMap queryRangeChildren;
    @SCLValue(type="VariableMap")
    public static VariableMap spreadsheetLinesChildren;
    @SCLValue(type="VariableMap")
    public static VariableMap doubleArrayChildren;
    @SCLValue(type="VariableMap")
    public static VariableMap spreadsheetChildren;

    static {
        CLASSIFICATIONS.add("http://www.simantics.org/Spreadsheet-1.2/Attribute");
        contentValueAccessor = new ValueAccessor(){

            public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
                System.out.println("contentValueAccessor.context=" + context.getURI((ReadGraph)graph));
                if (value instanceof String) {
                    String text = (String)value;
                    SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                    if (text.startsWith("==")) {
                        if (!Layer0Utils.setOrClearExpression((WriteGraph)graph, (Variable)context, (String)text.substring(1), (Resource)SHEET.SCLValue)) {
                            org.simantics.db.layer0.function.All.standardSetValue3((WriteGraph)graph, (Variable)context, (Object)Variant.ofInstance((Object)value), (Binding)Bindings.VARIANT);
                        }
                        return;
                    }
                    Variable cell = context.getParent((ReadGraph)graph);
                    System.out.println("setValue : " + cell.getURI((ReadGraph)graph));
                    String formula = text.substring(1);
                    if (ProxyVariables.isProxy((ReadGraph)graph, (Variable)context)) {
                        try {
                            SheetFormulaParser p = new SheetFormulaParser(new StringReader(formula));
                            AstValue v = p.relation();
                            SpreadsheetFormula sformula = new SpreadsheetFormula(v, formula);
                            this.setValueToEngine(graph, cell, context, sformula, binding);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    Variant v = new Variant(ExcelFormula.BINDING, (Object)new ExcelFormula(formula));
                    graph.claimLiteral(cell.getRepresents((ReadGraph)graph), SHEET.Cell_content, SHEET.Cell_content_Inverse, Layer0.getInstance((ReadGraph)graph).Variant, (Object)v, (Binding)Bindings.VARIANT);
                } else {
                    if (ProxyVariables.isProxy((ReadGraph)graph, (Variable)context)) {
                        Variable cell = context.getParent((ReadGraph)graph);
                        this.setValueToEngine(graph, cell, context, value, binding);
                        return;
                    }
                    String expression = (String)context.getPossiblePropertyValue((ReadGraph)graph, "expression");
                    if (expression != null) {
                        Object current_ = context.getPossibleValue((ReadGraph)graph);
                        if (current_ instanceof Variable) {
                            Variable current = (Variable)current_;
                            Variant variant = (Variant)value;
                            Datatype dt = current.getDatatype((ReadGraph)graph);
                            if (dt == null) {
                                throw new DatabaseException();
                            }
                            Binding variableBinding = Bindings.getBinding((Datatype)dt);
                            try {
                                Object adapted = variant.getValue(variableBinding);
                                current.setValue(graph, adapted, variableBinding);
                            }
                            catch (AdaptException e) {
                                Logger.defaultLogError((Throwable)e);
                            }
                            return;
                        }
                        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                        Layer0Utils.clearExpression((WriteGraph)graph, (Variable)context, (Resource)SHEET.SCLValue);
                    }
                    org.simantics.db.layer0.function.All.standardSetValue3((WriteGraph)graph, (Variable)context, (Object)value, (Binding)binding);
                }
            }

            private void setValueToEngine(WriteGraph graph, Variable cell, Variable context, final Object value, final Binding binding) throws DatabaseException {
                Variable sheet = cell.getParent((ReadGraph)graph);
                SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                while (!sheet.getType((ReadGraph)graph).equals(SHEET.Spreadsheet)) {
                    sheet = sheet.getParent((ReadGraph)graph);
                }
                Range r = SpreadsheetUtils.decodeCellAbsolute((String)cell.getName((ReadGraph)graph));
                Variable root = ProxyVariables.proxyVariableRoot((ReadGraph)graph, (Variable)context);
                String sessionName = root.getParent((ReadGraph)graph).getURI((ReadGraph)graph);
                final StandardRealm realm = SpreadsheetSessionManager.getInstance().getOrCreateRealm((ReadGraph)graph, sessionName);
                SpreadsheetBook book = (SpreadsheetBook)realm.getEngine();
                final SpreadsheetCell sc = book.get(sheet.getName((ReadGraph)graph), r.startRow, r.startColumn);
                sc.setContent(value);
                book.invalidate(sc);
                realm.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SpreadsheetCellContent content = (SpreadsheetCellContent)sc.getProperties().get("content");
                            realm.getNodeManager().setValue((Object)content, value, binding);
                        }
                        catch (NodeManagerException e) {
                            Logger.defaultLogError((Throwable)e);
                        }
                    }
                });
            }

            public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
                if (value instanceof String) {
                    this.setValue(graph, context, value, (Binding)Bindings.STRING);
                } else if (value instanceof Variant) {
                    this.setValue(graph, context, value, (Binding)Bindings.VARIANT);
                } else {
                    throw new DatabaseException("Unsupported value type " + value);
                }
            }

            public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
                return org.simantics.db.layer0.function.All.standardGetValue2((ReadGraph)graph, (Variable)context, (Binding)binding);
            }

            public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
                return org.simantics.db.layer0.function.All.standardGetValue1((ReadGraph)graph, (Variable)((StandardGraphPropertyVariable)context));
            }

            public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
                return org.simantics.db.layer0.function.All.standardGetDatatype((ReadGraph)graph, (Variable)context);
            }
        };
        contentDisplayValueAccessor = new ValueAccessor(){

            public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
                if (!Bindings.STRING.equals((Object)binding)) {
                    throw new IllegalArgumentException();
                }
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException();
                }
                if (((String)value).startsWith("=")) {
                    context.getParent((ReadGraph)graph).setValue(graph, value, (Binding)Bindings.STRING);
                } else {
                    context.getParent((ReadGraph)graph).setValue(graph, (Object)new Variant((Binding)Bindings.STRING, value), (Binding)Bindings.VARIANT);
                }
            }

            public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException();
                }
                if (((String)value).startsWith("=")) {
                    context.getParent((ReadGraph)graph).setValue(graph, value, (Binding)Bindings.STRING);
                } else {
                    context.getParent((ReadGraph)graph).setValue(graph, (Object)new Variant((Binding)Bindings.STRING, value), (Binding)Bindings.VARIANT);
                }
            }

            public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
                return context.getParent(graph).getValue(graph, binding);
            }

            public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
                return context.getParent(graph).getValue(graph);
            }

            public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
                return context.getParent(graph).getDatatype(graph);
            }
        };
        stringArrayChildren = new VariableMapImpl(){

            public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
                THashMap map = new THashMap();
                this.getVariables(graph, context, (Map<String, Variable>)map);
                return (Variable)map.get((Object)name);
            }

            public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
                Resource resource = context.getRepresents(graph);
                SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
                String location = (String)graph.getPossibleRelatedValue(resource, sr.Range_location, (Binding)Bindings.STRING);
                if (location == null) {
                    return map;
                }
                Integer width = (Integer)graph.getPossibleRelatedValue(resource, sr.Range_widthBound, (Binding)Bindings.INTEGER);
                if (width == null) {
                    return map;
                }
                String[] array = (String[])graph.getPossibleRelatedValue(resource, sr.StringArrayRange_array, (Binding)Bindings.STRING_ARRAY);
                if (array == null) {
                    return map;
                }
                int rows = array.length / width;
                if (map == null) {
                    map = new HashMap<String, Variable>();
                }
                int offset = 0;
                int i = 0;
                while (i < rows) {
                    int j = 0;
                    while (j < width) {
                        String value = array[offset++];
                        String valueLocation = SpreadsheetUtils.offset((String)location, (int)i, (int)j);
                        ConstantPropertyVariableBuilder labelBuilder = new ConstantPropertyVariableBuilder("label", (Object)value, (Binding)Bindings.STRING, Collections.emptyList(), CLASSIFICATIONS);
                        ConstantPropertyVariableBuilder typeBuilder = new ConstantPropertyVariableBuilder("Type", (Object)sr.Cell, null, Collections.emptyList(), Collections.emptySet());
                        map.put(valueLocation, (Variable)new ConstantChildVariable(context, valueLocation, new ConstantPropertyVariableBuilder[]{labelBuilder, typeBuilder, immutableBuilder}));
                        ++j;
                    }
                    ++i;
                }
                return map;
            }
        };
        queryRangeChildren = new VariableMapImpl(){

            public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
                THashMap map = new THashMap();
                this.getVariables(graph, context, (Map<String, Variable>)map);
                return (Variable)map.get((Object)name);
            }

            public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
                SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
                String location = "A1";
                try {
                    Object object = context.getPropertyValue(graph, sr.ExpressionRange_cells);
                    List data = (List)object;
                    if (map == null) {
                        map = new HashMap<String, Variable>();
                    }
                    for (Object o : data) {
                        IColor background;
                        if (!(o instanceof ITableCell)) continue;
                        ITableCell cell = (ITableCell)o;
                        String valueLocation = SpreadsheetUtils.offset((String)location, (int)cell.getRow(), (int)cell.getColumn());
                        ArrayList<ConstantPropertyVariableBuilder> builders = new ArrayList<ConstantPropertyVariableBuilder>();
                        builders.add(new ConstantPropertyVariableBuilder("content", (Object)Variant.ofInstance((Object)cell.getText()), (Binding)Bindings.VARIANT, Collections.emptyList(), CLASSIFICATIONS));
                        builders.add(new ConstantPropertyVariableBuilder("Type", (Object)sr.Cell, null, Collections.emptyList(), Collections.emptySet()));
                        IFont font = cell.getFont();
                        if (font != null) {
                            builders.add(new ConstantPropertyVariableBuilder("font", (Object)new Font(font.getFamily(), font.getHeight(), font.getStyle()), Font.BINDING, Collections.emptyList(), CLASSIFICATIONS));
                        }
                        int align = cell.getAlign();
                        builders.add(new ConstantPropertyVariableBuilder("align", (Object)align, (Binding)Bindings.INTEGER, Collections.emptyList(), CLASSIFICATIONS));
                        IColor foreground = cell.getFGColor();
                        if (foreground != null) {
                            builders.add(new ConstantPropertyVariableBuilder("foreground", (Object)new RGB.Integer(foreground.red(), foreground.green(), foreground.blue()), RGB.Integer.BINDING, Collections.emptyList(), CLASSIFICATIONS));
                        }
                        if ((background = cell.getBGColor()) != null) {
                            builders.add(new ConstantPropertyVariableBuilder("background", (Object)new RGB.Integer(background.red(), background.green(), background.blue()), RGB.Integer.BINDING, Collections.emptyList(), CLASSIFICATIONS));
                        }
                        map.put(valueLocation, (Variable)new ConstantChildVariable(context, valueLocation, builders));
                    }
                }
                catch (DatabaseException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new DatabaseException(t);
                }
                return map;
            }
        };
        spreadsheetLinesChildren = new StandardChildDomainChildren(){

            public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
                if (ProxyVariables.isProxy((ReadGraph)graph, (Variable)context)) {
                    return StandardChildDomainChildren.getStandardChildDomainChildVariable((ReadGraph)graph, (Variable)context, null, (String)name);
                }
                return super.getVariable(graph, context, name);
            }

            public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
                if (ProxyVariables.isProxy((ReadGraph)graph, (Variable)context)) {
                    return StandardChildDomainChildren.getStandardChildDomainChildVariables((ReadGraph)graph, (Variable)context, Collections.emptyMap(), map);
                }
                return super.getVariables(graph, context, map);
            }
        };
        doubleArrayChildren = new VariableMapImpl(){

            public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
                THashMap map = new THashMap();
                this.getVariables(graph, context, (Map<String, Variable>)map);
                return (Variable)map.get((Object)name);
            }

            public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
                Resource resource = context.getRepresents(graph);
                SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
                String location = (String)graph.getPossibleRelatedValue(resource, sr.Range_location, (Binding)Bindings.STRING);
                if (location == null) {
                    return map;
                }
                Integer width = (Integer)graph.getPossibleRelatedValue(resource, sr.Range_widthBound, (Binding)Bindings.INTEGER);
                if (width == null) {
                    return map;
                }
                double[] array = (double[])graph.getPossibleRelatedValue(resource, sr.DoubleArrayRange_array, (Binding)Bindings.DOUBLE_ARRAY);
                if (array == null) {
                    return map;
                }
                if (map == null) {
                    map = new HashMap<String, Variable>();
                }
                int rows = array.length / width;
                int offset = 0;
                int i = 0;
                while (i < rows) {
                    int j = 0;
                    while (j < width) {
                        double value = array[offset++];
                        String valueLocation = SpreadsheetUtils.offset((String)location, (int)i, (int)j);
                        ConstantPropertyVariableBuilder labelBuilder = new ConstantPropertyVariableBuilder("label", (Object)String.valueOf(value), (Binding)Bindings.STRING, Collections.emptyList(), CLASSIFICATIONS);
                        ConstantPropertyVariableBuilder typeBuilder = new ConstantPropertyVariableBuilder("Type", (Object)sr.Cell, null, Collections.emptyList(), Collections.emptySet());
                        map.put(valueLocation, (Variable)new ConstantChildVariable(context, valueLocation, new ConstantPropertyVariableBuilder[]{labelBuilder, typeBuilder, immutableBuilder}));
                        ++j;
                    }
                    ++i;
                }
                return map;
            }
        };
        spreadsheetChildren = new VariableMapImpl(){

            public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
                if (">>>".equals(name)) {
                    return this.getProxy(graph, context);
                }
                return org.simantics.db.layer0.function.All.standardChildDomainChildren.getVariable(graph, context, name);
            }

            private Variable getProxy(ReadGraph graph, Variable context) throws DatabaseException {
                Variable root = Variables.getRootVariable((ReadGraph)graph);
                return new SpreadsheetProxyChildVariable(context, context, root, ">>>");
            }

            public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
                if ((map = org.simantics.db.layer0.function.All.standardChildDomainChildren.getVariables(graph, context, map)) == null) {
                    map = new HashMap<String, Variable>();
                }
                map.put(">>>", this.getProxy(graph, context));
                return map;
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> String")
    public static String cellLabel(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        if (context instanceof Resource) {
            return NameUtils.getSafeLabel((ReadGraph)graph, (Resource)((Resource)context));
        }
        if (context instanceof Variable) {
            Variable parent = ((Variable)context).getParent(graph);
            Variable content = parent.getPossibleProperty(graph, "content");
            if (content != null) {
                Databoard db = (Databoard)graph.getService(Databoard.class);
                Variant variant = (Variant)content.getValue(graph, (Binding)db.VARIANT);
                return variant.getValue().toString();
            }
            return parent.getName(graph);
        }
        throw new DatabaseException("Unknown context " + context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> CellEditor")
    public static CellEditor<Write> defaultSheetCellEditor(ReadGraph graph, Resource resource, Variable context_) throws DatabaseException {
        final Variable sheet = context_.getParent(graph);
        return new GraphCellEditorAdapter(null){

            @Override
            public <T> void edit(final CellEditor.Transaction<Write> transaction, final String location, final String property, final T value, final Binding binding, final Consumer<?> callback) {
                SpreadsheetUtils.schedule(transaction, (Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        CellEditor editor = this.getPossibleCellEditor(graph, location, value == null ? null : new Variant(binding, value));
                        if (editor == null) {
                            return;
                        }
                        editor.edit(transaction, location, property, value, binding, callback);
                    }
                });
            }

            @Override
            public void edit(final CellEditor.Transaction<Write> transaction, final String location, final Variant value, final Consumer<?> callback) {
                SpreadsheetUtils.schedule(transaction, (Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        CellEditor editor = this.getPossibleCellEditor(graph, location, value);
                        if (editor == null) {
                            return;
                        }
                        editor.edit(transaction, location, value, callback);
                    }
                });
            }

            private CellEditor<Write> getPossibleCellEditor(WriteGraph graph, String location, Variant value) throws DatabaseException {
                SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                Range range = SpreadsheetUtils.decodeCellAbsolute((String)location);
                List<Variable> cells = SpreadsheetGraphUtils.possibleConfigurationCellVariables((ReadGraph)graph, sheet, range);
                if (cells.isEmpty()) {
                    if (value == null) {
                        return null;
                    }
                    cells = SpreadsheetGraphUtils.getOrCreateConfigurationCellVariables(graph, sheet, range);
                }
                if (cells.size() != 1) {
                    throw new DatabaseException("Can edit only one cell at a time!");
                }
                return (CellEditor)cells.iterator().next().getPropertyValue((ReadGraph)graph, SHEET.cellEditor);
            }

            @Override
            public void copy(final CellEditor.Transaction<Write> transaction, final String location, final MutableVariant variant, Consumer<?> callback) {
                SpreadsheetUtils.schedule(transaction, (Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        CellEditor editor;
                        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                        Variable variable = sheet.getPossibleChild((ReadGraph)graph, location);
                        if (variable != null && (editor = (CellEditor)variable.getPossiblePropertyValue((ReadGraph)graph, SHEET.cellEditor)) != null) {
                            editor.copy(transaction, location, variant, null);
                        }
                    }
                });
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> CellEditor")
    public static CellEditor<Write> variableCellEditor(ReadGraph graph, Resource resource, Variable context_) throws DatabaseException {
        Variable cell = context_.getParent(graph);
        return new GraphCellEditorAdapter(cell){

            @Override
            public <T> void edit(WriteGraph graph, CellEditor.Transaction<Write> transaction, String location, String property, T value, Binding binding) throws DatabaseException {
                this.cell.setPropertyValue(graph, property, value, binding);
            }
        };
    }

    private static int encodeLineOrNode(ReadGraph graph, Resource r) throws DatabaseException {
        if (r == null) {
            return 0;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getRelatedValue(r, L0.HasName, (Binding)Bindings.STRING);
        if (name.charAt(0) == 'R') {
            return -Integer.parseInt(name.substring(3));
        }
        return Integer.parseInt(name);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static int[] lineNodeKeys(ReadGraph graph, Resource resource, Variable context_) throws DatabaseException {
        Resource node = context_.getParent(graph).getRepresents(graph);
        BTreeContentBean bean = BTreeContentBean.readPossible((ReadGraph)graph, (Resource)node);
        if (bean == null) {
            return new int[0];
        }
        int[] result = new int[2 * bean.n + 1];
        int i = 0;
        while (i < bean.n) {
            result[2 * i] = All.encodeLineOrNode(graph, bean.getChild(i));
            result[2 * i + 1] = (Integer)bean.getKey(i).getValue();
            ++i;
        }
        result[2 * bean.n] = All.encodeLineOrNode(graph, bean.getChild(bean.n));
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> LineContentBean")
    public static LineContentBean defaultLineCells(ReadGraph graph, Resource resource, Variable context_) throws DatabaseException {
        context_.getURI(graph);
        Variable line = context_.getParent(graph);
        Collection children = line.getChildren(graph);
        ObjectArrayList result = new ObjectArrayList();
        SpreadsheetResource SR = SpreadsheetResource.getInstance((ReadGraph)graph);
        for (Variable child : children) {
            Resource repr = child.getRepresents(graph);
            Resource style = graph.getPossibleObject(repr, SR.Cell_HasStyle);
            Integer styleId = null;
            if (style != null) {
                styleId = (Integer)graph.getPossibleRelatedValue(style, SR.Style_id, (Binding)Bindings.INTEGER);
            }
            if (styleId == null) {
                System.err.println("Style " + style + " has no ID or either cell " + repr + " has no style attached to it !!");
                styleId = SpreadsheetStyle.empty().getStyleId();
            }
            LineContentBeanCell cell = new LineContentBeanCell(styleId);
            Variant variant = (Variant)child.getPossiblePropertyValue(graph, SR.Cell_content);
            if (variant == null) continue;
            Variable var = child.getPossibleProperty(graph, SR.Cell_content);
            String expression = (String)var.getPossiblePropertyValue(graph, "expression");
            if (expression != null) {
                cell.setContent(new Variant(SpreadsheetSCLConstant.BINDING, (Object)new SpreadsheetSCLConstant(expression, variant.getValue())));
            } else {
                cell.setContent(variant);
            }
            Range r = SpreadsheetUtils.decodeCellAbsolute((String)child.getName(graph));
            while (result.size() < r.startColumn + 1) {
                result.add((Object)new LineContentBeanCell());
            }
            result.set(r.startColumn, (Object)cell);
        }
        LineContentBean bean = new LineContentBean();
        bean.cells = (LineContentBeanCell[])result.toArray((Object[])new LineContentBeanCell[result.size()]);
        return bean;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> CellEditor")
    public static CellEditor<Write> textCellEditor(ReadGraph graph, Resource resource, Variable context_) throws DatabaseException {
        System.out.println("Context URI : " + context_.getURI(graph));
        Variable cells = context_.getParent(graph);
        System.out.println("Cell URI : " + cells.getURI(graph));
        return new GraphCellEditorAdapter(cells){

            @Override
            public <T> void edit(WriteGraph graph, CellEditor.Transaction<Write> transaction, String location, String property, T value, Binding binding) throws DatabaseException {
                SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                if ("content".equals(property)) {
                    this.cell.setPropertyValue(graph, SHEET.Cell_content, value, (Binding)Bindings.VARIANT);
                    Variable runCell = null;
                    Object transactionContext = transaction.getContext();
                    if (transactionContext != null && transactionContext instanceof Variable) {
                        Variable varContext = (Variable)transactionContext;
                        Variable context = Variables.getContext((ReadGraph)graph, (Variable)varContext);
                        try {
                            runCell = Variables.switchRealization((ReadGraph)graph, (Variable)this.cell, (Resource)context.getRepresents((ReadGraph)graph), (Variable)context);
                        }
                        catch (MissingVariableException missingVariableException) {
                            transaction.needSynchronization((Object)this.cell.getParent((ReadGraph)graph));
                        }
                    }
                    if (runCell != null) {
                        runCell.setPropertyValue(graph, SHEET.Cell_content, value, (Binding)Bindings.VARIANT);
                    }
                } else if ("content#expression".equals(property)) {
                    this.cell.setPropertyValue(graph, SHEET.Cell_content, value, (Binding)Bindings.STRING);
                    Variable runCell = null;
                    Object transactionContext = transaction.getContext();
                    if (transactionContext != null && transactionContext instanceof Variable) {
                        Variable varContext = (Variable)transactionContext;
                        Variable context = Variables.getContext((ReadGraph)graph, (Variable)varContext);
                        try {
                            runCell = Variables.switchRealization((ReadGraph)graph, (Variable)this.cell, (Resource)context.getRepresents((ReadGraph)graph), (Variable)context);
                        }
                        catch (MissingVariableException missingVariableException) {
                            transaction.needSynchronization((Object)this.cell.getParent((ReadGraph)graph));
                        }
                    }
                    if (runCell != null) {
                        runCell.setPropertyValue(graph, SHEET.Cell_content, value, (Binding)Bindings.STRING);
                    }
                } else if ("border".equals(property)) {
                    Resource textCell = this.cell.getRepresents((ReadGraph)graph);
                    Resource styleContainer = graph.getSingleObject(textCell, SHEET.Cell_HasStyle);
                    SpreadsheetStyle.SpreadsheetStyleBuilder builder = this.computeStyleBuilder(SHEET, graph, styleContainer);
                    builder.border((Integer)value);
                    this.finishStyleUpdate(graph, SHEET, styleContainer, textCell, builder, transaction);
                } else if ("align".equals(property)) {
                    Resource textCell = this.cell.getRepresents((ReadGraph)graph);
                    Resource styleContainer = graph.getSingleObject(textCell, SHEET.Cell_HasStyle);
                    SpreadsheetStyle.SpreadsheetStyleBuilder builder = this.computeStyleBuilder(SHEET, graph, styleContainer);
                    builder.align((Integer)value);
                    this.finishStyleUpdate(graph, SHEET, styleContainer, textCell, builder, transaction);
                } else if ("locked".equals(property)) {
                    this.cell.setPropertyValue(graph, SHEET.Cell_locked, value, (Binding)Bindings.BOOLEAN);
                } else if ("rowSpan".equals(property)) {
                    this.cell.setPropertyValue(graph, SHEET.Cell_rowSpan, value, (Binding)Bindings.INTEGER);
                } else if ("columnSpan".equals(property)) {
                    this.cell.setPropertyValue(graph, SHEET.Cell_columnSpan, value, (Binding)Bindings.INTEGER);
                } else if ("font".equals(property)) {
                    Resource textCell = this.cell.getRepresents((ReadGraph)graph);
                    Resource styleContainer = graph.getSingleObject(textCell, SHEET.Cell_HasStyle);
                    SpreadsheetStyle.SpreadsheetStyleBuilder builder = this.computeStyleBuilder(SHEET, graph, styleContainer);
                    builder.font((Font)value);
                    this.finishStyleUpdate(graph, SHEET, styleContainer, textCell, builder, transaction);
                } else if ("foreground".equals(property)) {
                    Resource textCell = this.cell.getRepresents((ReadGraph)graph);
                    Resource styleContainer = graph.getSingleObject(textCell, SHEET.Cell_HasStyle);
                    SpreadsheetStyle.SpreadsheetStyleBuilder builder = this.computeStyleBuilder(SHEET, graph, styleContainer);
                    builder.foreground((RGB.Integer)value);
                    this.finishStyleUpdate(graph, SHEET, styleContainer, textCell, builder, transaction);
                } else if ("background".equals(property)) {
                    Resource textCell = this.cell.getRepresents((ReadGraph)graph);
                    Resource styleContainer = graph.getSingleObject(textCell, SHEET.Cell_HasStyle);
                    SpreadsheetStyle.SpreadsheetStyleBuilder builder = this.computeStyleBuilder(SHEET, graph, styleContainer);
                    builder.background((RGB.Integer)value);
                    this.finishStyleUpdate(graph, SHEET, styleContainer, textCell, builder, transaction);
                }
            }

            private void finishStyleUpdate(WriteGraph graph, SpreadsheetResource SHEET, Resource styleContainer, Resource textCell, SpreadsheetStyle.SpreadsheetStyleBuilder builder, CellEditor.Transaction<?> transaction) throws DatabaseException {
                Variable bookVariable = Variables.getContext((ReadGraph)graph, (Variable)this.cell);
                Resource book = bookVariable.getRepresents((ReadGraph)graph);
                Resource createdStyle = null;
                SpreadsheetStyle style = builder.build();
                int styleId = style.getStyleId();
                Collection existingStyles = (Collection)graph.syncRequest((Read)new ObjectsWithType(book, Layer0.getInstance((ReadGraph)graph).ConsistsOf, SHEET.Style));
                for (Resource eStyle : existingStyles) {
                    int eStyleId = (Integer)graph.getRelatedValue2(eStyle, SHEET.Style_id, (Binding)Bindings.INTEGER);
                    if (eStyleId != styleId) continue;
                    createdStyle = eStyle;
                    break;
                }
                if (createdStyle == null) {
                    style = builder.name("Style_" + existingStyles.size()).build();
                    createdStyle = SpreadsheetGraphUtils.createStyle(graph, book, style);
                }
                graph.deny(textCell, SHEET.Cell_HasStyle);
                Collection cellsOfStyle = graph.getObjects(styleContainer, SHEET.Cell_StyleOf);
                if (cellsOfStyle.isEmpty()) {
                    graph.deny(styleContainer);
                }
                graph.claim(textCell, SHEET.Cell_HasStyle, createdStyle);
            }

            private SpreadsheetStyle.SpreadsheetStyleBuilder computeStyleBuilder(SpreadsheetResource SHEET, WriteGraph graph, Resource styleContainer) throws DatabaseException {
                RGB.Integer foreground = (RGB.Integer)graph.getPossibleRelatedValue2(styleContainer, SHEET.Cell_foreground, RGB.Integer.BINDING);
                RGB.Integer background = (RGB.Integer)graph.getPossibleRelatedValue2(styleContainer, SHEET.Cell_background, RGB.Integer.BINDING);
                Font font = (Font)graph.getPossibleRelatedValue2(styleContainer, SHEET.Cell_font, Font.BINDING);
                Integer align = (Integer)graph.getPossibleRelatedValue2(styleContainer, SHEET.Cell_align, (Binding)Bindings.INTEGER);
                Integer border = (Integer)graph.getPossibleRelatedValue2(styleContainer, SHEET.Cell_border, (Binding)Bindings.INTEGER);
                return SpreadsheetStyle.newInstace().foreground(foreground).background(background).font(font).align(align).border(border);
            }

            @Override
            public <T> void edit(WriteGraph graph, CellEditor.Transaction<Write> transaction, String location, Variant value) throws DatabaseException {
                SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                if (value == null) {
                    value = Variant.ofInstance((Object)"");
                }
                if (!transaction.isOperationMode()) {
                    this.cell.setPropertyValue(graph, SHEET.Cell_content, (Object)value, (Binding)Bindings.VARIANT);
                }
                Variable runCell = null;
                Object transactionContext = transaction.getContext();
                if (transactionContext != null && transactionContext instanceof Variable) {
                    Variable varContext = (Variable)transactionContext;
                    Variable context = Variables.getContext((ReadGraph)graph, (Variable)varContext);
                    try {
                        runCell = Variables.switchRealization((ReadGraph)graph, (Variable)this.cell, (Resource)context.getRepresents((ReadGraph)graph), (Variable)context);
                    }
                    catch (MissingVariableException missingVariableException) {
                        transaction.needSynchronization((Object)this.cell.getParent((ReadGraph)graph));
                    }
                }
                if (runCell != null) {
                    System.out.println("All.edit " + runCell.getURI((ReadGraph)graph));
                    runCell.setPropertyValue(graph, SHEET.Cell_content, (Object)value, (Binding)Bindings.VARIANT);
                }
            }

            @Override
            public <T> void copy(WriteGraph graph, CellEditor.Transaction<Write> transaction, String location, MutableVariant variant) throws DatabaseException {
                SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                Object transactionContext = transaction.getContext();
                if (transactionContext != null && transactionContext instanceof Variable) {
                    Variable varContext = (Variable)transactionContext;
                    Variable context = Variables.getContext((ReadGraph)graph, (Variable)varContext);
                    Variables.switchRealization((ReadGraph)graph, (Variable)this.cell, (Resource)context.getRepresents((ReadGraph)graph), (Variable)context);
                }
                Object object = this.cell.getPropertyValue((ReadGraph)graph, SHEET.Cell_content);
                Variant content = null;
                if (object instanceof Variant) {
                    content = (Variant)object;
                } else if (object instanceof Double) {
                    content = Variant.ofInstance((Object)((Double)object));
                } else if (object instanceof Float) {
                    content = Variant.ofInstance((Object)((Float)object));
                } else if (object instanceof Integer) {
                    content = Variant.ofInstance((Object)((Integer)object));
                } else if (object instanceof Long) {
                    content = Variant.ofInstance((Object)((Long)object));
                } else if (object instanceof String) {
                    content = Variant.ofInstance((Object)((String)object));
                } else if (object instanceof Variable) {
                    content = Variant.ofInstance((Object)((Variable)object));
                } else {
                    throw new DatabaseException("");
                }
                variant.setValue(content);
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable spreadsheetInput(ReadGraph graph, Resource converter, Variable sheet) throws DatabaseException {
        return ProxyVariables.inputVariable((ReadGraph)graph, (Variable)sheet);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable spreadsheetSession(ReadGraph graph, Resource converter, Variable sheet) throws DatabaseException {
        return ProxyVariables.proxySessionVariable((ReadGraph)graph, (Variable)sheet);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable spreadsheetRunInput(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        Resource model = Variables.getModel((ReadGraph)graph, (Variable)property);
        Variable activeRun = (Variable)graph.syncRequest((Read)new PossibleActiveRun(model));
        if (activeRun != null) {
            return activeRun;
        }
        return Variables.getConfigurationContext((ReadGraph)graph, (Resource)model);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object sclValue(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return CompileSCLValueRequest.compileAndEvaluate(graph, context);
    }

    static class SpreadsheetProxyChildVariable
    extends ProxyChildVariable {
        public SpreadsheetProxyChildVariable(Variable base, Variable parent, Variable other, String name) {
            super(base, parent, other, name);
        }

        public Variable create(Variable base, Variable parent, Variable other, String name) {
            return new SpreadsheetProxyChildVariable(base, parent, other, name);
        }

        public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
            if ("<<<".equals(name)) {
                if (this.other instanceof ProxyChildVariable) {
                    return super.getPossibleChild(graph, name);
                }
                return org.simantics.db.layer0.function.All.buildChildVariable((ReadGraph)graph, (Variable)this, (Resource)this.base.getRepresents(graph), null);
            }
            return super.getPossibleChild(graph, name);
        }

        public Collection<Variable> getChildren(ReadGraph graph) throws DatabaseException {
            Collection result = super.getChildren(graph);
            if (!(this.base instanceof ProxyChildVariable)) {
                Variable root = org.simantics.db.layer0.function.All.buildChildVariable((ReadGraph)graph, (Variable)this, (Resource)this.base.getRepresents(graph), null);
                result.add(root);
            }
            return result;
        }
    }
}

