/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.QueryProcessor;

public final class AsyncBarrierImpl
extends AtomicInteger
implements QueryProcessor.AsyncBarrier {
    private static final long serialVersionUID = 4724463372850048672L;
    static final HashMap<AsyncBarrierImpl, Collection<AsyncBarrierImpl>> reverseLookup = new HashMap();
    static final HashMap<AsyncBarrierImpl, Debugger> debuggerMap = new HashMap();
    static final HashMap<AsyncBarrierImpl, Boolean> restartMap = new HashMap();
    static final int WAIT_TIME = 600;
    public static final boolean BOOKKEEPING = false;
    public static final boolean PRINT = false;
    static final boolean RESTART_GUARD = false;
    private final AsyncBarrierImpl caller;

    public AsyncBarrierImpl(AsyncBarrierImpl caller) {
        super(0);
        this.caller = caller;
    }

    @Override
    public void inc() {
        this.inc(null, null);
    }

    public void inc(String debug) {
        this.inc(null, null);
    }

    public void inc(Object id, String info) {
        if (this.incrementAndGet() == 1 && this.caller != null) {
            this.caller.inc(null, null);
        }
    }

    @Override
    public void dec() {
        int count = this.decrementAndGet();
        if (count < 1) {
            if (count == 0 && this.caller != null) {
                this.caller.dec(this);
            }
            if (count < 0) {
                Logger.defaultLogError((String)"Database request processing error. The application code has performed illegal actions (probably called multiple times the execute or exception method of a single result request.", (Throwable)new Exception());
            }
            assert (count >= 0);
        }
    }

    public void dec(Object id) {
        int count = this.decrementAndGet();
        if (count < 1) {
            if (count == 0 && this.caller != null) {
                this.caller.dec(this);
            }
            if (count < 0) {
                Logger.defaultLogError((String)"Database request processing error. The application code has performed illegal actions (probably called multiple times the execute or exception method of a single result request.", (Throwable)new Exception());
                System.exit(-1);
            }
            assert (count >= 0);
        }
    }

    private static void printReverse(AsyncBarrierImpl barrier, int indent) {
        if (barrier.get() == 0) {
            return;
        }
        int i = 0;
        while (i < indent) {
            System.err.print(" ");
            ++i;
        }
        System.err.println("[" + barrier.get() + " requests]: " + barrier);
        Collection<AsyncBarrierImpl> children = reverseLookup.get(barrier);
        if (children != null) {
            for (AsyncBarrierImpl child : children) {
                AsyncBarrierImpl.printReverse(child, indent + 2);
            }
        }
    }

    public void waitBarrier(Object request, ReadGraphImpl impl) {
        if (this.get() > 0) {
            long waitCount = 0L;
            while (this.get() != 0) {
                boolean executed = impl.processor.resume(impl);
                if (executed) {
                    waitCount = 0L;
                }
                if (++waitCount > 100L) {
                    Thread.yield();
                }
                if (waitCount > 1000L) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (waitCount <= 600000L) continue;
                System.err.println("AsyncBarrierImpl.waitBarrier(" + request + ") is taking long to execute, so far " + waitCount / 1000L + " s.");
                throw new RuntimeDatabaseException("Request timed out.");
            }
        }
    }

    public void restart() {
        this.assertReady();
    }

    public void assertReady() {
        int current = this.get();
        if (current != 0) {
            throw new AssertionError((Object)("Barrier was not finished (pending=" + current + ")."));
        }
    }

    public void report() {
    }

    @Override
    public String toString() {
        return "AsyncBarrierImpl@" + System.identityHashCode(this) + " - counter = " + this.get() + " - caller = " + this.caller;
    }

    public class Debugger {
        public HashMap<Object, ArrayList<String>> infos = new HashMap();

        public synchronized void inc(Object id, String info) {
            if (id == null) {
                return;
            }
            ArrayList<String> exist = this.infos.get(id);
            if (exist == null) {
                exist = new ArrayList();
                this.infos.put(id, exist);
            }
            exist.add(info);
        }

        public synchronized void dec(Object id) {
            if (id == null) {
                return;
            }
            ArrayList<String> exist = this.infos.get(id);
            if (exist == null) {
                System.err.println("No data for " + id);
            } else {
                exist.remove(0);
                if (exist.isEmpty()) {
                    this.infos.remove(id);
                }
            }
        }

        public synchronized String toString() {
            StringBuilder b = new StringBuilder();
            for (ArrayList<String> ss : this.infos.values()) {
                for (String s : ss) {
                    b.append("info " + s + "\r\n");
                }
            }
            return b.toString();
        }

        public synchronized void toErr(int indent) {
            char[] spaces = new char[indent];
            Arrays.fill(spaces, ' ');
            for (ArrayList<String> ss : this.infos.values()) {
                for (String s : ss) {
                    if (!s.startsWith("#")) continue;
                    StringBuilder b = new StringBuilder();
                    b.append(spaces);
                    b.append(s);
                    System.err.println(b.toString());
                }
            }
        }
    }
}

