/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz.drawable;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.Graphs;
import org.simantics.graphviz.continuation.Computation;
import org.simantics.graphviz.continuation.Continuation;
import org.simantics.graphviz.drawable.Drawable;
import org.simantics.graphviz.internal.xdot.DrawCommand;
import org.simantics.graphviz.internal.xdot.DrawCommandParser;

public class GraphDrawable
implements Drawable {
    private static String DEFAULT_ALGORITHM = "dot";
    DrawCommand[] commands;
    Rectangle2D bounds;
    private Graph graph;
    private String algorithm;

    public GraphDrawable(Graph graph, String algorithm) {
        this.setGraph(graph, algorithm);
    }

    public GraphDrawable(Graph graph) {
        this.setGraph(graph);
    }

    public GraphDrawable() {
        this.commands = new DrawCommand[0];
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setGraph(Graph graph) {
        this.setGraph(graph, DEFAULT_ALGORITHM);
    }

    public Computation<Graph> setGraph(Graph graph, String algorithm) {
        this.graph = graph;
        this.algorithm = algorithm;
        Computation<Graph> computation = Graphs.createXDot(graph, algorithm);
        final Semaphore semaphore = new Semaphore(0);
        computation.addContinuation(new Continuation<Graph>(){

            @Override
            public void succeeded(Graph xgraph) {
                GraphDrawable.this.commands = DrawCommandParser.parse(xgraph);
                GraphDrawable.this.readBoundingBox(xgraph);
                semaphore.release();
            }

            @Override
            public void failed(Exception exception) {
                exception.printStackTrace();
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return computation;
    }

    private void readBoundingBox(Graph graph) {
        String[] parts = graph.get("bb").split(",");
        double minX = Double.parseDouble(parts[0]);
        double maxY = -Double.parseDouble(parts[1]);
        double maxX = Double.parseDouble(parts[2]);
        double minY = -Double.parseDouble(parts[3]);
        this.bounds = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public synchronized Rectangle2D getBounds() {
        if (this.bounds == null) {
            System.err.println("bounds == null");
        }
        return this.bounds;
    }

    @Override
    public synchronized void draw(Graphics2D g, Rectangle2D area) {
        DrawCommand[] drawCommandArray = this.commands;
        int n = this.commands.length;
        int n2 = 0;
        while (n2 < n) {
            DrawCommand command = drawCommandArray[n2];
            command.draw(g);
            ++n2;
        }
    }
}

