/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmu;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.UUID;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.Simantics;
import org.simantics.fmu.ExecEnvironment;
import org.simantics.fmu.FMUJNIException;
import org.simantics.utils.FileUtils;

public class FMUControlJNI {
    private static int ERROR = 0;
    private static int OK = 1;
    private static String UNSATISFIED_LINK = "Method not found. DLL might not be loaded properly.";
    private static String TEMP_FMU_DIRECTORY_NAME = "fmu";
    public static String TEMP_FMU_COMMON_DIRECTORY;
    public static String LOCK_FILE_NAME;
    public static Object syncObject;
    private String fmuDir;
    public String TEMP_FOLDER_1;
    public String TEMP_FOLDER_2;
    public String TEMP_FMU_DIRECTORY;
    private String dirName;
    private int fmuN = 0;
    private boolean fmuLoaded = false;
    private FileChannel channel;
    private FileLock lock;

    static {
        LOCK_FILE_NAME = "fmu.lock";
        syncObject = new Object();
        File[] libraries = new File[3];
        Bundle bundle = null;
        ExecEnvironment env = ExecEnvironment.calculate();
        if (env.os == ExecEnvironment.OSType.WINDOWS) {
            if (env.arch == ExecEnvironment.ARCHType.X86) {
                bundle = Platform.getBundle((String)"org.simantics.fmu.me.win32");
            } else if (env.arch == ExecEnvironment.ARCHType.X86_64) {
                bundle = Platform.getBundle((String)"org.simantics.fmu.me.win64");
            }
        }
        if (bundle != null) {
            try {
                String root = FileLocator.getBundleFile(bundle).getAbsolutePath();
                if (env.arch == ExecEnvironment.ARCHType.X86_64) {
                    File newFIle = new File(root, "libraries/libexpat.dll");
                    System.load(newFIle.getAbsolutePath());
                }
                libraries[0] = new File(root, "libraries/zlibwapi.dll");
                libraries[1] = new File(root, "libraries/miniunz.dll");
                libraries[2] = new File(root, "libraries/FMUSimulator.dll");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File[] fileArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            File library = fileArray[n2];
            if (library == null) {
                System.err.println("FMU library not loaded. FMU simulation not working.");
            } else if (!library.isFile()) {
                System.err.println(String.valueOf(library.getAbsolutePath()) + " not found");
            } else {
                try {
                    System.load(library.getAbsolutePath());
                }
                catch (Throwable t) {
                    System.err.println(t.getMessage());
                }
            }
            ++n2;
        }
        File dir = Simantics.getTemporaryDirectory((String)TEMP_FMU_DIRECTORY_NAME);
        TEMP_FMU_COMMON_DIRECTORY = dir.getAbsolutePath();
    }

    public FMUControlJNI() {
        File tempDir = new File(TEMP_FMU_COMMON_DIRECTORY, UUID.randomUUID().toString());
        tempDir.mkdir();
        this.TEMP_FMU_DIRECTORY = tempDir.getAbsolutePath();
        this.dirName = UUID.randomUUID().toString();
        File fmuDir = new File(this.TEMP_FMU_DIRECTORY, this.dirName);
        fmuDir.mkdir();
        this.TEMP_FOLDER_1 = fmuDir.toString();
        this.TEMP_FOLDER_2 = String.valueOf(fmuDir.toString()) + "_2";
        this.lockFMUDirectory();
    }

    public String getModelID() {
        return this.dirName;
    }

    public String getFmuDir() {
        return this.fmuDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFMUFile(String path) throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            if (this.fmuN % 2 == 0) {
                this.fmuDir = this.TEMP_FOLDER_1;
                ++this.fmuN;
            } else {
                this.fmuDir = this.TEMP_FOLDER_2;
                this.fmuN = 0;
            }
            File tempDir = new File(this.fmuDir);
            if (tempDir.isDirectory()) {
                try {
                    FileUtils.deleteAll((File)tempDir);
                }
                catch (IOException iOException) {
                    throw new FMUJNIException("Could not create temp folder for fmu");
                }
                tempDir.mkdir();
            } else {
                tempDir.mkdir();
            }
            try {
                int ret;
                String tmpPath = tempDir.getAbsolutePath();
                if (!tmpPath.endsWith("\\")) {
                    tmpPath = String.valueOf(tmpPath) + "\\";
                }
                if ((ret = this.loadFMUFile_(this.getModelID(), path, tmpPath)) == ERROR) {
                    throw new FMUJNIException(this.getLastErrorMessage());
                }
                this.fmuLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native int loadFMUFile_(String var1, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStepLength(double step) throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.setStepLength_(this.getModelID(), step);
                if (ret == ERROR) {
                    throw new FMUJNIException(this.getLastErrorMessage());
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native int setStepLength_(String var1, double var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiateSimulation() throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.instantiateSimulation_(this.getModelID());
                if (ret == ERROR) {
                    throw new FMUJNIException(this.getLastErrorMessage());
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native int instantiateSimulation_(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeSimulation() throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.initializeSimulation_(this.getModelID());
                if (ret == ERROR) {
                    throw new FMUJNIException(this.getLastErrorMessage());
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native int initializeSimulation_(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String[] variables) throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.subscribe_(this.getModelID(), variables, variables.length);
                if (ret == ERROR) {
                    throw new FMUJNIException(this.getLastErrorMessage());
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native int subscribe_(String var1, String[] var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRealValue(String name, double value) throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.setRealValue_(this.getModelID(), name, value);
                if (ret == ERROR) {
                    throw new FMUJNIException(this.getLastErrorMessage());
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native int setRealValue_(String var1, String var2, double var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntegerValue(String name, int value) throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.setIntegerValue_(this.getModelID(), name, value);
                if (ret == ERROR) {
                    throw new FMUJNIException(this.getLastErrorMessage());
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native int setIntegerValue_(String var1, String var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBooleanValue(String name, boolean value) throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.setBooleanValue_(this.getModelID(), name, value);
                if (ret == ERROR) {
                    throw new FMUJNIException(this.getLastErrorMessage());
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native int setBooleanValue_(String var1, String var2, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(double time) throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.setTime_(this.getModelID(), time);
                if (ret == ERROR) {
                    throw new FMUJNIException(this.getLastErrorMessage());
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native int setTime_(String var1, double var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulateStep() throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.simulateStep_(this.getModelID());
                if (ret == ERROR) {
                    throw new FMUJNIException(this.getLastErrorMessage());
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native int simulateStep_(String var1);

    public double[] getSubscribedResults(double[] results) throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.getSubscribedResults_(this.getModelID(), results);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native double[] getSubscribedResults_(String var1, double[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadFMU() throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret;
                this.unlockFMUDirectory();
                if (this.fmuLoaded && (ret = this.unloadFMU_(this.getModelID())) == ERROR) {
                    throw new FMUJNIException(this.getLastErrorMessage());
                }
                this.removeFMUDirectoryContents();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native int unloadFMU_(String var1);

    public boolean isInitialized() throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.isInitialized_(this.getModelID());
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native boolean isInitialized_(String var1);

    public double getTime() throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.getTime_(this.getModelID());
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native double getTime_(String var1);

    public String[] getAllVariables() throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.getAllVariables_(this.getModelID());
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native String[] getAllVariables_(String var1);

    public String[] filterVariables(String regexp) throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.filterVariables_(this.getModelID(), String.valueOf(regexp) + "|time");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native String[] filterVariables_(String var1, String var2);

    public String getLastErrorMessage() throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.getLastErrorMessage_(this.getModelID());
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native String getLastErrorMessage_(String var1);

    public double getRealValue(String name) throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.getRealValue_(this.getModelID(), name);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native double getRealValue_(String var1, String var2);

    public String getStringValue(String name) throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.getStringValue_(this.getModelID(), name);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native String getStringValue_(String var1, String var2);

    public int getIntegerValue(String name) throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.getIntegerValue_(this.getModelID(), name);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native int getIntegerValue_(String var1, String var2);

    public boolean getBooleanValue(String name) throws FMUJNIException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.getBooleanValue_(this.getModelID(), name);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new FMUJNIException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMUJNIException(e.getMessage());
            }
        }
    }

    private native boolean getBooleanValue_(String var1, String var2);

    private boolean lockFMUDirectory() {
        try {
            File lockFile = new File(this.TEMP_FMU_DIRECTORY, LOCK_FILE_NAME);
            if (!lockFile.isFile()) {
                lockFile.createNewFile();
            }
            this.channel = new RandomAccessFile(lockFile, "rw").getChannel();
            this.lock = this.channel.lock();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private boolean unlockFMUDirectory() {
        try {
            if (this.lock != null) {
                this.lock.release();
            }
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private boolean removeFMUDirectoryContents() {
        try {
            File tempDir = new File(this.TEMP_FMU_DIRECTORY);
            FileUtils.deleteAll((File)tempDir);
            tempDir.delete();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

