/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.handler.e4;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.db.UndoContext;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.SWTUtils;

public class UndoRedoTester {
    private static final boolean DEBUG = false;
    private static final String SIMANTICS_UNDO_CONTEXT = "org.simantics.ui.undoContext";
    public static final String UNDO_ENABLED = "org.simantics.undo.enabled";
    private static UndoRedoSupport undoSupport = null;
    private static UndoChangeListener changeListener = new UndoChangeListener();
    private static IContextActivation activation = null;

    private UndoRedoTester() {
    }

    public static boolean canUndo() {
        UndoContext uc;
        block10: {
            Session s;
            block9: {
                block8: {
                    String undoEnabled = System.getProperty(UNDO_ENABLED);
                    if (undoEnabled != null && "false".equals(undoEnabled)) {
                        return false;
                    }
                    ISessionContext ctx = Simantics.getSessionContext();
                    if (ctx == null) {
                        return false;
                    }
                    try {
                        s = ctx.peekSession();
                        if (s != null) break block8;
                        return false;
                    }
                    catch (Exception e) {
                        ErrorLogger.getDefault().logError("Undo/Redo support failed.", (Throwable)e);
                        return false;
                    }
                }
                if (!DatabaseJob.inProgress()) break block9;
                return true;
            }
            if (undoSupport == null) {
                undoSupport = (UndoRedoSupport)s.getService(UndoRedoSupport.class);
                undoSupport.subscribe((UndoRedoSupport.ChangeListener)changeListener);
            }
            if ((uc = undoSupport.getUndoContext(s)) != null) break block10;
            return false;
        }
        boolean ret = !uc.getAll().isEmpty();
        return ret;
    }

    public static boolean canRedo() {
        UndoContext uc;
        block9: {
            Session s;
            block8: {
                block7: {
                    ISessionContext ctx = Simantics.getSessionContext();
                    if (ctx == null) {
                        return false;
                    }
                    try {
                        s = ctx.peekSession();
                        if (s != null) break block7;
                        return false;
                    }
                    catch (Exception e) {
                        ErrorLogger.getDefault().logError("Undo/Redo support failed.", (Throwable)e);
                        return false;
                    }
                }
                if (!DatabaseJob.inProgress()) break block8;
                return true;
            }
            if (undoSupport == null) {
                undoSupport = (UndoRedoSupport)s.getService(UndoRedoSupport.class);
                undoSupport.subscribe((UndoRedoSupport.ChangeListener)changeListener);
            }
            if ((uc = undoSupport.getUndoContext(s)) != null) break block9;
            return false;
        }
        boolean ret = !uc.getRedoList().isEmpty();
        return ret;
    }

    private static class UndoChangeListener
    implements UndoRedoSupport.ChangeListener {
        private int oldUndo = 0;
        private int oldRedo = 0;

        private UndoChangeListener() {
        }

        public void onChanged() {
            Display display = PlatformUI.getWorkbench().getDisplay();
            SWTUtils.asyncExec((Display)display, (Runnable)new Runnable(){

                @Override
                public void run() {
                    this.handleChange();
                }
            });
        }

        private void handleChange() {
            int newUndo = this.oldUndo;
            int newRedo = this.oldRedo;
            try {
                boolean redoOff;
                ISessionContext ctx = SimanticsUI.getSessionContext();
                if (ctx == null) {
                    return;
                }
                Session session = ctx.peekSession();
                if (session == null) {
                    return;
                }
                UndoContext uc = undoSupport.getUndoContext(session);
                if (uc == null) {
                    return;
                }
                newUndo = uc.getAll().size();
                newRedo = uc.getRedoList().size();
                boolean undoOn = this.oldUndo == 0 && newUndo == 1;
                boolean undoOff = this.oldUndo > 0 && newUndo == 0;
                boolean redoOn = this.oldRedo == 0 && newRedo == 1;
                boolean bl = redoOff = this.oldRedo > 0 && newRedo == 0;
                if (undoOn || undoOff || redoOn || redoOff) {
                    this.toggleContext();
                }
            }
            catch (DatabaseException e) {
                ErrorLogger.getDefault().logError("Undo/Redo support failed.", (Throwable)e);
            }
            this.oldUndo = newUndo;
            this.oldRedo = newRedo;
        }

        private void toggleContext() {
            IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
            if (activation != null) {
                try {
                    contextService.deactivateContext(activation);
                }
                catch (Throwable t) {
                    ErrorLogger.getDefault().logError("Undo/Redo support failed.", t);
                }
                activation = null;
            } else {
                try {
                    activation = contextService.activateContext(UndoRedoTester.SIMANTICS_UNDO_CONTEXT);
                }
                catch (Throwable t) {
                    ErrorLogger.getDefault().logError("Undo/Redo support failed.", t);
                    activation = null;
                }
            }
        }
    }
}

