/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.common;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.FontData;
import org.simantics.document.server.io.IFont;
import org.simantics.document.server.io.ITreeTableCell;
import org.simantics.document.server.io.SimpleFont;
import org.simantics.spreadsheet.common.TableCell;

public class TreeTableCell
extends TableCell
implements ITreeTableCell {
    private int parent = -1;
    private boolean editable = true;
    private Object data;

    public TreeTableCell() {
    }

    public TreeTableCell(String text, Object data, Object font, int parent, int row, int column, boolean editable) {
        super(column, row, 0, 0, text, (IFont)font, null, null, false, 1, 1);
        this.editable = editable;
        this.parent = parent;
        this.data = data;
    }

    @Override
    public int getRowSpan() {
        throw new IllegalStateException("Row span is not supported in TreeTableCell");
    }

    @Override
    public int getColumnSpan() {
        throw new IllegalStateException("Column span is not supported in TreeTableCell");
    }

    public static TreeTableCell createTreeTableCell(String text, Object data, Object font, int parent, int row, int column, boolean editable) {
        return new TreeTableCell(text, data, TreeTableCell.extractIFont(font), parent, row, column, editable);
    }

    private static IFont extractIFont(Object font) {
        if (font instanceof FontDescriptor) {
            FontDescriptor descriptor = (FontDescriptor)font;
            String family = "";
            String style = "";
            int size = 12;
            FontData[] fontDataArray = descriptor.getFontData();
            int n = fontDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                FontData d = fontDataArray[n2];
                family = d.getName();
                if ((d.getStyle() & 2) != 0) {
                    style = String.valueOf(style) + "Italic";
                }
                if ((d.getStyle() & 1) != 0) {
                    style = String.valueOf(style) + "Bold";
                }
                size = d.getHeight();
                ++n2;
            }
            return new SimpleFont(family, style, size);
        }
        return null;
    }

    public void setParent(int parent) {
        this.parent = parent;
    }

    public int getParent() {
        return this.parent;
    }

    public Object getData() {
        return this.data;
    }

    public boolean isEditable() {
        return this.editable;
    }
}

