/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.rest;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.simantics.scl.rest.SCLAPI;

@Path(value="SCLAPI")
@Produces(value={"application/json"})
public class SCLRESTAPI {
    private SCLAPI sclAPI = SCLAPI.getInstance();

    private static Map<String, Object> buildJSONResponse(Object ... keyValues) {
        if (keyValues.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid amount of arguments! " + Arrays.toString(keyValues));
        }
        HashMap<String, Object> results = new HashMap<String, Object>(keyValues.length / 2);
        int i = 0;
        while (i < keyValues.length) {
            Object key = keyValues[i];
            Object value = keyValues[i + 1];
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Key with index " + i + " is not String");
            }
            results.put((String)key, value);
            i += 2;
        }
        return results;
    }

    @Path(value="/sessions")
    @POST
    public Response sessions() {
        String sessionId = UUID.randomUUID().toString();
        this.sclAPI.getOrCreateCommandSession(sessionId);
        return Response.ok(SCLRESTAPI.buildJSONResponse("sessionId", sessionId)).build();
    }

    @Path(value="/sessions/{sessionId}/modules/{moduleName:.*}")
    @PUT
    public Response upload(@PathParam(value="sessionId") String sessionId, @PathParam(value="moduleName") String moduleName, @FormDataParam(value="file") InputStream inputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) throws IOException {
        String moduleText = SCLRESTAPI.getModuleText(inputStream);
        String response = this.sclAPI.putModule(sessionId, moduleName, moduleText);
        if (response == null) {
            return Response.ok().build();
        }
        return Response.status((int)422).entity(SCLRESTAPI.buildJSONResponse("response", response)).build();
    }

    private static String getModuleText(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(StandardCharsets.UTF_8.name());
    }

    @Path(value="/sessions/{sessionId}/execute")
    @POST
    @Produces(value={"text/plain"})
    public Response execute(@PathParam(value="sessionId") String sessionId, @FormDataParam(value="command") String command) {
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(command.getBytes(StandardCharsets.UTF_8)));
        return Response.ok(output -> {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));){
                this.sclAPI.execute(sessionId, reader, writer);
                ((Writer)writer).flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }).build();
    }

    @Path(value="/sessions/{sessionId}/variables/{variableName}")
    @GET
    public Response variableValue(@PathParam(value="sessionId") String sessionId, @PathParam(value="variableName") String variableName) {
        Object value = this.sclAPI.variableValue(sessionId, variableName);
        return Response.ok(SCLRESTAPI.buildJSONResponse("sessionId", sessionId, "variableName", variableName, "variableValue", value)).build();
    }

    @Path(value="/sessions/{sessionId}/close")
    @POST
    public Response sessions(@PathParam(value="sessionId") String sessionId) {
        this.sclAPI.deleteCommandSession(sessionId);
        return Response.ok().build();
    }
}

