/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.handler;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ErrorLogger;

public class DenyAction
extends Action {
    private final String virtualGraphId;
    private final List<Resource> subjects;
    private final String relationURI;

    public DenyAction(String label, ImageDescriptor image, String virtualGraphId, String relationURI, List<Resource> subjects) {
        super(label, image);
        this.virtualGraphId = virtualGraphId;
        this.subjects = subjects;
        this.relationURI = relationURI;
    }

    public void run() {
        Session session = Simantics.peekSession();
        if (session != null) {
            VirtualGraph vg = this.virtualGraphId == null ? null : ((VirtualGraphSupport)session.getService(VirtualGraphSupport.class)).getWorkspacePersistent(this.virtualGraphId);
            session.asyncRequest((Write)new WriteRequest(vg){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Resource relation = graph.getResource(DenyAction.this.relationURI);
                    for (Resource subject : DenyAction.this.subjects) {
                        graph.deny(subject, relation);
                    }
                }
            }, (Callback)new Callback<DatabaseException>(){

                public void run(DatabaseException parameter) {
                    if (parameter != null) {
                        ErrorLogger.defaultLogError((Throwable)parameter);
                    }
                }
            });
        }
    }
}

