/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modelica.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.simantics.modelica.data.DataSet;
import org.simantics.modelica.data.Mat4Reader;
import org.simantics.modelica.data.SimulationResult;
import org.simantics.modelica.reader.MatFileReader;

public class MatSimulationResult
extends SimulationResult {
    @Override
    public void read(InputStream stream, int interval) {
        Map<String, double[]> valueMap = null;
        try {
            valueMap = Mat4Reader.read(stream, interval);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        double[] allTimes = valueMap.get("time");
        if (allTimes.length > 0) {
            double[] parameterTimes = new double[]{allTimes[0], allTimes[allTimes.length - 1]};
            for (String key : valueMap.keySet()) {
                double[] values = valueMap.get(key);
                DataSet ds = values.length == 2 ? new DataSet(key, parameterTimes, values) : new DataSet(key, allTimes, values);
                this.variables.add(ds);
            }
        }
    }

    @Override
    public void initRead(File file) throws FileNotFoundException, IOException {
        super.initRead(file);
        this.resultFileReader = new MatFileReader(file);
    }
}

