/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.backup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.simantics.backup.Activator;
import org.simantics.backup.BackupException;
import org.simantics.backup.Backups;
import org.simantics.backup.IBackupProvider;

public class BackupProviderService {
    private static volatile int threadCounter = 0;

    public static void backup(String targetPath, int revision) throws BackupException {
        BackupProviderService.backup(Paths.get(targetPath, new String[0]), revision, null);
    }

    public static void backup(Path targetPath, int revision, Consumer<BackupException> callback) throws BackupException {
        List<IBackupProvider> providers = BackupProviderService.getBackupProviders();
        try {
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectories(targetPath, new FileAttribute[0]);
            }
            Backups.lock(providers);
            new Thread(() -> {
                BackupException problem;
                block14: {
                    boolean unlockedAlready = false;
                    problem = null;
                    try {
                        List<Future<BackupException>> backups = Backups.syncBackup(providers, targetPath, revision);
                        Backups.unlock(providers);
                        unlockedAlready = true;
                        ArrayList<Exception> exceptions = new ArrayList<Exception>(backups.size());
                        for (Future<BackupException> f : backups) {
                            try {
                                Exception e2 = f.get();
                                if (e2 == null) continue;
                                exceptions.add(e2);
                            }
                            catch (InterruptedException | ExecutionException e3) {
                                exceptions.add(e3);
                            }
                        }
                        if (!exceptions.isEmpty()) {
                            IStatus[] ss = (IStatus[])exceptions.stream().map(e -> new Status(4, "org.simantics.backup", e.getMessage(), (Throwable)e)).toArray(IStatus[]::new);
                            problem = new BackupException((Throwable)new CoreException((IStatus)new MultiStatus("org.simantics.backup", 0, ss, "Backup operation(s) failed to complete.", null)));
                        }
                    }
                    catch (BackupException e4) {
                        problem = e4;
                        if (!unlockedAlready) {
                            Backups.unlock(providers);
                        }
                        break block14;
                    }
                    catch (Throwable t) {
                        try {
                            problem = new BackupException(t);
                            break block14;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (!unlockedAlready) {
                                Backups.unlock(providers);
                            }
                        }
                    }
                    if (unlockedAlready) break block14;
                    Backups.unlock(providers);
                }
                if (callback != null) {
                    callback.accept(problem);
                }
            }, "Backup thread " + ++threadCounter).start();
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
    }

    public static void restore(Path fromPath, int revision) throws BackupException {
        BackupProviderService.restore(BackupProviderService.getBackupProviders(), fromPath, revision);
    }

    private static void restore(Collection<IBackupProvider> providers, Path fromPath, int revision) throws BackupException {
        for (IBackupProvider provider : providers) {
            provider.restore(fromPath, revision);
        }
    }

    private static List<IBackupProvider> getBackupProviders() throws BackupException {
        try {
            ArrayList<IBackupProvider> results = new ArrayList<IBackupProvider>();
            Collection backupProviders = Activator.getContext().getServiceReferences(IBackupProvider.class, null);
            for (ServiceReference reference : backupProviders) {
                results.add((IBackupProvider)Activator.getContext().getService(reference));
            }
            return results;
        }
        catch (InvalidSyntaxException e) {
            throw new BackupException("Failed to enumerate backup providers.", e);
        }
    }
}

